/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config.lists;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.client.screen.IGuiComponent;
import com.bisecthosting.mods.bhmenu.client.screen.PressableButton;
import com.bisecthosting.mods.bhmenu.config.ModuleConfigScreen;
import com.bisecthosting.mods.bhmenu.config.components.ConfigButtonComponent;
import com.bisecthosting.mods.bhmenu.config.components.toggle.TickBoxConfigComponent;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class ModuleSelectionList
extends GuiListExtended {
    private GuiScreen parent;
    private List<Entry> entries;

    public ModuleSelectionList(GuiScreen parent, Minecraft mc, int width, int height, int y0, int y1, int itemHeight) {
        super(mc, width, height, y0, y1, itemHeight);
        this.parent = parent;
        this.entries = new ArrayList<Entry>();
    }

    public void addPackEntry(IModule module) {
        this.entries.add(new PackEntry(module));
    }

    public void addUserEntry(IModule module) {
        this.entries.add(new UserEntry(module));
    }

    public void saveAll() {
        for (Entry entry : this.entries) {
            entry.save();
        }
    }

    protected int func_148137_d() {
        return this.field_148151_d - 6;
    }

    public int func_148139_c() {
        return Math.min(this.field_148155_a - 40, 260);
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int i) {
        return this.entries.get(i);
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    public class UserEntry
    extends Entry {
        private final GuiButton configButton;
        private final List<GuiButton> children;

        public UserEntry(IModule module) {
            this.configButton = new PressableButton(1, 0, 0, 0, 20, I18n.func_135052_a((String)("screen.config.modules." + module.getId() + ".name"), (Object[])new Object[0]), b -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new ModuleConfigScreen(ModuleSelectionList.this.parent, module, module::populateUserConfigs)));
            if (!module.hasUserConfigs()) {
                this.configButton.field_146124_l = false;
            }
            this.children = Lists.newArrayList((Object[])new GuiButton[]{this.configButton});
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            this.configButton.field_146128_h = x + 30;
            this.configButton.func_175211_a(listWidth - 30);
            this.children.forEach(child -> {
                child.field_146129_i = y;
                if (child instanceof IGuiComponent) {
                    ((IGuiComponent)child).draw(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
                    return;
                }
                child.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
            });
        }

        @Override
        public void save() {
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            for (GuiButton child : this.children) {
                if (!child.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) continue;
                child.func_146113_a(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
            return false;
        }

        public void func_148277_b(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        }
    }

    public class PackEntry
    extends Entry {
        private final IModule module;
        private final ConfigButtonComponent toggle;
        private final GuiButton configButton;
        private final List<GuiButton> children;

        public PackEntry(IModule module) {
            this.module = module;
            this.toggle = new TickBoxConfigComponent(0, new BooleanHolder(ModRoot.get().modules.getEnabledValue(module.getId())), 0, 0, 20, 20);
            this.configButton = new PressableButton(1, 0, 0, 0, 20, I18n.func_135052_a((String)("screen.config.modules." + module.getId() + ".name"), (Object[])new Object[0]), b -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new ModuleConfigScreen(ModuleSelectionList.this.parent, module, module::populatePackConfigs)));
            if (!module.hasPackConfigs()) {
                this.configButton.field_146124_l = false;
            }
            this.children = Lists.newArrayList((Object[])new GuiButton[]{this.toggle, this.configButton});
        }

        public void func_192633_a(int i, int i1, int i2, float v) {
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            this.toggle.field_146128_h = x;
            this.configButton.field_146128_h = x + 30;
            this.configButton.func_175211_a(listWidth - 30);
            this.children.forEach(child -> {
                child.field_146129_i = y;
                if (child instanceof IGuiComponent) {
                    ((IGuiComponent)child).draw(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
                    return;
                }
                child.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
            });
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            for (GuiButton child : this.children) {
                if (!child.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) continue;
                child.func_146113_a(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
            return false;
        }

        public void func_148277_b(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        }

        @Override
        public void save() {
            this.toggle.save();
        }
    }

    public static abstract class Entry
    implements GuiListExtended.IGuiListEntry {
        public abstract void save();
    }
}

