/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.handler;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Method;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import tschipp.carryon.common.config.CarryOnConfig;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.item.ItemTile;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;

public class PickupHandler {
    public static boolean canPlayerPickUpBlock(EntityPlayer player, @Nullable TileEntity tile, World world, BlockPos pos) {
        block12: {
            double distance;
            CarryOnOverride override;
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            NBTTagCompound tag = new NBTTagCompound();
            if (tile != null) {
                tile.func_189515_b(tag);
            }
            if ((override = ScriptChecker.inspectBlock(world.func_180495_p(pos), world, pos, tag)) != null) {
                return ScriptChecker.fulfillsConditions(override, player) && PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
            }
            if (CarryOnConfig.settings.useWhitelistBlocks ? !ListHandler.isAllowed(world.func_180495_p(pos).func_177230_c()) : ListHandler.isForbidden(world.func_180495_p(pos).func_177230_c())) {
                return false;
            }
            if ((block.func_176195_g(state, world, pos) != -1.0f || player.func_184812_l_()) && (distance = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v)) < Math.pow(CarryOnConfig.settings.maxDistance, 2.0) && !ItemTile.isLocked(pos, world)) {
                if (CustomPickupOverrideHandler.hasSpecialPickupConditions(state)) {
                    try {
                        Class<?> gameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
                        Class<?> iStageData = Class.forName("net.darkhax.gamestages.data.IStageData");
                        Method getPlayerData = ReflectionHelper.findMethod(gameStageHelper, (String)"getPlayerData", null, (Class[])new Class[]{EntityPlayer.class});
                        Method hasStage = ReflectionHelper.findMethod(iStageData, (String)"hasStage", null, (Class[])new Class[]{String.class});
                        Object stageData = getPlayerData.invoke(null, player);
                        String condition = CustomPickupOverrideHandler.getPickupCondition(state);
                        boolean has = (Boolean)hasStage.invoke(stageData, condition);
                        if (has) {
                            return PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        try {
                            Class<?> playerDataHandler = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler");
                            Class<?> iStageData = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler$IStageData");
                            Method getStageData = ReflectionHelper.findMethod(playerDataHandler, (String)"getStageData", null, (Class[])new Class[]{EntityPlayer.class});
                            Method hasUnlockedStage = ReflectionHelper.findMethod(iStageData, (String)"hasUnlockedStage", null, (Class[])new Class[]{String.class});
                            Object stageData = getStageData.invoke(null, player);
                            String condition = CustomPickupOverrideHandler.getPickupCondition(state);
                            boolean has = (Boolean)hasUnlockedStage.invoke(stageData, condition);
                            if (has) {
                                return PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
                            }
                            break block12;
                        }
                        catch (Exception ex) {
                            return PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
                        }
                    }
                }
                if (CarryOnConfig.settings.pickupAllBlocks || tile != null) {
                    return PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
                }
            }
        }
        return false;
    }

    public static boolean canPlayerPickUpEntity(EntityPlayer player, Entity toPickUp) {
        block34: {
            double distance;
            boolean has;
            String condition;
            Object stageData;
            Class<?> iStageData;
            BlockPos pos;
            block33: {
                EntityAgeable living;
                pos = toPickUp.func_180425_c();
                if (toPickUp instanceof EntityPlayer) {
                    return false;
                }
                if (toPickUp.field_70128_L) {
                    return false;
                }
                CarryOnOverride override = ScriptChecker.inspectEntity(toPickUp);
                if (override != null) {
                    return ScriptChecker.fulfillsConditions(override, player) && PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                }
                if (toPickUp instanceof EntityAgeable && CarryOnConfig.settings.allowBabies && ((living = (EntityAgeable)toPickUp).func_70874_b() < 0 || living.func_70631_g_())) {
                    EntityTameable tame;
                    double distance2 = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v);
                    if (distance2 < Math.pow(CarryOnConfig.settings.maxDistance, 2.0) && toPickUp instanceof EntityTameable && (tame = (EntityTameable)toPickUp).func_184753_b() != null) {
                        if (tame.func_184753_b() != EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH())) {
                            return false;
                        }
                    }
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(toPickUp)) {
                        try {
                            Class<?> gameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
                            iStageData = Class.forName("net.darkhax.gamestages.data.IStageData");
                            Method getPlayerData = ReflectionHelper.findMethod(gameStageHelper, (String)"getPlayerData", null, (Class[])new Class[]{EntityPlayer.class});
                            Method hasStage = ReflectionHelper.findMethod(iStageData, (String)"hasStage", null, (Class[])new Class[]{String.class});
                            stageData = getPlayerData.invoke(null, player);
                            condition = CustomPickupOverrideHandler.getPickupCondition(toPickUp);
                            has = (Boolean)hasStage.invoke(stageData, condition);
                            if (has) {
                                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                            }
                            break block33;
                        }
                        catch (Exception e) {
                            try {
                                Class<?> playerDataHandler = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler");
                                Class<?> iStageData2 = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler$IStageData");
                                Method getStageData = ReflectionHelper.findMethod(playerDataHandler, (String)"getStageData", null, (Class[])new Class[]{EntityPlayer.class});
                                Method hasUnlockedStage = ReflectionHelper.findMethod(iStageData2, (String)"hasUnlockedStage", null, (Class[])new Class[]{String.class});
                                Object stageData2 = getStageData.invoke(null, player);
                                String condition2 = CustomPickupOverrideHandler.getPickupCondition(toPickUp);
                                boolean has2 = (Boolean)hasUnlockedStage.invoke(stageData2, condition2);
                                if (has2) {
                                    return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                                }
                                break block33;
                            }
                            catch (Exception ex) {
                                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                            }
                        }
                    }
                    return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                }
            }
            if (CarryOnConfig.settings.useWhitelistEntities ? !ListHandler.isAllowed(toPickUp) : ListHandler.isForbidden(toPickUp)) {
                return false;
            }
            if (toPickUp instanceof EntityTameable) {
                double distance3;
                EntityTameable tamecheck = (EntityTameable)toPickUp;
                UUID OwnerCheck = tamecheck.func_184753_b();
                if ((CarryOnConfig.settings.pickupHostileMobs || !toPickUp.isCreatureType(EnumCreatureType.MONSTER, false) || CarryOnConfig.settings.tamedHostileMobExemption && OwnerCheck != null || player.func_184812_l_()) && (CarryOnConfig.settings.pickupHostileMobs || !toPickUp.isCreatureType(EnumCreatureType.MONSTER, false) || CarryOnConfig.settings.tamedHostileMobExemption && OwnerCheck != null || player.func_184812_l_()) && (toPickUp.field_70131_O <= CarryOnConfig.settings.maxEntityHeight && toPickUp.field_70130_N <= CarryOnConfig.settings.maxEntityWidth || player.func_184812_l_()) && (distance3 = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v)) < Math.pow(CarryOnConfig.settings.maxDistance, 2.0)) {
                    UUID playerID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
                    if (OwnerCheck != null && !OwnerCheck.equals(playerID)) {
                        return false;
                    }
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(toPickUp)) {
                        try {
                            Class<?> gameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
                            Class<?> iStageData3 = Class.forName("net.darkhax.gamestages.data.IStageData");
                            Method getPlayerData = ReflectionHelper.findMethod(gameStageHelper, (String)"getPlayerData", null, (Class[])new Class[]{EntityPlayer.class});
                            Method hasStage = ReflectionHelper.findMethod(iStageData3, (String)"hasStage", null, (Class[])new Class[]{String.class});
                            Object stageData3 = getPlayerData.invoke(null, player);
                            String condition3 = CustomPickupOverrideHandler.getPickupCondition(toPickUp);
                            boolean has3 = (Boolean)hasStage.invoke(stageData3, condition3);
                            if (has3) {
                                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                            }
                            break block34;
                        }
                        catch (Exception e) {
                            try {
                                Class<?> playerDataHandler = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler");
                                Class<?> iStageData4 = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler$IStageData");
                                Method getStageData = ReflectionHelper.findMethod(playerDataHandler, (String)"getStageData", null, (Class[])new Class[]{EntityPlayer.class});
                                Method hasUnlockedStage = ReflectionHelper.findMethod(iStageData4, (String)"hasUnlockedStage", null, (Class[])new Class[]{String.class});
                                Object stageData4 = getStageData.invoke(null, player);
                                String condition4 = CustomPickupOverrideHandler.getPickupCondition(toPickUp);
                                boolean has4 = (Boolean)hasUnlockedStage.invoke(stageData4, condition4);
                                if (has4) {
                                    return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                                }
                                break block34;
                            }
                            catch (Exception ex) {
                                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                            }
                        }
                    }
                    return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                }
            } else if ((CarryOnConfig.settings.pickupHostileMobs || !toPickUp.isCreatureType(EnumCreatureType.MONSTER, false) || player.func_184812_l_()) && (CarryOnConfig.settings.pickupHostileMobs || !toPickUp.isCreatureType(EnumCreatureType.MONSTER, false) || player.func_184812_l_()) && (toPickUp.field_70131_O <= CarryOnConfig.settings.maxEntityHeight && toPickUp.field_70130_N <= CarryOnConfig.settings.maxEntityWidth || player.func_184812_l_()) && (distance = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v)) < Math.pow(CarryOnConfig.settings.maxDistance, 2.0)) {
                if (CustomPickupOverrideHandler.hasSpecialPickupConditions(toPickUp)) {
                    try {
                        Class<?> gameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
                        Class<?> iStageData5 = Class.forName("net.darkhax.gamestages.data.IStageData");
                        Method getPlayerData = ReflectionHelper.findMethod(gameStageHelper, (String)"getPlayerData", null, (Class[])new Class[]{EntityPlayer.class});
                        Method hasStage = ReflectionHelper.findMethod(iStageData5, (String)"hasStage", null, (Class[])new Class[]{String.class});
                        Object stageData5 = getPlayerData.invoke(null, player);
                        String condition5 = CustomPickupOverrideHandler.getPickupCondition(toPickUp);
                        boolean has5 = (Boolean)hasStage.invoke(stageData5, condition5);
                        if (has5) {
                            return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                        }
                        break block34;
                    }
                    catch (Exception e) {
                        try {
                            Class<?> playerDataHandler = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler");
                            iStageData = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler$IStageData");
                            Method getStageData = ReflectionHelper.findMethod(playerDataHandler, (String)"getStageData", null, (Class[])new Class[]{EntityPlayer.class});
                            Method hasUnlockedStage = ReflectionHelper.findMethod(iStageData, (String)"hasUnlockedStage", null, (Class[])new Class[]{String.class});
                            stageData = getStageData.invoke(null, player);
                            condition = CustomPickupOverrideHandler.getPickupCondition(toPickUp);
                            has = (Boolean)hasUnlockedStage.invoke(stageData, condition);
                            if (has) {
                                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                            }
                            break block34;
                        }
                        catch (Exception ex) {
                            return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                        }
                    }
                }
                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
            }
        }
        return false;
    }

    private static boolean handleProtections(EntityPlayerMP player, World world, BlockPos pos, IBlockState state) {
        boolean breakable = true;
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            breakable = false;
        }
        return breakable;
    }

    private static boolean handleProtections(EntityPlayerMP player, Entity entity) {
        boolean canPickup = true;
        AttackEntityEvent event = new AttackEntityEvent((EntityPlayer)player, entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            canPickup = false;
        }
        return canPickup;
    }
}

