/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import tschipp.carryon.common.config.CarryOnConfig;

public class ListHandler {
    public static List<String> FORBIDDEN_TILES;
    public static List<String> FORBIDDEN_ENTITIES;
    public static List<String> ALLOWED_ENTITIES;
    public static List<String> ALLOWED_TILES;
    public static List<String> FORBIDDEN_STACKING;
    public static List<String> ALLOWED_STACKING;

    public static boolean isForbidden(Block block) {
        String name = block.getRegistryName().toString();
        if (FORBIDDEN_TILES.contains(name)) {
            return true;
        }
        boolean contains = false;
        for (String s : FORBIDDEN_TILES) {
            if (!s.contains("*") || !name.contains(s.replace("*", ""))) continue;
            contains = true;
        }
        return contains;
    }

    public static boolean isForbidden(Entity entity) {
        if (EntityList.func_191301_a((Entity)entity) != null) {
            String name = EntityList.func_191301_a((Entity)entity).toString();
            boolean contains = FORBIDDEN_ENTITIES.contains(name);
            return contains;
        }
        return true;
    }

    public static boolean isAllowed(Entity entity) {
        if (EntityList.func_191301_a((Entity)entity) != null) {
            String name = EntityList.func_191301_a((Entity)entity).toString();
            boolean contains = ALLOWED_ENTITIES.contains(name);
            return contains;
        }
        return true;
    }

    public static boolean isStackingForbidden(Entity entity) {
        if (EntityList.func_191301_a((Entity)entity) != null) {
            String name = EntityList.func_191301_a((Entity)entity).toString();
            boolean contains = FORBIDDEN_STACKING.contains(name);
            return contains;
        }
        return true;
    }

    public static boolean isStackingAllowed(Entity entity) {
        if (EntityList.func_191301_a((Entity)entity) != null) {
            String name = EntityList.func_191301_a((Entity)entity).toString();
            boolean contains = ALLOWED_STACKING.contains(name);
            return contains;
        }
        return true;
    }

    public static boolean isAllowed(Block block) {
        String name = block.getRegistryName().toString();
        if (ALLOWED_TILES.contains(name)) {
            return true;
        }
        boolean contains = false;
        for (String s : ALLOWED_TILES) {
            if (!s.contains("*") || !name.contains(s.replace("*", ""))) continue;
            contains = true;
        }
        return contains;
    }

    public static void initLists() {
        String[] forbidden = CarryOnConfig.blacklist.forbiddenTiles;
        FORBIDDEN_TILES = new ArrayList<String>();
        for (int i = 0; i < forbidden.length; ++i) {
            FORBIDDEN_TILES.add(forbidden[i]);
        }
        String[] forbiddenEntity = CarryOnConfig.blacklist.forbiddenEntities;
        FORBIDDEN_ENTITIES = new ArrayList<String>();
        for (int i = 0; i < forbiddenEntity.length; ++i) {
            if (forbiddenEntity[i].contains("*")) {
                String modid = forbiddenEntity[i].replace("*", "");
                for (int k = 0; k < ForgeRegistries.ENTITIES.getKeys().size(); ++k) {
                    if (!ForgeRegistries.ENTITIES.getKeys().toArray()[k].toString().contains(modid)) continue;
                    FORBIDDEN_ENTITIES.add(ForgeRegistries.ENTITIES.getKeys().toArray()[k].toString());
                }
            }
            FORBIDDEN_ENTITIES.add(forbiddenEntity[i]);
        }
        String[] allowedEntities = CarryOnConfig.whitelist.allowedEntities;
        ALLOWED_ENTITIES = new ArrayList<String>();
        for (int i = 0; i < allowedEntities.length; ++i) {
            if (allowedEntities[i].contains("*")) {
                String modid = allowedEntities[i].replace("*", "");
                for (int k = 0; k < ForgeRegistries.ENTITIES.getKeys().size(); ++k) {
                    if (!ForgeRegistries.ENTITIES.getKeys().toArray()[k].toString().contains(modid)) continue;
                    ALLOWED_ENTITIES.add(ForgeRegistries.ENTITIES.getKeys().toArray()[k].toString());
                }
            }
            ALLOWED_ENTITIES.add(allowedEntities[i]);
        }
        String[] allowedBlocks = CarryOnConfig.whitelist.allowedBlocks;
        ALLOWED_TILES = new ArrayList<String>();
        for (int i = 0; i < allowedBlocks.length; ++i) {
            ALLOWED_TILES.add(allowedBlocks[i]);
        }
        String[] forbiddenStacking = CarryOnConfig.blacklist.forbiddenStacking;
        FORBIDDEN_STACKING = new ArrayList<String>();
        for (int i = 0; i < forbiddenStacking.length; ++i) {
            if (forbiddenStacking[i].contains("*")) {
                String modid = forbiddenStacking[i].replace("*", "");
                for (int k = 0; k < ForgeRegistries.ENTITIES.getKeys().size(); ++k) {
                    if (!ForgeRegistries.ENTITIES.getKeys().toArray()[k].toString().contains(modid)) continue;
                    FORBIDDEN_STACKING.add(ForgeRegistries.ENTITIES.getKeys().toArray()[k].toString());
                }
            }
            FORBIDDEN_STACKING.add(forbiddenStacking[i]);
        }
        String[] allowedStacking = CarryOnConfig.whitelist.allowedStacking;
        ALLOWED_STACKING = new ArrayList<String>();
        for (int i = 0; i < allowedStacking.length; ++i) {
            if (allowedStacking[i].contains("*")) {
                String modid = allowedStacking[i].replace("*", "");
                for (int k = 0; k < ForgeRegistries.ENTITIES.getKeys().size(); ++k) {
                    if (!ForgeRegistries.ENTITIES.getKeys().toArray()[k].toString().contains(modid)) continue;
                    ALLOWED_STACKING.add(ForgeRegistries.ENTITIES.getKeys().toArray()[k].toString());
                }
            }
            ALLOWED_STACKING.add(allowedStacking[i]);
        }
    }
}

