/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.materials;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;

public class MaterialHelper {
    private static FifoMap<String, LocalMaterialData> CachedMaterials = new FifoMap(4096);
    public static final LocalMaterialData AIR = MaterialHelper.toLocalMaterialData(DefaultMaterial.AIR, 0);
    public static final LocalMaterialData SANDSTONE = MaterialHelper.toLocalMaterialData(DefaultMaterial.SANDSTONE, 0);
    public static final LocalMaterialData RED_SANDSTONE = MaterialHelper.toLocalMaterialData(DefaultMaterial.RED_SANDSTONE, 0);
    public static final LocalMaterialData LAVA = MaterialHelper.toLocalMaterialData(DefaultMaterial.STATIONARY_LAVA, 0);
    public static final LocalMaterialData WATER = MaterialHelper.toLocalMaterialData(DefaultMaterial.STATIONARY_WATER, 0);
    public static final LocalMaterialData HARDENED_CLAY = MaterialHelper.toLocalMaterialData(DefaultMaterial.HARD_CLAY, 0);
    public static final LocalMaterialData RED_SAND = MaterialHelper.toLocalMaterialData(DefaultMaterial.SAND, 1);
    public static final LocalMaterialData COARSE_DIRT = MaterialHelper.toLocalMaterialData(DefaultMaterial.DIRT, 1);
    public static final LocalMaterialData WHITE_STAINED_CLAY = MaterialHelper.toLocalMaterialData(DefaultMaterial.STAINED_CLAY, 0);
    public static final LocalMaterialData ORANGE_STAINED_CLAY = MaterialHelper.toLocalMaterialData(DefaultMaterial.STAINED_CLAY, 1);
    public static final LocalMaterialData YELLOW_STAINED_CLAY = MaterialHelper.toLocalMaterialData(DefaultMaterial.STAINED_CLAY, 4);
    public static final LocalMaterialData BROWN_STAINED_CLAY = MaterialHelper.toLocalMaterialData(DefaultMaterial.STAINED_CLAY, 12);
    public static final LocalMaterialData RED_STAINED_CLAY = MaterialHelper.toLocalMaterialData(DefaultMaterial.STAINED_CLAY, 14);
    public static final LocalMaterialData SILVER_STAINED_CLAY = MaterialHelper.toLocalMaterialData(DefaultMaterial.STAINED_CLAY, 8);
    public static final LocalMaterialData GLOWSTONE = MaterialHelper.toLocalMaterialData(DefaultMaterial.GLOWSTONE, 0);
    public static final LocalMaterialData GRASS = MaterialHelper.toLocalMaterialData(DefaultMaterial.GRASS, 0);
    public static final LocalMaterialData DIRT = MaterialHelper.toLocalMaterialData(DefaultMaterial.DIRT, 0);
    public static final LocalMaterialData STONE = MaterialHelper.toLocalMaterialData(DefaultMaterial.STONE, 0);
    public static final LocalMaterialData SNOW_BLOCK = MaterialHelper.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
    public static final LocalMaterialData VINE = MaterialHelper.toLocalMaterialData(DefaultMaterial.VINE, 0);
    public static final LocalMaterialData ICE = MaterialHelper.toLocalMaterialData(DefaultMaterial.ICE, 0);
    public static final LocalMaterialData MAGMA = MaterialHelper.toLocalMaterialData(DefaultMaterial.MAGMA, 0);

    public static LocalMaterialData readMaterial(String name) throws InvalidConfigException {
        if (name == null || name.isEmpty()) {
            return null;
        }
        LocalMaterialData material = (LocalMaterialData)CachedMaterials.get(name);
        if (material != null) {
            return material;
        }
        if (CachedMaterials.containsKey(name)) {
            throw new InvalidConfigException("Cannot read block: " + name);
        }
        String originalName = name;
        if (name.toLowerCase().equals("snow")) {
            name = "SNOW_LAYER:0";
        }
        if (name.toLowerCase().startsWith("snow:")) {
            name = name.toUpperCase().replace("SNOW:", "SNOW_LAYER:");
        } else if (name.toLowerCase().equals("water")) {
            name = "FLOWING_WATER";
        } else if (name.toLowerCase().equals("lava")) {
            name = "FLOWING_LAVA";
        }
        try {
            material = OTG.getEngine().readMaterial(name);
        }
        catch (InvalidConfigException ex) {
            String string = "";
        }
        CachedMaterials.put(originalName, material);
        return material;
    }

    public static LocalMaterialData toLocalMaterialData(DefaultMaterial defaultMaterial, int blockData) {
        return OTG.getEngine().toLocalMaterialData(defaultMaterial, blockData);
    }

    public static boolean isOre(LocalMaterialData material) {
        return material.isMaterial(DefaultMaterial.COAL_ORE) || material.isMaterial(DefaultMaterial.DIAMOND_ORE) || material.isMaterial(DefaultMaterial.EMERALD_ORE) || material.isMaterial(DefaultMaterial.GLOWING_REDSTONE_ORE) || material.isMaterial(DefaultMaterial.GOLD_ORE) || material.isMaterial(DefaultMaterial.IRON_ORE) || material.isMaterial(DefaultMaterial.LAPIS_ORE) || material.isMaterial(DefaultMaterial.QUARTZ_ORE) || material.isMaterial(DefaultMaterial.REDSTONE_ORE);
    }
}

