/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.network;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.ConfigFile;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.BiomeConfigFinder;
import com.pg85.otg.configuration.biome.BiomeLoadInstruction;
import com.pg85.otg.configuration.fallbacks.FallbackConfig;
import com.pg85.otg.configuration.io.FileSettingsReader;
import com.pg85.otg.configuration.io.FileSettingsWriter;
import com.pg85.otg.configuration.io.SettingsMap;
import com.pg85.otg.configuration.standard.BiomeStandardValues;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.util.BiomeIds;
import com.pg85.otg.util.helpers.FileHelper;
import com.pg85.otg.util.minecraft.defaults.BiomeRegistryNames;
import com.pg85.otg.util.minecraft.defaults.DefaultBiome;
import com.pg85.otg.worldsave.BiomeIdData;
import com.pg85.otg.worldsave.WorldSaveData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ServerConfigProvider
implements ConfigProvider {
    private static final int MAX_INHERITANCE_DEPTH = 15;
    private LocalWorld world;
    private File settingsDir;
    private WorldConfig worldConfig;
    private LocalBiome[] biomesByOTGId;
    private int biomesCount;

    public ServerConfigProvider(File settingsDir, LocalWorld world, File worldSaveFolder) {
        this.settingsDir = settingsDir;
        this.world = world;
        this.biomesByOTGId = new LocalBiome[world.getMaxBiomesCount()];
        this.loadSettings(worldSaveFolder, false);
    }

    @Override
    public WorldConfig getWorldConfig() {
        return this.worldConfig;
    }

    @Override
    public LocalBiome getBiomeByOTGIdOrNull(int id) {
        if (id < 0 || id > this.biomesByOTGId.length) {
            return null;
        }
        return this.biomesByOTGId[id];
    }

    private int getRequestedSavedId(String resourceLocation) {
        return this.world.getRegisteredBiomeId(resourceLocation);
    }

    @Override
    public LocalBiome[] getBiomeArrayByOTGId() {
        return this.biomesByOTGId;
    }

    private int getRequestedGenerationId(BiomeConfig biomeConfig) {
        Integer requestedGenerationId = DefaultBiome.getId(biomeConfig.getName());
        if (requestedGenerationId == null) {
            requestedGenerationId = biomeConfig.worldConfig.customBiomeGenerationIds.get(biomeConfig.getName());
        }
        if (requestedGenerationId == null) {
            return -1;
        }
        return requestedGenerationId;
    }

    private void loadSettings(File worldSaveFolder, boolean isReload) {
        SettingsMap worldConfigSettings = this.loadAndInitWorldConfig();
        this.loadFallbacks();
        this.loadBiomes(worldConfigSettings, worldSaveFolder, isReload);
        this.worldConfig.biomeGroupManager.processBiomeData(this.world);
    }

    private void loadFallbacks() {
        File fallbackFile = new File(this.settingsDir, "Fallbacks.ini");
        SettingsMap settingsMap = FileSettingsReader.read(this.world.getName(), fallbackFile);
        FallbackConfig fallbacks = new FallbackConfig(settingsMap);
        this.worldConfig.addWorldFallbacks(fallbacks);
        FileSettingsWriter.writeToFile(fallbacks.getSettingsAsMap(), fallbackFile, OTG.getPluginConfig().settingsMode);
    }

    private SettingsMap loadAndInitWorldConfig() {
        File worldConfigFile = new File(this.settingsDir, "WorldConfig.ini");
        SettingsMap settingsMap = FileSettingsReader.read(this.world.getName(), worldConfigFile);
        ArrayList<String> biomes = new ArrayList<String>();
        File biomesDirectory = new File(this.settingsDir, "WorldBiomes");
        this.addBiomesFromDirRecursive(biomes, biomesDirectory);
        this.worldConfig = new WorldConfig(this.settingsDir, settingsMap, this.world, biomes);
        FileSettingsWriter.writeToFile(this.worldConfig.getSettingsAsMap(), worldConfigFile, this.worldConfig.settingsMode);
        return settingsMap;
    }

    private void addBiomesFromDirRecursive(ArrayList<String> biomes, File biomesDirectory) {
        if (biomesDirectory.exists()) {
            for (File biomeConfig : biomesDirectory.listFiles()) {
                if (biomeConfig.isFile() && biomeConfig.getName().endsWith(BiomeStandardValues.BIOME_CONFIG_EXTENSION.getDefaultValue())) {
                    biomes.add(biomeConfig.getName().replace(BiomeStandardValues.BIOME_CONFIG_EXTENSION.getDefaultValue(), ""));
                    continue;
                }
                if (!biomeConfig.isDirectory()) continue;
                this.addBiomesFromDirRecursive(biomes, biomeConfig);
            }
        }
    }

    private void loadBiomes(SettingsMap worldConfigSettings, File worldSaveFolder, boolean isReload) {
        ArrayList<File> biomeDirs = new ArrayList<File>(2);
        biomeDirs.add(new File(this.settingsDir, OTG.correctOldBiomeConfigFolder(this.settingsDir)));
        biomeDirs.add(new File(OTG.getEngine().getOTGRootFolder(), "GlobalBiomes"));
        FileHelper.makeFolders(biomeDirs);
        HashSet<BiomeLoadInstruction> biomesToLoad = new HashSet<BiomeLoadInstruction>();
        if (worldConfigSettings.isNewConfig()) {
            Collection<BiomeLoadInstruction> defaultBiomes = OTG.getEngine().getDefaultBiomes();
            for (BiomeLoadInstruction defaultBiome : defaultBiomes) {
                this.worldConfig.worldBiomes.add(defaultBiome.getBiomeName());
                biomesToLoad.add(new BiomeLoadInstruction(defaultBiome.getBiomeName(), defaultBiome.getBiomeTemplate()));
            }
        }
        BiomeConfigFinder biomeConfigFinder = new BiomeConfigFinder(OTG.getPluginConfig().biomeConfigExtension);
        Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs = biomeConfigFinder.findBiomes(this.worldConfig, this.worldConfig.worldHeightScale, biomeDirs, biomesToLoad);
        Map<String, BiomeConfig> loadedBiomes = ServerConfigProvider.readAndWriteSettings(this.worldConfig, biomeConfigStubs, true);
        String loadedBiomeNames = this.indexSettings(this.worldConfig.customBiomeGenerationIds, worldConfigSettings.isNewConfig(), loadedBiomes, worldSaveFolder, isReload);
        OTG.log(LogMarker.DEBUG, "{} biomes Loaded", this.biomesCount);
        OTG.log(LogMarker.DEBUG, "{}", loadedBiomeNames);
    }

    @Override
    public void reload() {
        Arrays.fill(this.biomesByOTGId, null);
        this.biomesCount = 0;
        this.loadSettings(this.world.getWorldSaveDir(), true);
    }

    public static Map<String, BiomeConfig> readAndWriteSettings(WorldConfig worldConfig, Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs, boolean write) {
        HashMap<String, BiomeConfig> loadedBiomes = new HashMap<String, BiomeConfig>();
        for (BiomeConfigFinder.BiomeConfigStub biomeConfigStub : biomeConfigStubs.values()) {
            ServerConfigProvider.processInheritance(biomeConfigStubs, biomeConfigStub, 0);
            ServerConfigProvider.processMobInheritance(biomeConfigStubs, biomeConfigStub, 0);
            BiomeConfig biomeConfig = new BiomeConfig(biomeConfigStub.getLoadInstructions(), biomeConfigStub, biomeConfigStub.getSettings(), worldConfig);
            loadedBiomes.put(biomeConfigStub.getBiomeName(), biomeConfig);
            if (!write) continue;
            File writeFile = biomeConfigStub.getFile();
            if (!biomeConfig.biomeExtends.isEmpty()) {
                writeFile = new File(writeFile.getAbsolutePath() + ".inherited");
            }
            FileSettingsWriter.writeToFile(biomeConfig.getSettingsAsMap(), writeFile, worldConfig.settingsMode);
        }
        return loadedBiomes;
    }

    private static void processInheritance(Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs, BiomeConfigFinder.BiomeConfigStub biomeConfigStub, int currentDepth) {
        if (biomeConfigStub.biomeExtendsProcessed) {
            return;
        }
        String extendedBiomeName = biomeConfigStub.getSettings().getSetting(BiomeStandardValues.BIOME_EXTENDS);
        if (extendedBiomeName.isEmpty()) {
            biomeConfigStub.biomeExtendsProcessed = true;
            return;
        }
        BiomeConfigFinder.BiomeConfigStub extendedBiomeConfig = biomeConfigStubs.get(extendedBiomeName);
        if (extendedBiomeConfig == null) {
            OTG.log(LogMarker.WARN, "The biome {} tried to extend the biome {}, but that biome doesn't exist.", biomeConfigStub.getBiomeName(), extendedBiomeName);
            return;
        }
        if (currentDepth > 15) {
            OTG.log(LogMarker.FATAL, "The biome {} cannot extend the biome {} - too much configs processed already! Cyclical inheritance?", biomeConfigStub.getBiomeName(), extendedBiomeConfig.getBiomeName());
        }
        if (!extendedBiomeConfig.biomeExtendsProcessed) {
            ServerConfigProvider.processInheritance(biomeConfigStubs, extendedBiomeConfig, currentDepth + 1);
        }
        biomeConfigStub.getSettings().setFallback(extendedBiomeConfig.getSettings());
        biomeConfigStub.biomeExtendsProcessed = true;
    }

    private static void processMobInheritance(Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs, BiomeConfigFinder.BiomeConfigStub biomeConfigStub, int currentDepth) {
        if (biomeConfigStub.inheritMobsBiomeNameProcessed) {
            return;
        }
        String stubInheritMobsBiomeName = biomeConfigStub.getSettings().getSetting(BiomeStandardValues.INHERIT_MOBS_BIOME_NAME, biomeConfigStub.getLoadInstructions().getBiomeTemplate().defaultInheritMobsBiomeName);
        if (stubInheritMobsBiomeName != null && stubInheritMobsBiomeName.length() > 0) {
            String[] inheritMobsBiomeNames;
            for (String inheritMobsBiomeName : inheritMobsBiomeNames = stubInheritMobsBiomeName.split(",")) {
                if (inheritMobsBiomeName.isEmpty()) continue;
                BiomeConfigFinder.BiomeConfigStub inheritMobsBiomeConfig = biomeConfigStubs.get(inheritMobsBiomeName);
                if (inheritMobsBiomeConfig == null || inheritMobsBiomeConfig == biomeConfigStub) {
                    String vanillaBiomeName = BiomeRegistryNames.getRegistryNameForDefaultBiome(inheritMobsBiomeName);
                    if (vanillaBiomeName != null) {
                        inheritMobsBiomeConfig = null;
                        inheritMobsBiomeName = vanillaBiomeName;
                    } else if (inheritMobsBiomeConfig == biomeConfigStub) {
                        OTG.log(LogMarker.WARN, "The biome {} tried to inherit mobs from itself.", biomeConfigStub.getBiomeName());
                        continue;
                    }
                }
                if (currentDepth > 15) {
                    OTG.log(LogMarker.FATAL, "The biome {} cannot inherit mobs from biome {} - too much configs processed already! Cyclical inheritance?", biomeConfigStub.getFile().getName(), inheritMobsBiomeConfig.getFile().getName());
                }
                if (inheritMobsBiomeConfig != null) {
                    if (!inheritMobsBiomeConfig.inheritMobsBiomeNameProcessed) {
                        ServerConfigProvider.processMobInheritance(biomeConfigStubs, inheritMobsBiomeConfig, currentDepth + 1);
                    }
                    biomeConfigStub.mergeMobs(inheritMobsBiomeConfig);
                    continue;
                }
                OTG.getEngine().mergeVanillaBiomeMobSpawnSettings(biomeConfigStub, inheritMobsBiomeName);
            }
            biomeConfigStub.inheritMobsBiomeNameProcessed = true;
        }
    }

    private String indexSettings(Map<String, Integer> worldBiomes, boolean isNewWorldConfig, Map<String, BiomeConfig> loadedBiomes, File worldSaveFolder, boolean isReload) {
        boolean bl;
        boolean hasWorldData;
        StringBuilder loadedBiomeNames = new StringBuilder();
        ArrayList<BiomeConfig> nonVirtualBiomesExisting = new ArrayList<BiomeConfig>();
        ArrayList<BiomeConfig> nonVirtualBiomes = new ArrayList<BiomeConfig>();
        ArrayList<BiomeConfig> virtualBiomesExisting = new ArrayList<BiomeConfig>();
        ArrayList<BiomeConfig> virtualBiomes = new ArrayList<BiomeConfig>();
        ArrayList<BiomeIdData> loadedBiomeIdData = BiomeIdData.loadBiomeIdData(worldSaveFolder);
        boolean bl2 = hasWorldData = loadedBiomeIdData != null;
        if (hasWorldData) {
            boolean bFound = false;
            for (BiomeIdData biomeIdData : loadedBiomeIdData) {
                if (!biomeIdData.biomeName.startsWith(this.world.getName() + "_")) continue;
                bFound = true;
                break;
            }
            if (!(hasWorldData = bFound)) {
                loadedBiomeIdData = null;
            }
        }
        for (Map.Entry<String, BiomeConfig> entry : loadedBiomes.entrySet()) {
            if (entry.getValue().replaceToBiomeName != null && entry.getValue().replaceToBiomeName.trim().length() > 0) {
                String string = BiomeRegistryNames.getRegistryNameForDefaultBiome(entry.getValue().replaceToBiomeName);
                if (string == null) continue;
                entry.getValue().replaceToBiomeName = string;
                continue;
            }
            String string = BiomeRegistryNames.getRegistryNameForDefaultBiome(entry.getValue().getName());
            if (string == null) continue;
            entry.getValue().replaceToBiomeName = string;
        }
        ArrayList<BiomeConfig> loadedBiomeList = new ArrayList<BiomeConfig>(loadedBiomes.values());
        if (!OTG.IsNewWorldBeingCreated && !hasWorldData && worldBiomes.size() > 0) {
            loadedBiomeIdData = new ArrayList();
            for (Map.Entry<String, Integer> entry : worldBiomes.entrySet()) {
                BiomeConfig biomeConfig = loadedBiomes.get(entry.getKey());
                loadedBiomeIdData.add(new BiomeIdData(this.world.getName() + "_" + entry.getKey(), entry.getValue(), biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.trim().length() > 0 ? -1 : entry.getValue()));
            }
        }
        WorldSaveData worldSaveData = WorldSaveData.loadWorldSaveData(worldSaveFolder);
        boolean bl3 = bl = !OTG.IsNewWorldBeingCreated && (!hasWorldData || worldSaveData != null && worldSaveData.version == 6);
        if (worldSaveData == null) {
            WorldSaveData worldSaveData2 = new WorldSaveData(bl ? 6 : 8);
            WorldSaveData.saveWorldSaveData(worldSaveFolder, worldSaveData2);
        }
        if (bl) {
            Collections.sort(loadedBiomeList, new Comparator<BiomeConfig>(){

                @Override
                public int compare(BiomeConfig a, BiomeConfig b) {
                    return ServerConfigProvider.this.getRequestedGenerationId(a) - ServerConfigProvider.this.getRequestedGenerationId(b);
                }
            });
        }
        ArrayList<BiomeConfig> usedBiomes = loadedBiomeList;
        if (loadedBiomeIdData != null) {
            usedBiomes = new ArrayList();
            if (!hasWorldData && !OTG.IsNewWorldBeingCreated) {
                Iterator defaultBiomes = OTG.getEngine().getDefaultBiomes();
                Iterator<Object> iterator = defaultBiomes.iterator();
                while (iterator.hasNext()) {
                    BiomeLoadInstruction defaultBiome = (BiomeLoadInstruction)iterator.next();
                    for (BiomeConfig biomeConfig : loadedBiomeList) {
                        if (!defaultBiome.getBiomeName().equals(biomeConfig.getName())) continue;
                        usedBiomes.add(biomeConfig);
                    }
                }
            }
            block5: for (BiomeIdData biomeIdData : loadedBiomeIdData) {
                if (!biomeIdData.biomeName.startsWith(this.world.getName() + "_")) continue;
                for (BiomeConfig biomeConfig : loadedBiomeList) {
                    if (!(this.world.getName() + "_" + biomeConfig.getName()).equals(biomeIdData.biomeName)) continue;
                    if (!usedBiomes.contains(biomeConfig)) {
                        usedBiomes.add(biomeConfig);
                    }
                    if (OTG.getEngine().isOTGBiomeIdAvailable(this.world.getName(), biomeIdData.otgBiomeId)) {
                        OTG.getEngine().setOTGBiomeId(this.world.getName(), biomeIdData.otgBiomeId, biomeConfig, false);
                    } else if ((this.world.getName() + "_" + OTG.getEngine().getOTGBiomeIds(this.world.getName())[biomeIdData.otgBiomeId].getName()).equals(biomeIdData.biomeName)) {
                        OTG.getEngine().setOTGBiomeId(this.world.getName(), biomeIdData.otgBiomeId, biomeConfig, true);
                    } else {
                        throw new RuntimeException("Error: OTG Biome id " + biomeIdData.otgBiomeId + " for biome " + biomeConfig.getName() + " was taken by " + OTG.getBiomeByOTGId(biomeIdData.otgBiomeId).getName());
                    }
                    if (biomeIdData.otgBiomeId > -1 && (biomeConfig.replaceToBiomeName == null || biomeConfig.replaceToBiomeName.trim().length() <= 0)) {
                        if (biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.trim().length() > 0) {
                            throw new RuntimeException("Error: Biome \"" + biomeConfig.getName() + "\" has an id between 0-255 but uses replaceToBiomeName. Virtual biomes must have id's above 255, please check your WorldConfig's custom biomes setting.");
                        }
                        nonVirtualBiomesExisting.add(biomeConfig);
                        continue block5;
                    }
                    if (biomeConfig.replaceToBiomeName == null || biomeConfig.replaceToBiomeName.trim().length() <= 0) continue block5;
                    virtualBiomesExisting.add(biomeConfig);
                    continue block5;
                }
            }
        }
        for (BiomeConfig biomeConfig : usedBiomes) {
            int i;
            ++this.biomesCount;
            loadedBiomeNames.append(biomeConfig.getName());
            loadedBiomeNames.append(", ");
            BiomeConfig[] otgIds2 = OTG.getEngine().getOTGBiomeIds(this.world.getName());
            int otgBiomeId = -1;
            boolean bFound = false;
            for (i = 0; i < otgIds2.length; ++i) {
                BiomeConfig biomeConfig2 = otgIds2[i];
                if (biomeConfig == biomeConfig2) {
                    bFound = true;
                    break;
                }
                if (biomeConfig2 == null || !biomeConfig.getName().equals(biomeConfig2.getName()) || !biomeConfig.worldConfig.getName().equals(biomeConfig2.worldConfig.getName())) continue;
                OTG.getEngine().setOTGBiomeId(this.world.getName(), i, biomeConfig2, true);
                otgBiomeId = i;
                break;
            }
            if (bFound || otgBiomeId != -1) continue;
            for (i = 0; i < otgIds2.length; ++i) {
                if (biomeConfig.replaceToBiomeName.isEmpty() && i > otgIds2.length - 1 || biomeConfig.replaceToBiomeName.isEmpty() && i >= OTG.getEngine().getOTGBiomeIds(this.world.getName()).length) {
                    OTG.log(LogMarker.FATAL, "Biome could not be registered, no free biome id's!", new Object[0]);
                    throw new RuntimeException("Biome could not be registered, no free biome id's!");
                }
                if (!OTG.getEngine().isOTGBiomeIdAvailable(this.world.getName(), i)) continue;
                otgBiomeId = i;
                OTG.getEngine().setOTGBiomeId(this.world.getName(), i, biomeConfig, false);
                break;
            }
            if (otgBiomeId > -1 && (biomeConfig.replaceToBiomeName == null || biomeConfig.replaceToBiomeName.trim().length() <= 0)) {
                nonVirtualBiomes.add(biomeConfig);
                continue;
            }
            if (biomeConfig.replaceToBiomeName == null || biomeConfig.replaceToBiomeName.trim().length() <= 0) continue;
            virtualBiomes.add(biomeConfig);
        }
        for (BiomeConfig biomeConfig : nonVirtualBiomesExisting) {
            this.createAndRegisterBiome(loadedBiomeIdData, biomeConfig, isReload);
        }
        for (BiomeConfig biomeConfig : virtualBiomesExisting) {
            this.createAndRegisterBiome(loadedBiomeIdData, biomeConfig, isReload);
        }
        for (BiomeConfig biomeConfig : nonVirtualBiomes) {
            this.createAndRegisterBiome(loadedBiomeIdData, biomeConfig, isReload);
        }
        for (BiomeConfig biomeConfig : virtualBiomes) {
            this.createAndRegisterBiome(loadedBiomeIdData, biomeConfig, isReload);
        }
        BiomeIdData.saveBiomeIdData(worldSaveFolder, this, this.world);
        ArrayList<LocalWorld> worlds = OTG.getAllWorlds();
        if (worlds != null) {
            for (LocalWorld world : worlds) {
                if (this.worldConfig.maxSmoothRadius >= world.getConfigs().getWorldConfig().maxSmoothRadius) continue;
                this.worldConfig.maxSmoothRadius = world.getConfigs().getWorldConfig().maxSmoothRadius;
            }
        }
        if (this.biomesCount > 0) {
            loadedBiomeNames.delete(loadedBiomeNames.length() - 2, loadedBiomeNames.length());
        }
        return loadedBiomeNames.toString();
    }

    private void createAndRegisterBiome(ArrayList<BiomeIdData> loadedBiomeIdData, BiomeConfig biomeConfig, boolean isReload) {
        LocalBiome biome;
        int savedBiomeId = -1;
        if (loadedBiomeIdData != null) {
            for (BiomeIdData biomeIdData : loadedBiomeIdData) {
                if (!(this.world.getName() + "_" + biomeConfig.getName()).equals(biomeIdData.biomeName)) continue;
                savedBiomeId = biomeIdData.savedBiomeId;
                break;
            }
        }
        int otgBiomeId = -1;
        BiomeConfig[] otgIds2 = OTG.getEngine().getOTGBiomeIds(this.world.getName());
        for (int i = 0; i < otgIds2.length; ++i) {
            if (otgIds2[i] != biomeConfig) continue;
            otgBiomeId = i;
            break;
        }
        if (otgBiomeId == -1) {
            OTG.log(LogMarker.FATAL, "Biome was not registered, most likely there were no id's available.", new Object[0]);
            throw new RuntimeException("Biome was not registered, most likely there were no id's available.");
        }
        if (!biomeConfig.replaceToBiomeName.isEmpty()) {
            savedBiomeId = this.findSavedBiomeId(biomeConfig, otgIds2, 0);
        }
        boolean bl = biomeConfig.replaceToBiomeName != null && !biomeConfig.replaceToBiomeName.isEmpty();
        this.biomesByOTGId[biome.getIds().getOTGBiomeId()] = biome = this.world.createBiomeFor(biomeConfig, new BiomeIds(otgBiomeId, savedBiomeId, bl), this, isReload);
        if (!this.worldConfig.biomeConfigsHaveReplacement) {
            this.worldConfig.biomeConfigsHaveReplacement = biomeConfig.replacedBlocks.hasReplaceSettings();
        }
        biomeConfig.replacedBlocks.parseForWorld(this.world);
        if (this.worldConfig.maxSmoothRadius < biomeConfig.smoothRadius) {
            this.worldConfig.maxSmoothRadius = biomeConfig.smoothRadius;
        }
        if (this.worldConfig.maxSmoothRadius < biomeConfig.CHCSmoothRadius) {
            this.worldConfig.maxSmoothRadius = biomeConfig.CHCSmoothRadius;
        }
        if (this.worldConfig.biomeMode == OTG.getBiomeModeManager().FROM_IMAGE) {
            if (this.worldConfig.biomeColorMap == null) {
                this.worldConfig.biomeColorMap = new HashMap();
            }
            int color = biomeConfig.biomeColor;
            this.worldConfig.biomeColorMap.put(color, biome.getIds().getOTGBiomeId());
        }
    }

    private int findSavedBiomeId(BiomeConfig biomeConfig, BiomeConfig[] configArray, int counter) {
        if (counter > 100) {
            OTG.log(LogMarker.FATAL, "Failed to replace, recursion went deeper than 100 layers. Did you create a replace loop at " + biomeConfig.replaceToBiomeName + "?", new Object[0]);
            throw new RuntimeException("Failed to replace, recursion went deeper than 100 layers. Did you create a replace loop at " + biomeConfig.replaceToBiomeName + "?");
        }
        if (biomeConfig.replaceToBiomeName.contains(":")) {
            return this.getRequestedSavedId(biomeConfig.replaceToBiomeName);
        }
        ConfigFile nextConfig = null;
        for (BiomeConfig b : configArray) {
            if (b == null || !b.getName().equalsIgnoreCase(biomeConfig.replaceToBiomeName)) continue;
            nextConfig = b;
            break;
        }
        if (nextConfig == null) {
            String defaultBiome = BiomeRegistryNames.getRegistryNameForDefaultBiome(biomeConfig.replaceToBiomeName);
            if (defaultBiome != null) {
                return this.getRequestedSavedId(defaultBiome);
            }
            int id = this.getRequestedSavedId(biomeConfig.replaceToBiomeName);
            if (id > -1 && (biomeConfig.replaceToBiomeName == null || biomeConfig.replaceToBiomeName.trim().length() == 0)) {
                return id;
            }
            OTG.log(LogMarker.FATAL, "Could not find replacing biome '" + biomeConfig.replaceToBiomeName + "' for biome '" + biomeConfig.getName() + "'", new Object[0]);
            throw new RuntimeException("Could not find replacing biome '" + biomeConfig.replaceToBiomeName + "' for biome '" + biomeConfig.getName() + "'");
        }
        if (((BiomeConfig)nextConfig).replaceToBiomeName.isEmpty()) {
            return this.getRequestedSavedId(nextConfig.getName());
        }
        return this.findSavedBiomeId((BiomeConfig)nextConfig, configArray, counter + 1);
    }

    @Override
    public List<LocalBiome> getBiomeArrayLegacy() {
        ArrayList<LocalBiome> nonDefaultbiomes = new ArrayList<LocalBiome>();
        LocalBiome[] defaultBiomes = new LocalBiome[256];
        for (LocalBiome biome : this.biomesByOTGId) {
            if (biome == null) continue;
            Integer defaultBiomeId = DefaultBiome.getId(biome.getName());
            if (defaultBiomeId != null) {
                defaultBiomes[defaultBiomeId.intValue()] = biome;
                continue;
            }
            nonDefaultbiomes.add(biome);
        }
        ArrayList<LocalBiome> outputBiomes = new ArrayList<LocalBiome>();
        for (LocalBiome biome : defaultBiomes) {
            if (biome == null) continue;
            outputBiomes.add(biome);
        }
        outputBiomes.addAll(nonDefaultbiomes);
        return outputBiomes;
    }
}

