/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.network;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.BiomeLoadInstruction;
import com.pg85.otg.configuration.io.SimpleSettingsMap;
import com.pg85.otg.configuration.standard.BiomeStandardValues;
import com.pg85.otg.configuration.standard.StandardBiomeTemplate;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.util.BiomeIds;
import com.pg85.otg.util.helpers.StreamHelper;
import com.pg85.otg.util.minecraft.defaults.BiomeRegistryNames;
import com.pg85.otg.util.minecraft.defaults.DefaultBiome;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ClientConfigProvider
implements ConfigProvider {
    private WorldConfig worldConfig;
    private LocalBiome[] biomesByOTGId;
    private LocalBiome[] biomesBySavedId;

    public ClientConfigProvider(DataInputStream stream, LocalWorld world) throws IOException {
        SimpleSettingsMap worldSettingsReader = new SimpleSettingsMap(world.getName(), false);
        worldSettingsReader.putSetting(WorldStandardValues.WORLD_FOG, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.WORLD_NIGHT_FOG, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.WATER_LEVEL_MAX, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.DEFAULT_OCEAN_BIOME, StreamHelper.readStringFromStream(stream), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.DEFAULT_FROZEN_OCEAN_BIOME, StreamHelper.readStringFromStream(stream), new String[0]);
        this.worldConfig = new WorldConfig(new File("."), worldSettingsReader, world, null);
        StandardBiomeTemplate defaultSettings = new StandardBiomeTemplate(this.worldConfig.worldHeightCap);
        this.biomesByOTGId = new LocalBiome[world.getMaxBiomesCount()];
        this.biomesBySavedId = new LocalBiome[world.getMaxBiomesCount()];
        int count = stream.readInt();
        while (count-- > 0) {
            LocalBiome biome;
            int otgBiomeId = stream.readInt();
            int savedBiomeId = stream.readInt();
            String biomeName = StreamHelper.readStringFromStream(stream);
            SimpleSettingsMap biomeReader = new SimpleSettingsMap(biomeName, false);
            biomeReader.putSetting(BiomeStandardValues.BIOME_TEMPERATURE, Float.valueOf(stream.readFloat()), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.BIOME_WETNESS, Float.valueOf(stream.readFloat()), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.FOG_COLOR, stream.readInt(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.FOG_DENSITY, Float.valueOf(stream.readFloat()), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.FOG_RAIN_WEIGHT, Float.valueOf(stream.readFloat()), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.FOG_THUNDER_WEIGHT, Float.valueOf(stream.readFloat()), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.FOG_TIME_WEIGHT, Float.valueOf(stream.readFloat()), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.SKY_COLOR, stream.readInt(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.WATER_COLOR, stream.readInt(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.GRASS_COLOR, stream.readInt(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.GRASS_COLOR_2, stream.readInt(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.GRASS_COLOR_IS_MULTIPLIER, stream.readBoolean(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.FOLIAGE_COLOR, stream.readInt(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.FOLIAGE_COLOR_2, stream.readInt(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.FOLIAGE_COLOR_IS_MULTIPLIER, stream.readBoolean(), new String[0]);
            String replaceToBiomeName = StreamHelper.readStringFromStream(stream);
            biomeReader.putSetting(BiomeStandardValues.REPLACE_TO_BIOME_NAME, replaceToBiomeName, new String[0]);
            String biomeDictId = StreamHelper.readStringFromStream(stream);
            biomeReader.putSetting(BiomeStandardValues.BIOME_DICT_ID, biomeDictId, new String[0]);
            BiomeLoadInstruction instruction = new BiomeLoadInstruction(biomeName, defaultSettings);
            BiomeConfig config = new BiomeConfig(instruction, null, biomeReader, this.worldConfig);
            this.biomesByOTGId[otgBiomeId] = biome = world.createBiomeFor(config, new BiomeIds(otgBiomeId, savedBiomeId, config.replaceToBiomeName != null && !config.replaceToBiomeName.isEmpty()), this, false);
            if (config.replaceToBiomeName == null || config.replaceToBiomeName.trim().length() <= 0 || BiomeRegistryNames.getRegistryNameForDefaultBiome(biomeName) != null) {
                this.biomesBySavedId[savedBiomeId] = biome;
            }
            OTG.getEngine().setOTGBiomeId(world.getName(), otgBiomeId, config, true);
        }
    }

    @Override
    public WorldConfig getWorldConfig() {
        return this.worldConfig;
    }

    @Override
    public LocalBiome getBiomeByOTGIdOrNull(int id) {
        if (id < 0 || id > this.biomesByOTGId.length) {
            return null;
        }
        return this.biomesByOTGId[id];
    }

    @Override
    public void reload() {
    }

    @Override
    public LocalBiome[] getBiomeArrayByOTGId() {
        return this.biomesByOTGId;
    }

    @Override
    public List<LocalBiome> getBiomeArrayLegacy() {
        ArrayList<LocalBiome> nonDefaultbiomes = new ArrayList<LocalBiome>();
        LocalBiome[] defaultBiomes = new LocalBiome[256];
        for (LocalBiome biome : this.biomesByOTGId) {
            if (biome == null) continue;
            Integer defaultBiomeId = DefaultBiome.getId(biome.getName());
            if (defaultBiomeId != null) {
                defaultBiomes[defaultBiomeId.intValue()] = biome;
                continue;
            }
            nonDefaultbiomes.add(biome);
        }
        ArrayList<LocalBiome> outputBiomes = new ArrayList<LocalBiome>();
        for (LocalBiome biome : defaultBiomes) {
            if (biome == null) continue;
            outputBiomes.add(biome);
        }
        outputBiomes.addAll(nonDefaultbiomes);
        return outputBiomes;
    }
}

