/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.terrain;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.terrain.TerrainGenBase;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.util.Random;

public class RavinesGen
extends TerrainGenBase {
    private float[] a = new float[1024];
    private WorldConfig worldSettings;

    public RavinesGen(WorldConfig wrk, LocalWorld world) {
        super(world);
        this.worldSettings = wrk;
    }

    private void placeBlocks(long paramLong, ChunkBuffer generatingChunkBuffer, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat1, float paramFloat2, float paramFloat3, int size, double paramDouble4) {
        Random localRandom = new Random(paramLong);
        ChunkCoordinate generatingChunk = generatingChunkBuffer.getChunkCoordinate();
        double d1 = generatingChunk.getBlockXCenter();
        double d2 = generatingChunk.getBlockZCenter();
        float f1 = 0.0f;
        float f2 = 0.0f;
        boolean i = false;
        float f3 = 1.0f;
        for (int j = 0; j < this.worldSettings.worldHeightCap; ++j) {
            if (j == 0 || localRandom.nextInt(3) == 0) {
                f3 = 1.0f + localRandom.nextFloat() * localRandom.nextFloat() * 1.0f;
            }
            this.a[j] = f3 * f3;
        }
        for (int stepCount = 0; stepCount < size; ++stepCount) {
            int localZ;
            int localX;
            double d3 = 1.5 + (double)(MathHelper.sin((float)stepCount * 3.141593f / (float)size) * paramFloat1 * 1.0f);
            double d4 = d3 * paramDouble4;
            d3 *= (double)localRandom.nextFloat() * 0.25 + 0.75;
            d4 *= (double)localRandom.nextFloat() * 0.25 + 0.75;
            float f4 = MathHelper.cos(paramFloat3);
            float f5 = MathHelper.sin(paramFloat3);
            paramDouble1 += (double)(MathHelper.cos(paramFloat2) * f4);
            paramDouble2 += (double)f5;
            paramDouble3 += (double)(MathHelper.sin(paramFloat2) * f4);
            paramFloat3 *= 0.7f;
            paramFloat3 += f2 * 0.05f;
            paramFloat2 += f1 * 0.05f;
            f2 *= 0.8f;
            f1 *= 0.5f;
            f2 += (localRandom.nextFloat() - localRandom.nextFloat()) * localRandom.nextFloat() * 2.0f;
            f1 += (localRandom.nextFloat() - localRandom.nextFloat()) * localRandom.nextFloat() * 4.0f;
            if (!i && localRandom.nextInt(4) == 0) continue;
            double d5 = paramDouble1 - d1;
            double d6 = paramDouble3 - d2;
            double d7 = size - stepCount;
            double d8 = paramFloat1 + 2.0f + 16.0f;
            if (d5 * d5 + d6 * d6 - d7 * d7 > d8 * d8) {
                return;
            }
            if (paramDouble1 < d1 - 16.0 - d3 * 2.0 || paramDouble3 < d2 - 16.0 - d3 * 2.0 || paramDouble1 > d1 + 16.0 + d3 * 2.0 || paramDouble3 > d2 + 16.0 + d3 * 2.0) continue;
            int k = MathHelper.floor(paramDouble1 - d3) - generatingChunk.getBlockX() - 1;
            int m = MathHelper.floor(paramDouble1 + d3) - generatingChunk.getBlockX() + 1;
            int maxDepth = MathHelper.floor(paramDouble2 - d4) - 1;
            int minDepth = MathHelper.floor(paramDouble2 + d4) + 1;
            int i2 = MathHelper.floor(paramDouble3 - d3) - generatingChunk.getBlockZ() - 1;
            int i3 = MathHelper.floor(paramDouble3 + d3) - generatingChunk.getBlockZ() + 1;
            if (k < 0) {
                k = 0;
            }
            if (m > 16) {
                m = 16;
            }
            if (maxDepth < 1) {
                maxDepth = 1;
            }
            if (minDepth > this.worldSettings.worldHeightCap - 8) {
                minDepth = this.worldSettings.worldHeightCap - 8;
            }
            if (i2 < 0) {
                i2 = 0;
            }
            if (i3 > 16) {
                i3 = 16;
            }
            boolean i4 = false;
            for (localX = k; !i4 && localX < m; ++localX) {
                for (localZ = i2; !i4 && localZ < i3; ++localZ) {
                    for (int localY = minDepth + 1; !i4 && localY >= maxDepth - 1; --localY) {
                        if (localY < 0 || localY >= this.worldSettings.worldHeightCap) continue;
                        LocalMaterialData materialAtPosition = generatingChunkBuffer.getBlock(localX, localY, localZ);
                        if (materialAtPosition.isMaterial(DefaultMaterial.WATER) || materialAtPosition.isMaterial(DefaultMaterial.STATIONARY_WATER)) {
                            i4 = true;
                        }
                        if (localY == maxDepth - 1 || localX == k || localX == m - 1 || localZ == i2 || localZ == i3 - 1) continue;
                        localY = maxDepth;
                    }
                }
            }
            if (i4) continue;
            for (localX = k; localX < m; ++localX) {
                double d9 = ((double)(localX + generatingChunk.getBlockX()) + 0.5 - paramDouble1) / d3;
                for (localZ = i2; localZ < i3; ++localZ) {
                    LocalBiome biome = this.world.getBiome(localX + generatingChunk.getBlockX(), localZ + generatingChunk.getBlockZ());
                    BiomeConfig biomeConfig = biome.getBiomeConfig();
                    double d10 = ((double)(localZ + generatingChunk.getBlockZ()) + 0.5 - paramDouble3) / d3;
                    boolean surfaceBlockFound = false;
                    LocalMaterialData surfaceBlockMaterial = null;
                    if (!(d9 * d9 + d10 * d10 < 1.0)) continue;
                    for (int currentDepth = minDepth; currentDepth >= maxDepth; --currentDepth) {
                        double d11 = ((double)(currentDepth - 1) + 0.5 - paramDouble2) / d4;
                        if (!((d9 * d9 + d10 * d10) * (double)this.a[currentDepth - 1] + d11 * d11 / 6.0 < 1.0)) continue;
                        LocalMaterialData material = generatingChunkBuffer.getBlock(localX, currentDepth, localZ);
                        if (!surfaceBlockFound && material.equals(biomeConfig.getSurfaceBlockReplaced(this.world, currentDepth))) {
                            surfaceBlockFound = true;
                            surfaceBlockMaterial = material;
                        }
                        if (!material.isMaterial(DefaultMaterial.BEDROCK) && !material.isAir()) {
                            generatingChunkBuffer.setBlock(localX, currentDepth, localZ, MaterialHelper.AIR);
                        }
                        LocalMaterialData block = generatingChunkBuffer.getBlock(localX, currentDepth - 1, localZ);
                        if (!surfaceBlockFound || block.isMaterial(DefaultMaterial.BEDROCK) || block.isMaterial(DefaultMaterial.WATER) || block.isMaterial(DefaultMaterial.STATIONARY_WATER) || block.isMaterial(DefaultMaterial.LAVA) || block.isMaterial(DefaultMaterial.STATIONARY_LAVA) || block.isMaterial(DefaultMaterial.MAGMA) || block.isAir()) continue;
                        generatingChunkBuffer.setBlock(localX, currentDepth - 1, localZ, surfaceBlockMaterial);
                    }
                }
            }
            if (i) break;
        }
    }

    @Override
    protected void generateChunk(ChunkCoordinate currentChunk, ChunkBuffer generatingChunkBuffer) {
        if (this.random.nextInt(100) >= this.worldSettings.ravineRarity) {
            return;
        }
        double d1 = currentChunk.getBlockX() + this.random.nextInt(16);
        double d2 = RandomHelper.numberInRange(this.random, this.worldSettings.ravineMinAltitude, this.worldSettings.ravineMaxAltitude);
        double d3 = currentChunk.getBlockZ() + this.random.nextInt(16);
        int i = 1;
        for (int j = 0; j < i; ++j) {
            float f1 = this.random.nextFloat() * 3.141593f * 2.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 2.0f / 8.0f;
            float f3 = (this.random.nextFloat() * 2.0f + this.random.nextFloat()) * 2.0f;
            int size = RandomHelper.numberInRange(this.random, this.worldSettings.ravineMinLength, this.worldSettings.ravineMaxLength);
            this.placeBlocks(this.random.nextLong(), generatingChunkBuffer, d1, d2, d3, f3, f1, f2, size, this.worldSettings.ravineDepth);
        }
    }
}

