/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.surface;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.materials.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;

public class FrozenSurfaceHelper {
    private final LocalWorld world;
    private final WorldConfig worldConfig;
    private final int maxPropagationSize = 15;
    private int currentPropagationSize = 0;
    private int maxLayersOnLeaves = 3;

    public FrozenSurfaceHelper(LocalWorld world) {
        this.world = world;
        this.worldConfig = world.getConfigs().getWorldConfig();
    }

    public void freezeChunk(ChunkCoordinate chunkCoord) {
        int x = chunkCoord.getBlockXCenter();
        int z = chunkCoord.getBlockZCenter();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int blockToFreezeX = x + i;
                int blockToFreezeZ = z + j;
                this.freezeColumn(blockToFreezeX, blockToFreezeZ, chunkCoord);
            }
        }
    }

    private void freezeColumn(int x, int z, ChunkCoordinate chunkBeingPopulated) {
        LocalBiome biome = this.world.getBiomeForPopulation(x, z, chunkBeingPopulated);
        if (biome != null) {
            int blockToFreezeY = this.world.getHighestBlockAboveYAt(x, z, chunkBeingPopulated);
            float tempAtBlockToFreeze = biome.getTemperatureAt(x, blockToFreezeY, z);
            if (blockToFreezeY > 0 && tempAtBlockToFreeze < 0.15f) {
                this.currentPropagationSize = 0;
                if (!this.freezeLiquid(x, blockToFreezeY - 1, z, chunkBeingPopulated)) {
                    this.startSnowFall(x, blockToFreezeY, z, biome, chunkBeingPopulated);
                }
            }
        }
    }

    private boolean freezeLiquid(int x, int y, int z, ChunkCoordinate chunkBeingPopulated) {
        LocalMaterialData materialToFreeze;
        LocalBiome biome = this.world.getBiomeForPopulation(x, z, chunkBeingPopulated);
        if (biome != null && (materialToFreeze = this.world.getMaterial(x, y, z, chunkBeingPopulated)).isLiquid()) {
            boolean bFroze = false;
            LocalMaterialData iceBlock = biome.getBiomeConfig().getIceBlockReplaced(this.world, y);
            if (this.shouldFreeze(x, y, z, materialToFreeze, iceBlock, DefaultMaterial.WATER, DefaultMaterial.STATIONARY_WATER, chunkBeingPopulated)) {
                this.world.setBlock(x, y, z, iceBlock, null, chunkBeingPopulated, false);
                bFroze = true;
            } else {
                LocalMaterialData cooledLavaBlock = biome.getBiomeConfig().getCooledLavaBlockReplaced(this.world, y);
                if (this.shouldFreeze(x, y, z, materialToFreeze, cooledLavaBlock, DefaultMaterial.LAVA, DefaultMaterial.STATIONARY_LAVA, chunkBeingPopulated)) {
                    this.world.setBlock(x, y, z, cooledLavaBlock, null, chunkBeingPopulated, true);
                    bFroze = true;
                }
            }
            if (bFroze && this.worldConfig.fullyFreezeLakes && this.currentPropagationSize < this.maxPropagationSize) {
                ++this.currentPropagationSize;
                this.propagateFreeze(x, y, z, chunkBeingPopulated);
            }
            return true;
        }
        return false;
    }

    private boolean shouldFreeze(int x, int y, int z, LocalMaterialData thawedMaterial, LocalMaterialData frozenMaterial, DefaultMaterial check1, DefaultMaterial check2, ChunkCoordinate chunkBeingPopulated) {
        return (thawedMaterial.isMaterial(check1) || thawedMaterial.isMaterial(check2)) && !frozenMaterial.isMaterial(check1) && !frozenMaterial.isMaterial(check2);
    }

    private void startSnowFall(int x, int y, int z, LocalBiome biome, ChunkCoordinate chunkBeingPopulated) {
        int snowHeight;
        int decreaseFactor = 0;
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        LocalMaterialData materialToSnowAt = null;
        LocalMaterialData materialToSnowOn = null;
        if (this.worldConfig.betterSnowFall) {
            float tempAtBlockToFreeze = biome.getTemperatureAt(x, y, z);
            snowHeight = biomeConfig.getSnowHeight(tempAtBlockToFreeze);
        } else {
            snowHeight = 0;
        }
        while (y > 1 && decreaseFactor < 8 && snowHeight - decreaseFactor >= 0) {
            materialToSnowAt = this.world.getMaterial(x, y, z, chunkBeingPopulated);
            materialToSnowOn = this.world.getMaterial(x, y - 1, z, chunkBeingPopulated);
            if (materialToSnowAt != null && materialToSnowOn != null && materialToSnowAt.isAir() && materialToSnowOn.canSnowFallOn()) {
                if (this.setSnowFallAtLocation(x, y, z, snowHeight - decreaseFactor, materialToSnowOn, chunkBeingPopulated)) break;
                decreaseFactor += this.maxLayersOnLeaves;
            }
            if (materialToSnowOn == null || materialToSnowOn.isSolid()) break;
            --y;
        }
    }

    private boolean setSnowFallAtLocation(int x, int y, int z, int baseSnowHeight, LocalMaterialData materialToSnowOn, ChunkCoordinate chunkBeingPopulated) {
        if (materialToSnowOn.isMaterial(DefaultMaterial.LEAVES) || materialToSnowOn.isMaterial(DefaultMaterial.LEAVES_2)) {
            LocalMaterialData snowMass = MaterialHelper.toLocalMaterialData(DefaultMaterial.SNOW, baseSnowHeight <= this.maxLayersOnLeaves - 1 ? baseSnowHeight : this.maxLayersOnLeaves - 1);
            this.world.setBlock(x, y, z, snowMass, null, chunkBeingPopulated, true);
            return baseSnowHeight <= this.maxLayersOnLeaves - 1;
        }
        LocalMaterialData snowMass = MaterialHelper.toLocalMaterialData(DefaultMaterial.SNOW, baseSnowHeight);
        this.world.setBlock(x, y, z, snowMass, null, chunkBeingPopulated, true);
        return true;
    }

    private void propagateFreeze(int x, int y, int z, ChunkCoordinate chunkBeingPopulated) {
        this.propagationHelper(x + 1, y, z, chunkBeingPopulated);
        this.propagationHelper(x + 1, y, z + 1, chunkBeingPopulated);
        this.propagationHelper(x, y, z + 1, chunkBeingPopulated);
        this.propagationHelper(x - 1, y, z + 1, chunkBeingPopulated);
        this.propagationHelper(x - 1, y, z, chunkBeingPopulated);
        this.propagationHelper(x - 1, y, z - 1, chunkBeingPopulated);
        this.propagationHelper(x, y, z - 1, chunkBeingPopulated);
        this.propagationHelper(x + 1, y, z - 1, chunkBeingPopulated);
    }

    private void propagationHelper(int x, int y, int z, ChunkCoordinate chunkBeingPopulated) {
        if (this.world.getHighestBlockAboveYAt(x, z, chunkBeingPopulated) - 1 > y && this.currentPropagationSize < this.maxPropagationSize) {
            this.freezeLiquid(x, y, z, chunkBeingPopulated);
        }
    }
}

