/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.noise;

import com.pg85.otg.generator.noise.NoiseGeneratorSurfacePatch;
import java.util.Random;

public class NoiseGeneratorSurfacePatchOctaves {
    private NoiseGeneratorSurfacePatch[] noiseArray;
    private int numOctaves;

    public NoiseGeneratorSurfacePatchOctaves(Random random, int numOctaves) {
        this.numOctaves = numOctaves;
        this.noiseArray = new NoiseGeneratorSurfacePatch[numOctaves];
        for (int i = 0; i < numOctaves; ++i) {
            this.noiseArray[i] = new NoiseGeneratorSurfacePatch(random);
        }
    }

    public double getYNoise(double x, double z) {
        double resultingY = 0.0;
        double octaveAmplitude = 1.0;
        for (int var9 = 0; var9 < this.numOctaves; ++var9) {
            resultingY += this.noiseArray[var9].getYNoise(x * octaveAmplitude, z * octaveAmplitude) / octaveAmplitude;
            octaveAmplitude /= 2.0;
        }
        return resultingY;
    }
}

