/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome.layers;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeGroup;
import com.pg85.otg.configuration.biome.BiomeGroupManager;
import com.pg85.otg.generator.biome.ArraysCache;
import com.pg85.otg.generator.biome.layers.Layer;
import java.util.Map;
import java.util.SortedMap;

public class LayerBiomeGroups
extends Layer {
    private BiomeGroupManager biomeGroupManager;
    private int depth;
    private boolean freezeGroups;

    LayerBiomeGroups(Layer paramGenLayer, BiomeGroupManager biomeGroups, int depth, boolean freezeGroups) {
        this.child = paramGenLayer;
        this.biomeGroupManager = biomeGroups;
        this.depth = depth;
        this.freezeGroups = freezeGroups;
    }

    @Override
    public int[] getInts(LocalWorld world, ArraysCache arraysCache, int x, int z, int x_size, int z_size) {
        int[] childInts = this.child.getInts(world, arraysCache, x, z, x_size, z_size);
        int[] thisInts = arraysCache.getArray(x_size * z_size);
        boolean improvedBiomeGroups = world.getConfigs().getWorldConfig().improvedBiomeGroups;
        for (int i = 0; i < z_size; ++i) {
            for (int j = 0; j < x_size; ++j) {
                if (improvedBiomeGroups) {
                    this.initChunkSeed(j + x, i + z);
                }
                this.initGroupSeed(j + x, i + z);
                int currentPiece = childInts[j + i * x_size];
                if ((currentPiece & 0x800) != 0 && (currentPiece & 0x1FC000) == 0) {
                    SortedMap<Integer, BiomeGroup> possibleGroups = this.biomeGroupManager.getGroupDepthMap(this.depth);
                    int newGroupRarity = improvedBiomeGroups ? this.nextGroupInt(BiomeGroupManager.getMaxRarityFromPossibles(possibleGroups)) : this.nextGroupInt(BiomeGroupManager.getMaxRarityFromPossibles(possibleGroups) * 10000);
                    for (Map.Entry<Integer, BiomeGroup> group : possibleGroups.entrySet()) {
                        if ((improvedBiomeGroups || newGroupRarity / 10000 >= group.getKey()) && (!improvedBiomeGroups || newGroupRarity >= group.getKey())) continue;
                        if (group.getValue() == null) break;
                        currentPiece |= group.getValue().getGroupId() << 14 | (group.getValue().isColdGroup() && this.freezeGroups ? 8192 : 0);
                        break;
                    }
                }
                thisInts[j + i * x_size] = currentPiece;
            }
        }
        return thisInts;
    }
}

