/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome.layers;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.generator.biome.ArraysCache;

public abstract class Layer {
    private long baseSeed;
    protected long scrambledWorldSeed;
    private long scrambledChunkSeed;
    private long scrambledGroupSeed;
    protected Layer child;
    protected static final int Entropy = 10000;
    protected static final int BiomeBits = 2047;
    protected static final int BiomeBitsAreSetBit = 0x800000;
    protected static final int LandBit = 2048;
    protected static final int IslandBit = 4096;
    protected static final int IceBit = 8192;
    protected static final int BiomeGroupShift = 14;
    protected static final int BiomeGroupBits = 2080768;
    private static final int RiverShift = 21;
    protected static final int RiverBits = 0x600000;
    protected static final int RiverBitOne = 0x200000;
    protected static final int RiverBitTwo = 0x400000;
    protected int defaultOceanId;

    private static long getScrambledBaseSeed(long baseSeed) {
        long scrambledBaseSeed = baseSeed;
        scrambledBaseSeed *= scrambledBaseSeed * 6364136223846793005L + 1442695040888963407L;
        scrambledBaseSeed += baseSeed;
        scrambledBaseSeed *= scrambledBaseSeed * 6364136223846793005L + 1442695040888963407L;
        scrambledBaseSeed += baseSeed;
        scrambledBaseSeed *= scrambledBaseSeed * 6364136223846793005L + 1442695040888963407L;
        return scrambledBaseSeed += baseSeed;
    }

    protected static long getScrambledWorldSeed(long baseSeed, long worldSeed) {
        long scrambledBaseSeed = Layer.getScrambledBaseSeed(baseSeed);
        long scrambledWorldSeed = worldSeed;
        scrambledWorldSeed *= scrambledWorldSeed * 6364136223846793005L + 1442695040888963407L;
        scrambledWorldSeed += scrambledBaseSeed;
        scrambledWorldSeed *= scrambledWorldSeed * 6364136223846793005L + 1442695040888963407L;
        scrambledWorldSeed += scrambledBaseSeed;
        scrambledWorldSeed *= scrambledWorldSeed * 6364136223846793005L + 1442695040888963407L;
        return scrambledWorldSeed += scrambledBaseSeed;
    }

    protected Layer(long seed, int defaultOceanId) {
        this.baseSeed = seed;
        this.defaultOceanId = defaultOceanId;
    }

    public Layer() {
    }

    public void initWorldGenSeed(long worldSeed) {
        if (this.child != null) {
            this.child.initWorldGenSeed(worldSeed);
        }
        this.scrambledWorldSeed = Layer.getScrambledWorldSeed(this.baseSeed, worldSeed);
    }

    protected void initChunkSeed(long x, long z) {
        this.scrambledChunkSeed = this.scrambledWorldSeed;
        this.scrambledChunkSeed *= this.scrambledChunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledChunkSeed += x;
        this.scrambledChunkSeed *= this.scrambledChunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledChunkSeed += z;
        this.scrambledChunkSeed *= this.scrambledChunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledChunkSeed += x;
        this.scrambledChunkSeed *= this.scrambledChunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledChunkSeed += z;
    }

    protected void initGroupSeed(long x, long z) {
        this.scrambledGroupSeed = this.scrambledChunkSeed;
        this.scrambledGroupSeed *= this.scrambledGroupSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledGroupSeed += x;
        this.scrambledGroupSeed *= this.scrambledGroupSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledGroupSeed += z;
        this.scrambledGroupSeed *= this.scrambledGroupSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledGroupSeed += x;
        this.scrambledGroupSeed *= this.scrambledGroupSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledGroupSeed += z;
    }

    protected int nextInt(int x) {
        int i = (int)((this.scrambledChunkSeed >> 24) % (long)x);
        if (i < 0) {
            i += x;
        }
        this.scrambledChunkSeed *= this.scrambledChunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledChunkSeed += this.scrambledWorldSeed;
        return i;
    }

    protected int nextGroupInt(int x) {
        int i = (int)((this.scrambledGroupSeed >> 24) % (long)x);
        if (i < 0) {
            i += x;
        }
        this.scrambledGroupSeed *= this.scrambledGroupSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledGroupSeed += this.scrambledChunkSeed;
        return i;
    }

    public abstract int[] getInts(LocalWorld var1, ArraysCache var2, int var3, int var4, int var5, int var6);

    protected int getRandomOf4(int a, int b, int c, int d) {
        if (b == c && c == d) {
            return b;
        }
        if (a == b && a == c) {
            return a;
        }
        if (a == b && a == d) {
            return a;
        }
        if (a == c && a == d) {
            return a;
        }
        if (a == b && c != d) {
            return a;
        }
        if (a == c && b != d) {
            return a;
        }
        if (a == d && b != c) {
            return a;
        }
        if (b == c && a != d) {
            return b;
        }
        if (b == d && a != c) {
            return b;
        }
        if (c == d && a != b) {
            return c;
        }
        switch (this.nextInt(4)) {
            case 0: {
                return a;
            }
            case 1: {
                return b;
            }
            case 2: {
                return c;
            }
        }
        return d;
    }

    protected int getBiomeFromLayer(int selection) {
        return (selection & 0x800) != 0 && (selection & 0x800000) != 0 ? selection & 0x7FF : this.defaultOceanId;
    }
}

