/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.generator.biome.ArraysCache;
import com.pg85.otg.generator.biome.ArraysCacheManager;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.generator.biome.OutputType;
import com.pg85.otg.generator.biome.layers.Layer;

public abstract class LayeredBiomeGenerator
extends BiomeGenerator {
    private Layer unZoomedLayer;
    private Layer biomeLayer;
    private OutputType defaultOutputType = OutputType.FULL;

    public LayeredBiomeGenerator(LocalWorld world) {
        super(world);
        Layer[] layers = this.initLayers();
        if (world.getConfigs().getWorldConfig().improvedRivers) {
            this.defaultOutputType = OutputType.WITHOUT_RIVERS;
        }
        this.unZoomedLayer = layers[0];
        this.biomeLayer = layers[1];
    }

    protected abstract Layer[] initLayers();

    @Override
    public int[] getBiomesUnZoomed(int[] biomeArray, int x, int z, int x_size, int z_size, OutputType outputType) {
        if (biomeArray == null || biomeArray.length < x_size * z_size) {
            biomeArray = new int[x_size * z_size];
        }
        ArraysCache cache = ArraysCacheManager.getCache();
        cache.outputType = outputType == OutputType.DEFAULT_FOR_WORLD ? this.defaultOutputType : outputType;
        int[] arrayOfInt = this.unZoomedLayer.getInts(this.world, cache, x, z, x_size, z_size);
        System.arraycopy(arrayOfInt, 0, biomeArray, 0, x_size * z_size);
        ArraysCacheManager.releaseCache(cache);
        return biomeArray;
    }

    @Override
    public int[] getBiomes(int[] biomeArray, int x, int z, int x_size, int z_size, OutputType outputType) {
        if (biomeArray == null || biomeArray.length < x_size * z_size) {
            biomeArray = new int[x_size * z_size];
        }
        ArraysCache cache = ArraysCacheManager.getCache();
        cache.outputType = outputType == OutputType.DEFAULT_FOR_WORLD ? this.defaultOutputType : outputType;
        int[] arrayOfInt = this.biomeLayer.getInts(this.world, cache, x, z, x_size, z_size);
        System.arraycopy(arrayOfInt, 0, biomeArray, 0, x_size * z_size);
        ArraysCacheManager.releaseCache(cache);
        return biomeArray;
    }

    @Override
    public boolean canGenerateUnZoomed() {
        return true;
    }
}

