/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome;

import com.pg85.otg.generator.biome.OutputType;
import java.util.ArrayList;
import java.util.Arrays;

public class ArraysCache {
    private final int[][] smallArrays = new int[128][256];
    private int smallArraysNext = 0;
    private final ArrayList<int[]> mediumArrays = new ArrayList();
    private int mediumArraysNext = 0;
    private final ArrayList<int[]> largeArrays = new ArrayList();
    private int largeArraysNext = 0;
    private final ArrayList<int[]> extraLargeArrays = new ArrayList();
    private int extraLargeArraysNext = 0;
    boolean isFree = true;
    public OutputType outputType = OutputType.FULL;

    void release() {
        int i;
        for (i = 0; i < this.smallArraysNext; ++i) {
            Arrays.fill(this.smallArrays[i], 0);
        }
        this.smallArraysNext = 0;
        for (i = 0; i < this.mediumArraysNext; ++i) {
            Arrays.fill(this.mediumArrays.get(i), 0);
        }
        this.mediumArraysNext = 0;
        for (i = 0; i < this.largeArraysNext; ++i) {
            Arrays.fill(this.largeArrays.get(i), 0);
        }
        this.largeArraysNext = 0;
        for (i = 0; i < this.extraLargeArraysNext; ++i) {
            Arrays.fill(this.extraLargeArrays.get(i), 0);
        }
        this.extraLargeArraysNext = 0;
        this.isFree = true;
        this.outputType = OutputType.FULL;
    }

    public int[] getArray(int size) {
        int[] array;
        if (size <= 256) {
            int[] array2 = this.smallArrays[this.smallArraysNext];
            ++this.smallArraysNext;
            return array2;
        }
        if (size <= 512) {
            int[] array3;
            if (this.mediumArraysNext == this.mediumArrays.size()) {
                array3 = new int[512];
                this.mediumArrays.add(array3);
            } else {
                array3 = this.mediumArrays.get(this.mediumArraysNext);
            }
            ++this.mediumArraysNext;
            return array3;
        }
        if (size <= 1024) {
            int[] array4;
            if (this.largeArraysNext == this.largeArrays.size()) {
                array4 = new int[1024];
                this.largeArrays.add(array4);
            } else {
                array4 = this.largeArrays.get(this.largeArraysNext);
            }
            ++this.largeArraysNext;
            return array4;
        }
        if (this.extraLargeArraysNext == this.extraLargeArrays.size()) {
            array = new int[size];
            this.extraLargeArrays.add(array);
        } else {
            array = this.extraLargeArrays.get(this.extraLargeArraysNext);
            if (array.length < size) {
                array = new int[size];
                this.extraLargeArrays.set(this.extraLargeArraysNext, array);
            }
        }
        ++this.extraLargeArraysNext;
        return array;
    }
}

