/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.world;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.BiomeConfigFinder;
import com.pg85.otg.configuration.biome.BiomeLoadInstruction;
import com.pg85.otg.configuration.io.FileSettingsWriter;
import com.pg85.otg.configuration.io.SettingsMap;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.forge.biomes.ForgeBiomeRegistryManager;
import com.pg85.otg.forge.biomes.ForgeMojangSettings;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.OTGWorldProvider;
import com.pg85.otg.forge.network.server.ServerPacketManager;
import com.pg85.otg.forge.network.server.packets.DimensionSyncPacket;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.forge.world.WorldHelper;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ServerConfigProvider;
import com.pg85.otg.util.helpers.FileHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultBiome;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class WorldLoader {
    private final File configsDir;
    private final HashMap<String, ForgeWorld> worlds = new HashMap();
    private final HashMap<String, ForgeWorld> unloadedWorlds = new HashMap();

    public WorldLoader(File configsDir) {
        File dataFolder;
        try {
            Field minecraftDir = Loader.class.getDeclaredField("minecraftDir");
            minecraftDir.setAccessible(true);
            dataFolder = new File((File)minecraftDir.get(null), "mods" + File.separator + "OpenTerrainGenerator");
        }
        catch (Throwable e) {
            dataFolder = new File("mods" + File.separator + "OpenTerrainGenerator");
            System.out.println("Could not reflect the Minecraft directory, save location may be unpredicatble.");
            OTG.printStackTrace(LogMarker.FATAL, e);
        }
        this.configsDir = dataFolder;
    }

    public File getConfigsFolder() {
        return this.configsDir;
    }

    private File getWorldDir(String worldName) {
        return new File(this.configsDir, "worlds" + File.separator + worldName);
    }

    public void onServerStopped() {
        this.removeAllWorlds();
    }

    public ForgeWorld getOverWorld() {
        ArrayList<LocalWorld> allWorlds = this.getAllWorlds();
        for (LocalWorld world : allWorlds) {
            if ((((ForgeWorld)world).getWorld() == null || ((ForgeWorld)world).getWorld().field_73011_w == null || ((ForgeWorld)world).getWorld().field_73011_w.getDimension() != 0) && !((ForgeWorld)world).getName().equals("overworld")) continue;
            return (ForgeWorld)world;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForgeWorld getWorld(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("overworld")) {
            return this.getOverWorld();
        }
        ForgeWorld forgeWorld = null;
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            forgeWorld = this.worlds.get(name);
        }
        return forgeWorld;
    }

    public ForgeWorld getWorld(World world) {
        if (world.field_73011_w.getDimension() == 0) {
            return this.getOverWorld();
        }
        if (world.field_73011_w.getDimension() > 1 && world.field_73011_w instanceof OTGWorldProvider) {
            ForgeWorld localWorld = this.getWorld(world.field_73011_w.func_186058_p().func_186065_b());
            if (localWorld == null) {
                return this.getUnloadedWorld(world.field_73011_w.func_186058_p().func_186065_b());
            }
            return localWorld;
        }
        return null;
    }

    public ForgeWorld getWorldByDimId(int dimensionId) {
        ForgeWorld forgeWorld;
        if (dimensionId == 0) {
            forgeWorld = this.getOverWorld();
        } else {
            DimensionType dimType = DimensionManager.getProviderType((int)dimensionId);
            forgeWorld = (ForgeWorld)OTG.getWorld(dimType.func_186065_b());
        }
        return forgeWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForgeWorld getUnloadedWorld(String name) {
        ForgeWorld forgeWorld = null;
        HashMap<String, ForgeWorld> hashMap = this.unloadedWorlds;
        synchronized (hashMap) {
            forgeWorld = this.unloadedWorlds.get(name);
        }
        return forgeWorld;
    }

    public ForgeWorld getUnloadedWorldByDimId(int dimensionId) {
        ForgeWorld forgeWorld;
        if (dimensionId == 0) {
            forgeWorld = this.getOverWorld();
        } else {
            DimensionType dimType = DimensionManager.getProviderType((int)dimensionId);
            forgeWorld = (ForgeWorld)OTG.getUnloadedWorld(dimType.func_186065_b());
        }
        return forgeWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorldUnloaded(String worldName) {
        boolean isUnloaded = false;
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
            synchronized (hashMap2) {
                isUnloaded = this.unloadedWorlds.containsKey(worldName);
            }
        }
        return isUnloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ForgeWorld> getAllLoadedWorlds() {
        ArrayList<ForgeWorld> allWorlds = new ArrayList<ForgeWorld>();
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            allWorlds.addAll(this.worlds.values());
        }
        return allWorlds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ForgeWorld> getUnloadedWorlds() {
        ArrayList<ForgeWorld> unloadedWorldsClone = new ArrayList<ForgeWorld>();
        HashMap<String, ForgeWorld> hashMap = this.unloadedWorlds;
        synchronized (hashMap) {
            unloadedWorldsClone.addAll(this.unloadedWorlds.values());
        }
        return unloadedWorldsClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LocalWorld> getAllWorlds() {
        ArrayList<LocalWorld> allWorlds = new ArrayList<LocalWorld>();
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
            synchronized (hashMap2) {
                allWorlds.addAll(this.worlds.values());
                allWorlds.addAll(this.unloadedWorlds.values());
            }
        }
        return allWorlds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadWorld(World world, boolean unRegisterBiomes) {
        ForgeWorld forgeWorld = this.getWorld(world);
        OTG.log(LogMarker.INFO, "Unloading world \"{}\"...", forgeWorld.getName());
        ForgeWorld loadedWorld = this.worlds.get(forgeWorld.getName());
        if (loadedWorld != null) {
            HashMap<String, ForgeWorld> hashMap = this.worlds;
            synchronized (hashMap) {
                HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
                synchronized (hashMap2) {
                    this.unloadedWorlds.put(forgeWorld.getName(), this.worlds.get(forgeWorld.getName()));
                    this.worlds.remove(forgeWorld.getName());
                }
            }
            if (!loadedWorld.getWorld().field_72995_K) {
                ServerPacketManager.sendDimensionLoadUnloadPacketToAllPlayers(false, forgeWorld.getName(), loadedWorld.getWorld().func_73046_m());
            }
        }
        OTG.log(LogMarker.INFO, "World unloaded", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadedWorld(String worldName) {
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            ForgeWorld forgeWorld = this.worlds.get(worldName);
            if (forgeWorld != null) {
                forgeWorld.deleteWorldSessionData();
                this.worlds.remove(worldName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnloadedWorld(String worldName) {
        HashMap<String, ForgeWorld> hashMap = this.unloadedWorlds;
        synchronized (hashMap) {
            ForgeWorld forgeWorld = this.unloadedWorlds.get(worldName);
            if (forgeWorld != null) {
                forgeWorld.deleteWorldSessionData();
                this.unloadedWorlds.remove(worldName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllWorlds() {
        ArrayList<ForgeWorld> worldsToRemove = new ArrayList<ForgeWorld>();
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
            synchronized (hashMap2) {
                for (ForgeWorld world : this.worlds.values()) {
                    if (world == null) continue;
                    worldsToRemove.add(world);
                }
                for (ForgeWorld worldToRemove : worldsToRemove) {
                    OTG.log(LogMarker.INFO, "Unloading world \"{}\"...", worldToRemove.getName());
                    worldToRemove.unRegisterBiomes();
                    this.worlds.remove(worldToRemove.getName());
                }
                this.unloadedWorlds.clear();
            }
        }
    }

    public void unloadAndUnregisterAllWorlds() {
        OTGDimensionManager.UnloadAllCustomDimensionData();
        this.removeAllWorlds();
        this.clearBiomeDictionary(null);
        ForgeBiomeRegistryManager.clearOTGBiomeIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ForgeWorld getOrCreateForgeWorld(World mcWorld) {
        if (!mcWorld.func_72912_H().func_82571_y().equals("OpenTerrainGenerator")) {
            throw new RuntimeException("Error: OTG tried to load a world that is missing OTG information. Was this world created via OTG? For Forge Single Player, be sure to use the OTG world creation screen.");
        }
        String worldName = WorldHelper.getName(mcWorld);
        File worldConfigsFolder = null;
        worldConfigsFolder = this.getWorldDir(OTG.getDimensionsConfig().getDimensionConfig((String)worldName).PresetName);
        if (worldConfigsFolder == null || !worldConfigsFolder.exists()) {
            return null;
        }
        ForgeWorld world = this.getWorld(worldName);
        if (world == null) {
            world = new ForgeWorld(worldName);
            OTG.log(LogMarker.DEBUG, "Loading configs for world \"{}\"..", world.getName());
            ServerConfigProvider config = new ServerConfigProvider(worldConfigsFolder, world, mcWorld.func_72860_G().func_75765_b());
            world.provideConfigs(config);
            OTG.log(LogMarker.DEBUG, "Completed loading configs for world \"{}\"..", world.getName());
        }
        if (world != null && world.getWorld() == null) {
            world.provideWorldInstance((WorldServer)mcWorld);
        }
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
            synchronized (hashMap2) {
                this.worlds.put(worldName, world);
                this.unloadedWorlds.remove(worldName);
            }
        }
        return world;
    }

    public void createDefaultOTGWorld(String worldName) {
        File worldDir = new File(OTG.getEngine().getWorldsDirectory() + File.separator + worldName);
        ArrayList<File> worldDirs = new ArrayList<File>(2);
        worldDirs.add(new File(worldDir, "WorldBiomes"));
        worldDirs.add(new File(worldDir, "WorldObjects"));
        FileHelper.makeFolders(worldDirs);
        WorldConfig.DefaulWorldData defaultWorldData = WorldConfig.createDefaultOTGWorldConfig(worldDir, worldName);
        SettingsMap settingsMap = defaultWorldData.settingsMap;
        WorldConfig defaultWorldConfig = defaultWorldData.worldConfig;
        FileSettingsWriter.writeToFile(settingsMap, new File(worldDir, "WorldConfig.ini"), WorldConfig.ConfigMode.WriteAll);
        HashSet<BiomeLoadInstruction> biomesToLoad = new HashSet<BiomeLoadInstruction>();
        ArrayList<BiomeLoadInstruction> defaultBiomes = new ArrayList<BiomeLoadInstruction>();
        for (DefaultBiome defaultBiome : DefaultBiome.values()) {
            int id = defaultBiome.Id;
            BiomeLoadInstruction instruction = defaultBiome.getLoadInstructions(ForgeMojangSettings.fromId(id), 128);
            defaultBiomes.add(instruction);
        }
        for (BiomeLoadInstruction defaultBiome : defaultBiomes) {
            biomesToLoad.add(new BiomeLoadInstruction(defaultBiome.getBiomeName(), defaultBiome.getBiomeTemplate()));
        }
        ArrayList<File> biomeDirs = new ArrayList<File>(1);
        biomeDirs.add(new File(worldDir, "WorldBiomes"));
        BiomeConfigFinder biomeConfigFinder = new BiomeConfigFinder(OTG.getPluginConfig().biomeConfigExtension);
        Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs = biomeConfigFinder.findBiomes(defaultWorldConfig, defaultWorldConfig.worldHeightScale, biomeDirs, biomesToLoad);
        for (BiomeConfigFinder.BiomeConfigStub biomeConfigStub : biomeConfigStubs.values()) {
            BiomeConfig biomeConfig = new BiomeConfig(biomeConfigStub.getLoadInstructions(), biomeConfigStub, biomeConfigStub.getSettings(), defaultWorldConfig);
            File writeFile = biomeConfigStub.getFile();
            if (!biomeConfig.biomeExtends.isEmpty()) {
                writeFile = new File(writeFile.getAbsolutePath() + ".inherited");
            }
            FileSettingsWriter.writeToFile(biomeConfig.getSettingsAsMap(), writeFile, defaultWorldConfig.settingsMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void registerClientWorldBukkit(WorldClient mcWorld, DataInputStream wrappedStream) throws IOException {
        ForgeWorld world = DimensionSyncPacket.registerClientWorldBukkit(mcWorld, wrappedStream, this.worlds, this.unloadedWorlds);
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
            synchronized (hashMap2) {
                this.worlds.put(world.getName(), world);
                this.unloadedWorlds.remove(world.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void LoadClientWorldFromPacket(ForgeWorld world) {
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
            synchronized (hashMap2) {
                this.worlds.put(world.getName(), world);
                this.unloadedWorlds.remove(world.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBiomeDictionary(ForgeWorld world) {
        HashMap typesToRestore = new HashMap();
        for (Object biome : ForgeRegistries.BIOMES.getEntries()) {
            String string = ((ResourceLocation)biome.getKey()).func_110624_b();
            if (string.equals("OpenTerrainGenerator") || string.equals("terraincontrol") || typesToRestore.containsKey(biome.getValue())) continue;
            typesToRestore.put(biome.getValue(), ForgeRegistries.BIOMES.containsValue((IForgeRegistryEntry)biome.getValue()) ? BiomeDictionary.getTypes((Biome)((Biome)biome.getValue())) : new HashSet());
        }
        if (world != null) {
            Iterator iterator = this.worlds;
            synchronized (iterator) {
                for (LocalWorld localWorld : this.worlds.values()) {
                    if (localWorld == world) continue;
                    for (LocalBiome localBiome : ((ForgeWorld)localWorld).biomeNames.values()) {
                        if (typesToRestore.containsKey(((ForgeBiome)localBiome).biomeBase)) continue;
                        typesToRestore.put(((ForgeBiome)localBiome).biomeBase, ForgeRegistries.BIOMES.containsValue((IForgeRegistryEntry)((ForgeBiome)localBiome).biomeBase) ? BiomeDictionary.getTypes((Biome)((ForgeBiome)localBiome).biomeBase) : new HashSet());
                    }
                }
            }
        }
        try {
            Class<?> fieldClass;
            Field[] declaredfields = BiomeDictionary.class.getDeclaredFields();
            for (Field field : declaredfields) {
                fieldClass = field.getType();
                if (!fieldClass.equals(Map.class)) continue;
                field.setAccessible(true);
                HashMap biomeRegistryAvailabiltyMap = (HashMap)field.get(BiomeDictionary.class);
                biomeRegistryAvailabiltyMap.clear();
            }
            declaredfields = BiomeDictionary.Type.class.getDeclaredFields();
            for (Field field : declaredfields) {
                fieldClass = field.getType();
                if (!fieldClass.equals(Map.class)) continue;
                field.setAccessible(true);
                HashMap byName = (HashMap)field.get(BiomeDictionary.class);
                for (BiomeDictionary.Type type : byName.values()) {
                    Field[] typeDeclaredfields;
                    for (Field typeField : typeDeclaredfields = BiomeDictionary.Type.class.getDeclaredFields()) {
                        Class<?> typeFieldClass = typeField.getType();
                        if (!typeFieldClass.equals(Set.class)) continue;
                        typeField.setAccessible(true);
                        Set biomes = (Set)typeField.get(type);
                        try {
                            biomes.clear();
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        for (Map.Entry biomeToRestore : typesToRestore.entrySet()) {
            BiomeDictionary.addTypes((Biome)((Biome)biomeToRestore.getKey()), (BiomeDictionary.Type[])((Set)biomeToRestore.getValue()).toArray(new BiomeDictionary.Type[((Set)biomeToRestore.getValue()).size()]));
        }
    }
}

