/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network.client.packets;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.forge.biomes.ForgeBiomeRegistryManager;
import com.pg85.otg.forge.blocks.portal.PortalColors;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.network.AbstractServerMessageHandler;
import com.pg85.otg.forge.network.OTGPacket;
import com.pg85.otg.forge.network.server.ServerPacketManager;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.helpers.StreamHelper;
import io.netty.buffer.ByteBuf;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.StringUtils;

public class CreateDeleteDimensionPacket
extends OTGPacket {
    public CreateDeleteDimensionPacket() {
    }

    public CreateDeleteDimensionPacket(ByteBuf nettyBuffer) {
        super(nettyBuffer);
    }

    public static void writeCreatePacketToStream(DimensionConfig dimensionConfig, DataOutput stream) throws IOException {
        stream.writeInt(6);
        stream.writeInt(0);
        StreamHelper.writeStringToStream(stream, dimensionConfig.toYamlString());
    }

    public static void writeDeletePacketToStream(String dimensionName, DataOutput stream) throws IOException {
        stream.writeInt(6);
        stream.writeInt(1);
        StreamHelper.writeStringToStream(stream, dimensionName);
    }

    public static class Handler
    extends AbstractServerMessageHandler<CreateDeleteDimensionPacket> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, CreateDeleteDimensionPacket message, MessageContext ctx) {
            try {
                if (!player.func_70003_b(2, "openterraingenerator.ui.create")) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Could not process: Missing permission 'openterraingenerator.ui.create'"));
                    IMessage iMessage = null;
                    return iMessage;
                }
                int packetType = message.getStream().readInt();
                if (packetType == 0) {
                    String dimConfigYaml = StreamHelper.readStringFromStream(message.getStream());
                    final DimensionConfig dimConfig = DimensionConfig.fromYamlString(dimConfigYaml);
                    WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
                    mainThread.func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            if (OTG.getDimensionsConfig().Dimensions.size() + 1 > PortalColors.portalColors.size()) {
                                OTG.log(LogMarker.INFO, "Warning: Client tried to create a dimension, but all portal colors are in use.", new Object[0]);
                                ServerPacketManager.sendDimensionSynchPacketToAllPlayers(player.func_184102_h());
                                return;
                            }
                            if (OTG.getDimensionsConfig().Overworld.PresetName != null && OTG.getDimensionsConfig().Overworld.PresetName.equals(dimConfig.PresetName)) {
                                return;
                            }
                            for (DimensionConfig existingDimConfig : OTG.getDimensionsConfig().Dimensions) {
                                if (!existingDimConfig.PresetName.equals(dimConfig.PresetName)) continue;
                                return;
                            }
                            PortalColors.correctPortalColor(dimConfig, OTG.getDimensionsConfig().getAllDimensions());
                            ArrayList<String> presetNames = new ArrayList<String>();
                            presetNames.add(dimConfig.PresetName);
                            if (!ForgeBiomeRegistryManager.JEID && !OTG.getEngine().areEnoughBiomeIdsAvailableForPresets(presetNames)) {
                                ServerPacketManager.sendDimensionSynchPacketToAllPlayers(player.func_184102_h());
                                OTG.log(LogMarker.INFO, "Warning: Client tried to create a dimension, but not enough biome id's are available.", new Object[0]);
                                return;
                            }
                            long seed = new Random().nextLong();
                            String sSeed = dimConfig.Seed;
                            if (sSeed != null && !StringUtils.isEmpty((CharSequence)sSeed)) {
                                try {
                                    long j = Long.parseLong(sSeed);
                                    if (j != 0L) {
                                        seed = j;
                                    }
                                }
                                catch (NumberFormatException var7) {
                                    seed = sSeed.hashCode();
                                }
                            }
                            OTG.IsNewWorldBeingCreated = true;
                            if (!OTGDimensionManager.createDimension(dimConfig, seed, true)) {
                                OTG.IsNewWorldBeingCreated = false;
                                ServerPacketManager.sendDimensionSynchPacketToAllPlayers(player.func_184102_h());
                                OTG.log(LogMarker.INFO, "Warning: Client tried to create a dimension, but the dimension id " + dimConfig.DimensionId + " + is not available.", new Object[0]);
                                return;
                            }
                            OTG.IsNewWorldBeingCreated = false;
                            ForgeWorld createdWorld = (ForgeWorld)OTG.getWorld(dimConfig.PresetName);
                            if (dimConfig.Settings.CanDropChunk) {
                                DimensionManager.unloadWorld((int)createdWorld.getWorld().field_73011_w.getDimension());
                            }
                            ServerPacketManager.sendDimensionSynchPacketToAllPlayers(player.func_184102_h());
                        }
                    });
                    IMessage iMessage = null;
                    return iMessage;
                }
                if (packetType == 1) {
                    final String worldName = StreamHelper.readStringFromStream(message.getStream());
                    WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
                    mainThread.func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            OTGDimensionManager.DeleteDimensionServer(worldName, player.func_184102_h());
                        }
                    });
                    IMessage iMessage = null;
                    return iMessage;
                }
                try {
                    throw new RuntimeException();
                }
                catch (Exception e) {
                    OTG.log(LogMarker.FATAL, "Failed to receive packet", new Object[0]);
                    OTG.printStackTrace(LogMarker.FATAL, e);
                }
            }
            finally {
                message.getData().release();
            }
            return null;
        }
    }
}

