/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events.dimensions;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.blocks.portal.BlockPortalOTG;
import com.pg85.otg.forge.dimensions.OTGTeleporter;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.forge.world.ForgeWorld;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityTravelToDimensionListener {
    @SubscribeEvent
    public void entityTravelToDimension(EntityTravelToDimensionEvent e) {
        if (e.getDimension() == -1) {
            World entityWorld = e.getEntity().func_130014_f_();
            boolean portalFound = false;
            BlockPos entityPos = e.getEntity().func_180425_c();
            BlockPos closestPortalPos = null;
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    for (int y = -2; y < 4; ++y) {
                        if (!(entityWorld.func_180495_p(new BlockPos(entityPos.func_177958_n() + x, entityPos.func_177956_o() + y, entityPos.func_177952_p() + z)).func_177230_c() instanceof BlockPortalOTG)) continue;
                        if (closestPortalPos == null || Math.abs(entityPos.func_177958_n() + x) + Math.abs(entityPos.func_177956_o() + y) + Math.abs(entityPos.func_177952_p() + z) < Math.abs(entityPos.func_177958_n() - closestPortalPos.func_177958_n()) + Math.abs(entityPos.func_177956_o() - closestPortalPos.func_177956_o()) + Math.abs(entityPos.func_177952_p() - closestPortalPos.func_177952_p())) {
                            closestPortalPos = new BlockPos(entityPos.func_177958_n() + x, entityPos.func_177956_o() + y, entityPos.func_177952_p() + z);
                        }
                        portalFound = true;
                    }
                }
            }
            if (!portalFound) {
                return;
            }
            BlockPos playerPortalMaterialBlockPos = new BlockPos(closestPortalPos);
            IBlockState blockState = entityWorld.func_180495_p(playerPortalMaterialBlockPos);
            while (blockState.func_177230_c() instanceof BlockPortalOTG && playerPortalMaterialBlockPos.func_177956_o() > 0) {
                playerPortalMaterialBlockPos = new BlockPos(playerPortalMaterialBlockPos.func_177958_n(), playerPortalMaterialBlockPos.func_177956_o() - 1, playerPortalMaterialBlockPos.func_177952_p());
                blockState = entityWorld.func_180495_p(playerPortalMaterialBlockPos);
            }
            ArrayList<LocalWorld> forgeWorlds = ((ForgeEngine)OTG.getEngine()).getAllWorlds();
            int destinationDim = 0;
            boolean bOTGPortalFound = false;
            ForgeMaterialData playerPortalMaterial = ForgeMaterialData.ofMinecraftBlockState(blockState);
            ForgeWorld overWorld = ((ForgeEngine)OTG.getEngine()).getOverWorld();
            boolean bFound = false;
            if (overWorld == null) {
                DimensionConfig dimConfig = OTG.getDimensionsConfig().Overworld;
                ArrayList<LocalMaterialData> portalMaterials = dimConfig.Settings.GetDimensionPortalMaterials();
                boolean bIsPortalMaterial = false;
                for (LocalMaterialData portalMaterial : portalMaterials) {
                    if (!playerPortalMaterial.equals(portalMaterial)) continue;
                    bIsPortalMaterial = true;
                    bOTGPortalFound = true;
                    break;
                }
                if (bIsPortalMaterial) {
                    if (e.getEntity().field_71093_bK != 0) {
                        destinationDim = 0;
                        bFound = true;
                    } else {
                        destinationDim = 0;
                    }
                }
            }
            if (!bFound) {
                for (LocalWorld localWorld : forgeWorlds) {
                    ForgeWorld forgeWorld = (ForgeWorld)localWorld;
                    DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(forgeWorld.getName());
                    ArrayList<LocalMaterialData> portalMaterials = dimConfig.Settings.GetDimensionPortalMaterials();
                    boolean bIsPortalMaterial = false;
                    for (LocalMaterialData portalMaterial : portalMaterials) {
                        if (!playerPortalMaterial.equals(portalMaterial)) continue;
                        bIsPortalMaterial = true;
                        bOTGPortalFound = true;
                        break;
                    }
                    if (!bIsPortalMaterial || forgeWorld.getWorld().field_73011_w.getDimension() == e.getEntity().field_71093_bK) continue;
                    destinationDim = forgeWorld.getWorld().field_73011_w.getDimension();
                    break;
                }
            }
            if (!bOTGPortalFound) {
                return;
            }
            if (playerPortalMaterialBlockPos.func_177956_o() > 0 && bOTGPortalFound) {
                e.setCanceled(true);
                int newDimension = destinationDim;
                if (newDimension == 0 && e.getEntity().field_71093_bK == 0) {
                    entityWorld.func_175698_g(entityPos);
                    return;
                }
                if (e.getEntity() instanceof EntityPlayerMP) {
                    OTGTeleporter.changeDimension(newDimension, (EntityPlayerMP)e.getEntity(), true, false);
                } else {
                    OTGTeleporter.changeDimension(newDimension, e.getEntity());
                }
            }
        }
    }
}

