/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.dimensions.OTGTeleporter;
import com.pg85.otg.forge.world.ForgeWorld;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TPCommand
extends BaseCommand {
    TPCommand() {
        this.name = "tp";
        this.usage = "tp <biome/dimension name or id> [-p player]";
        this.description = "Attempt to teleport to the target biome or dimension (Max range: 1000 chunks).";
    }

    @Override
    public boolean onCommand(ICommandSender sender, List<String> args) {
        ForgeBiome targetBiome;
        if (args.isEmpty()) {
            return false;
        }
        EntityPlayerMP player = null;
        if (args.contains("-p")) {
            String name = args.get(args.size() - 1);
            player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name);
            if (player == null) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Could not find player " + name, new Object[0]));
                return true;
            }
        } else if (!(sender.func_174793_f() instanceof EntityPlayerMP)) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Must be a player to send this command without player argument " + this.name, new Object[0]));
            return true;
        }
        if (player == null) {
            player = (EntityPlayerMP)sender.func_174793_f();
        }
        BlockPos pos = player.func_180425_c();
        int playerX = pos.func_177958_n();
        int playerZ = pos.func_177952_p();
        LocalWorld world = this.getWorld(sender, "");
        if (world == null) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Could not find world for sender", new Object[0]));
            return true;
        }
        StringBuilder biomeOrDimensionName = new StringBuilder();
        for (String arg : args) {
            if (arg.equalsIgnoreCase("-p")) break;
            biomeOrDimensionName.append(arg).append(" ");
        }
        if (biomeOrDimensionName.toString().trim().length() <= 0) {
            return false;
        }
        biomeOrDimensionName = new StringBuilder(biomeOrDimensionName.toString().trim());
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Searching for destination biome or dimension \"" + VALUE_COLOR + biomeOrDimensionName + MESSAGE_COLOR + "\".", new Object[0]));
        for (int i = -1; i < 1024; ++i) {
            DimensionType dimensionType;
            if (!DimensionManager.isDimensionRegistered((int)i) || !(dimensionType = DimensionManager.getProviderType((int)i)).func_186065_b().toLowerCase().trim().equals(biomeOrDimensionName.toString().toLowerCase())) continue;
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Dimension found, teleport commenced", new Object[0]));
            OTGTeleporter.changeDimension(i, player, false, true);
            return true;
        }
        int biomeId = -1;
        try {
            biomeId = Integer.parseInt(biomeOrDimensionName.toString().replace(" ", ""));
        }
        catch (NumberFormatException dimensionType) {
            // empty catch block
        }
        Biome targetMCBiome = null;
        if (biomeId == -1) {
            targetBiome = (ForgeBiome)world.getBiomeByNameOrNull(biomeOrDimensionName.toString());
            if (targetBiome != null) {
                targetMCBiome = targetBiome.biomeBase;
            }
        } else {
            targetBiome = (ForgeBiome)world.getBiomeByOTGIdOrNull(biomeId);
            if (targetBiome != null) {
                targetMCBiome = targetBiome.biomeBase;
            }
        }
        if (targetMCBiome != null) {
            ArrayList<Biome> biomes = new ArrayList<Biome>();
            biomes.add(targetMCBiome);
            BlockPos biomePos = ((ForgeWorld)world).getWorld().func_72959_q().func_180630_a(playerX, playerZ, 8000, biomes, new Random());
            if (biomePos != null) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Teleporting to \"" + VALUE_COLOR + biomeOrDimensionName + MESSAGE_COLOR + "\".", new Object[0]));
                player.func_70634_a((double)biomePos.func_177958_n(), (double)world.getHighestBlockYAt(biomePos.func_177958_n(), biomePos.func_177952_p(), true, true, false, false, false, null), (double)biomePos.func_177952_p());
                return true;
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Could not find biome \"" + biomeOrDimensionName + "\".", new Object[0]));
        return true;
    }
}

