/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.exception.BiomeNotFoundException;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.util.BiomeIds;
import com.pg85.otg.util.minecraft.defaults.EntityNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeCommand
extends BaseCommand {
    BiomeCommand() {
        this.name = "biome";
        this.usage = "biome [-f] [-s] [-d] [-m]";
        this.description = "View information about your current biome.";
        this.needsOp = false;
    }

    @Override
    public boolean onCommand(ICommandSender sender, List<String> args) {
        BlockPos location = this.getLocation(sender);
        int x = location.func_177958_n();
        int y = location.func_177956_o();
        int z = location.func_177952_p();
        LocalWorld world = this.getWorld(sender, "");
        if (world == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(ERROR_COLOR + "OTG is not enabled for this world."));
            return true;
        }
        LocalBiome biome = world.getBiome(x, z);
        BiomeIds biomeIds = biome.getIds();
        sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "According to the biome generator, you are in the " + VALUE_COLOR + biome.getName() + MESSAGE_COLOR + " biome, with id " + VALUE_COLOR + biomeIds.getOTGBiomeId()));
        if (args.contains("-f")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(""));
            sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "The base temperature of this biome is " + VALUE_COLOR + biome.getBiomeConfig().biomeTemperature + MESSAGE_COLOR + ", at your height it is " + VALUE_COLOR + biome.getTemperatureAt(x, y, z)));
        }
        if (args.contains("-s")) {
            try {
                String savedBiomeName = world.getSavedBiomeName(x, z);
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "According to the world save files, you are in the " + VALUE_COLOR + savedBiomeName + MESSAGE_COLOR + " biome, with id " + VALUE_COLOR + biome.getIds().getSavedId(), new Object[0]));
            }
            catch (BiomeNotFoundException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
            }
        }
        if (args.contains("-d")) {
            try {
                ForgeBiome forgeBiome = (ForgeBiome)world.getBiome(x, z);
                Set types = BiomeDictionary.getTypes((Biome)forgeBiome.biomeBase);
                String typesString = "";
                for (BiomeDictionary.Type type : types) {
                    if (typesString.length() == 0) {
                        typesString = typesString + type.getName();
                        continue;
                    }
                    typesString = typesString + ", " + type.getName();
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "BiomeDict: " + VALUE_COLOR + typesString, new Object[0]));
            }
            catch (BiomeNotFoundException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
            }
        }
        if (args.contains("-m")) {
            try {
                ForgeBiome calculatedBiome = (ForgeBiome)world.getCalculatedBiome(x, z);
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.AQUA + "-- Biome mob spawning settings --", new Object[0]));
                for (EnumCreatureType creatureType : EnumCreatureType.values()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + creatureType.name() + ": ", new Object[0]));
                    ArrayList creatureList = (ArrayList)calculatedBiome.biomeBase.func_76747_a(creatureType);
                    if (creatureList == null || creatureList.size() <= 0) continue;
                    for (Biome.SpawnListEntry spawnListEntry : creatureList) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(VALUE_COLOR + "{\"mob\": \"" + EntityNames.toInternalName(spawnListEntry.field_76300_b.getSimpleName()) + "\", \"weight\": " + spawnListEntry.field_76292_a + ", \"min\": " + spawnListEntry.field_76301_c + ", \"max\": " + spawnListEntry.field_76299_d + "}", new Object[0]));
                    }
                }
            }
            catch (BiomeNotFoundException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
            }
        }
        return true;
    }
}

