/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.biomes;

import com.google.common.collect.BiMap;
import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.BiomeConfigFinder;
import com.pg85.otg.configuration.biome.BiomeLoadInstruction;
import com.pg85.otg.configuration.standard.MojangSettings;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.forge.biomes.ForgeMojangSettings;
import com.pg85.otg.forge.biomes.OTGBiome;
import com.pg85.otg.forge.util.MobSpawnGroupHelper;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.util.BiomeIds;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultBiome;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeBiomeRegistryManager {
    public static final boolean JEID = Loader.isModLoaded((String)"jeid");
    private BiMap<Integer, Biome> ids = null;
    private BiMap<ResourceLocation, Biome> names = null;

    public static int getRegisteredBiomeId(String resourceLocationString, String worldName) {
        if (resourceLocationString != null && !resourceLocationString.trim().isEmpty()) {
            String[] resourceLocationStringArr = resourceLocationString.split(":");
            if (resourceLocationStringArr.length == 1) {
                ResourceLocation resourceLocation = new ResourceLocation("openterraingenerator".toLowerCase(), worldName + "_" + resourceLocationStringArr[0].replaceAll(" ", "_"));
                Biome requestedBiome = (Biome)ForgeRegistries.BIOMES.getValue(resourceLocation);
                return ((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().getBiomeRegistryId(requestedBiome);
            }
            if (resourceLocationStringArr.length == 2) {
                ResourceLocation resourceLocation = new ResourceLocation(resourceLocationStringArr[0], resourceLocationStringArr[1]);
                Biome requestedBiome = (Biome)ForgeRegistries.BIOMES.getValue(resourceLocation);
                return ((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().getBiomeRegistryId(requestedBiome);
            }
        }
        return -1;
    }

    private static void unregisterBiome(LocalBiome localBiome, String worldName) {
        String biomeNameForRegistry = StringHelper.toComputerFriendlyName(localBiome.getName());
        String resourceDomain = "OpenTerrainGenerator".toLowerCase();
        ResourceLocation registryKey = new ResourceLocation(resourceDomain, worldName + "_" + biomeNameForRegistry);
        ((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().unRegisterForgeBiome(registryKey);
        ((ForgeEngine)OTG.getEngine()).unregisterOTGBiomeId(worldName, localBiome.getIds().getOTGBiomeId());
    }

    public static void clearOTGBiomeIds() {
        BitSet biomeRegistryAvailabiltyMap = ((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().getBiomeRegistryAvailabiltyMap();
        for (Map.Entry biome : ForgeRegistries.BIOMES.getEntries()) {
            if (!((ResourceLocation)biome.getKey()).func_110624_b().toLowerCase().equals("openterraingenerator")) continue;
            OTG.log(LogMarker.DEBUG, "Unregistering " + ((Biome)biome.getValue()).field_76791_y, new Object[0]);
            int biomeId = ((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().getBiomeRegistryId((Biome)biome.getValue());
            if (biomeId <= -1 || biome != Biome.func_150568_d((int)biomeId)) continue;
            biomeRegistryAvailabiltyMap.set(biomeId, false);
        }
    }

    public static ForgeBiome getOrCreateBiome(BiomeConfig biomeConfig, BiomeIds biomeIds, String worldName, ConfigProvider configProvider) {
        Biome biome = null;
        String resourceDomain = "openterraingenerator";
        String biomeNameForRegistry = worldName.toLowerCase() + "_" + StringHelper.toComputerFriendlyName(biomeConfig.getName());
        ResourceLocation registryKey = new ResourceLocation(resourceDomain, biomeNameForRegistry);
        Biome alreadyRegisteredBiome = (Biome)ForgeRegistries.BIOMES.getValue(registryKey);
        if (alreadyRegisteredBiome != null) {
            biome = alreadyRegisteredBiome;
        } else {
            OTGBiome customBiome = new OTGBiome(biomeConfig, registryKey);
            ForgeEngine forgeEngine = (ForgeEngine)OTG.getEngine();
            if (biomeIds.getOTGBiomeId() > -1 && biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.length() > 0) {
                forgeEngine.getBiomeRegistryManager().registerForgeBiome(registryKey, customBiome);
                customBiome.savedId = biomeIds.getSavedId();
            } else if (biomeIds.getSavedId() > -1) {
                int newId;
                customBiome.savedId = newId = forgeEngine.getBiomeRegistryManager().registerForgeBiomeWithId(biomeIds.getSavedId(), registryKey, customBiome);
            } else {
                int newId = forgeEngine.getBiomeRegistryManager().registerForgeBiomeWithId(registryKey, customBiome);
                biomeIds.setSavedId(newId);
                customBiome.savedId = newId;
            }
            OTG.log(LogMarker.DEBUG, "{}: {}, {}, {}, {}", biomeIds.isVirtual() ? "Virtual " : "Custom ", biomeConfig.getName(), biomeIds.getSavedId(), biomeIds.getOTGBiomeId(), registryKey.toString());
            biome = customBiome;
        }
        Biome existingBiome = Biome.func_150568_d((int)biomeIds.getSavedId());
        if (!(JEID || biomeIds.getSavedId() >= 0 && biomeIds.getSavedId() < 256)) {
            throw new RuntimeException("Could not allocate the requested id " + biomeIds.getSavedId() + " for biome " + biomeConfig.getName() + ". All available id's under 256 have been allocated\n. To proceed, adjust your WorldConfig or use the ReplaceToBiomeName feature to make the biome virtual.");
        }
        ForgeBiome forgeBiome = new ForgeBiome(biome, biomeConfig, biomeIds);
        ForgeBiomeRegistryManager.registerBiomeInBiomeDictionary(biome, existingBiome, biomeConfig, configProvider);
        return forgeBiome;
    }

    private static void registerBiomeInBiomeDictionary(Biome biome, Biome sourceBiome, BiomeConfig biomeConfig, ConfigProvider configProvider) {
        ArrayList<Object> types = new ArrayList();
        if (biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.length() > 0) {
            if (sourceBiome != null) {
                Set existingTypes = BiomeDictionary.getTypes((Biome)sourceBiome);
                types = new ArrayList(existingTypes);
            } else {
                LocalBiome replaceToBiome = configProvider.getBiomeByOTGIdOrNull(((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().getBiomeRegistryId(sourceBiome != null ? sourceBiome : biome));
                if (replaceToBiome == null) {
                    int replaceToBiomeId = ((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().getBiomeRegistryId(sourceBiome != null ? sourceBiome : biome);
                    replaceToBiome = OTG.getBiomeByOTGId(replaceToBiomeId);
                }
                if (replaceToBiome != null && replaceToBiome.getBiomeConfig().biomeDictId != null) {
                    types = ForgeBiomeRegistryManager.getTypesList(replaceToBiome.getBiomeConfig().biomeDictId.split(","));
                }
            }
        } else if (biomeConfig.biomeDictId != null && biomeConfig.biomeDictId.trim().length() > 0) {
            types = ForgeBiomeRegistryManager.getTypesList(biomeConfig.biomeDictId.split(","));
        }
        BiomeDictionary.Type[] typeArr = new BiomeDictionary.Type[types.size()];
        types.toArray(typeArr);
        if (!ForgeRegistries.BIOMES.containsValue((IForgeRegistryEntry)biome)) {
            OTG.log(LogMarker.WARN, "Biome " + biome.field_76791_y + " could not be found in the registry. This could be because it is a virtual biome (id > 255) but does not have a ReplaceToBiomeName configured.", new Object[0]);
        }
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])typeArr);
    }

    private static ArrayList<BiomeDictionary.Type> getTypesList(String[] typearr) {
        ArrayList<BiomeDictionary.Type> types = new ArrayList<BiomeDictionary.Type>();
        for (String typeString : typearr) {
            if (typeString == null || typeString.trim().length() <= 0) continue;
            BiomeDictionary.Type type = null;
            typeString = typeString.trim();
            try {
                type = BiomeDictionary.Type.getType((String)typeString, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{null});
            }
            catch (Exception ex) {
                OTG.log(LogMarker.WARN, "Can't find BiomeDictId: \"" + typeString + "\".", new Object[0]);
            }
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    public static void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub biomeConfigStub, String biomeResourceLocation) {
        String resourceLocation;
        Biome biome = null;
        String[] resourceLocationArr = biomeResourceLocation.split(":");
        String resourceDomain = resourceLocationArr.length > 1 ? resourceLocationArr[0] : null;
        biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(resourceDomain, resourceLocation = resourceLocationArr.length > 1 ? resourceLocationArr[1] : resourceLocationArr[0]));
        if (biome != null) {
            biomeConfigStub.spawnMonstersMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnMonstersMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.MONSTER));
            biomeConfigStub.spawnCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.CREATURE));
            biomeConfigStub.spawnAmbientCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnAmbientCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.AMBIENT_CREATURE));
            biomeConfigStub.spawnWaterCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnWaterCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.WATER_CREATURE));
        } else {
            OTG.log(LogMarker.WARN, "Biome " + biomeResourceLocation + " not found for InheritMobsFromBiomeName in " + biomeConfigStub.getBiomeName() + ".bc", new Object[0]);
        }
    }

    private Biome getRegisteredBiome(int id) {
        if (this.ids == null) {
            try {
                Field[] fields;
                for (Field field : fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    field.setAccessible(true);
                    this.ids = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        try {
            return (Biome)this.ids.get((Object)id);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public int getBiomeRegistryId(Biome biome) {
        if (this.ids == null) {
            try {
                Field[] fields;
                for (Field field : fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    field.setAccessible(true);
                    this.ids = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        try {
            return biome == null ? -1 : (Integer)this.ids.inverse().get((Object)biome);
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    private void registerForgeBiome(ResourceLocation resourceLocation, Biome biome) {
        OTG.log(LogMarker.DEBUG, "Registering biome " + resourceLocation.toString(), new Object[0]);
        if (this.names == null) {
            try {
                Field[] fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields();
                boolean isFirst = true;
                for (Field field : fields) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    field.setAccessible(true);
                    this.names = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.names.put((Object)resourceLocation, (Object)biome);
    }

    private int registerForgeBiomeWithId(ResourceLocation resourceLocation, Biome biome) {
        return this.registerForgeBiomeWithId(-1, resourceLocation, biome);
    }

    private int registerForgeBiomeWithId(int id, ResourceLocation resourceLocation, Biome biome) {
        Field[] fields;
        OTG.log(LogMarker.DEBUG, "Registering biome " + resourceLocation.toString() + " " + id, new Object[0]);
        BitSet biomeRegistryAvailabiltyMap = this.getBiomeRegistryAvailabiltyMap();
        if (id == -1) {
            id = biomeRegistryAvailabiltyMap.nextClearBit(0);
        }
        if (this.ids == null) {
            try {
                for (Field field : fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    field.setAccessible(true);
                    this.ids = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.names == null) {
            try {
                fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields();
                boolean isFirst = true;
                for (Field field : fields) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    field.setAccessible(true);
                    this.names = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.names.put((Object)resourceLocation, (Object)biome);
        Biome biomeAtId = (Biome)this.ids.get((Object)id);
        if (biomeAtId != null) {
            OTG.log(LogMarker.WARN, "Tried to register biome " + resourceLocation.toString() + " to a id " + id + " but it is occupied by biome: " + biomeAtId.getRegistryName().toString() + ". This can happen when changing mods setup for existing worlds, which causes the biome registry to change. This can also happen when migrating a world from OTG v6 or lower to OTG v8 or higher, if the world had biome conflicts in v6.", new Object[0]);
            id = biomeRegistryAvailabiltyMap.nextClearBit(0);
            OTG.log(LogMarker.WARN, "Substituting id " + id + " for biome " + resourceLocation.toString(), new Object[0]);
        }
        this.ids.put((Object)id, (Object)biome);
        biomeRegistryAvailabiltyMap.set(id, true);
        return id;
    }

    private void unRegisterForgeBiome(ResourceLocation resourceLocation) {
        int biomeId;
        OTG.log(LogMarker.DEBUG, "Unregistering biome " + resourceLocation.toString(), new Object[0]);
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(resourceLocation);
        BitSet biomeRegistryAvailabiltyMap = this.getBiomeRegistryAvailabiltyMap();
        try {
            biomeId = ((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().getBiomeRegistryId(biome);
            if (biomeId > -1 && ((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().getRegisteredBiome(biomeId) == biome) {
                biomeRegistryAvailabiltyMap.set(biomeId, false);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            OTG.log(LogMarker.FATAL, "Could not unregister " + biome.field_76791_y + ", aborting.", new Object[0]);
            throw new RuntimeException("Could not unregister " + biome.field_76791_y + ", aborting.");
        }
        if (this.names == null) {
            try {
                Field[] fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields();
                boolean isFirst = true;
                Field[] fieldArray = fields;
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    Field field = fieldArray[i];
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    field.setAccessible(true);
                    this.names = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.ids == null) {
            try {
                Field[] fields;
                for (Field field : fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    field.setAccessible(true);
                    this.ids = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.names.remove((Object)resourceLocation, (Object)biome);
        try {
            biomeId = (Integer)this.ids.inverse().get((Object)biome);
            this.ids.remove((Object)biomeId, (Object)biome);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public BitSet getBiomeRegistryAvailabiltyMap() {
        BitSet biomeRegistryAvailabiltyMap = null;
        try {
            Field[] fields;
            for (Field field : fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(BitSet.class)) continue;
                field.setAccessible(true);
                biomeRegistryAvailabiltyMap = (BitSet)field.get(ForgeRegistries.BIOMES);
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return biomeRegistryAvailabiltyMap;
    }

    public static void unregisterBiomes(HashMap<String, LocalBiome> biomeNames, ForgeWorld forgeWorld) {
        for (LocalBiome localBiome : forgeWorld.biomeNames.values()) {
            ForgeBiomeRegistryManager.unregisterBiome(localBiome, forgeWorld.getName());
        }
        ((ForgeEngine)OTG.getEngine()).getWorldLoader().clearBiomeDictionary(forgeWorld);
    }

    public static List<BiomeLoadInstruction> getDefaultBiomes() {
        ArrayList<BiomeLoadInstruction> standardBiomes = new ArrayList<BiomeLoadInstruction>();
        for (DefaultBiome defaultBiome : DefaultBiome.values()) {
            int id = defaultBiome.Id;
            BiomeLoadInstruction instruction = defaultBiome.getLoadInstructions(ForgeMojangSettings.fromId(id), 128);
            standardBiomes.add(instruction);
        }
        return standardBiomes;
    }

    public int getAvailableBiomeIdsCount() {
        if (JEID) {
            return Integer.MAX_VALUE;
        }
        BitSet biomeRegistryAvailabiltyMap = this.getBiomeRegistryAvailabiltyMap();
        int availableIds = 0;
        for (int i = 0; i < 256; ++i) {
            if (i < biomeRegistryAvailabiltyMap.size() && biomeRegistryAvailabiltyMap.get(i)) continue;
            ++availableIds;
        }
        return availableIds;
    }
}

