/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.pg85.otg.OTG;
import com.pg85.otg.OTGEngine;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.BiomeConfigFinder;
import com.pg85.otg.configuration.biome.BiomeLoadInstruction;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.forge.biomes.ForgeBiomeRegistryManager;
import com.pg85.otg.forge.generator.ForgeChunkBuffer;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.forge.network.server.ServerPacketManager;
import com.pg85.otg.forge.util.ForgeLogger;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.forge.world.ForgeWorldSession;
import com.pg85.otg.forge.world.WorldLoader;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.network.ServerConfigProvider;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;

public class ForgeEngine
extends OTGEngine {
    private ForgeBiomeRegistryManager biomeRegistryManager;
    private WorldLoader worldLoader;
    private long lastPregeneratorStatusUpdateTime = System.currentTimeMillis();

    public ForgeEngine() {
        super(new ForgeLogger());
        this.worldLoader = new WorldLoader(new File(Loader.instance().getConfigDir(), "OpenTerrainGenerator"));
        this.biomeRegistryManager = new ForgeBiomeRegistryManager();
    }

    public WorldLoader getWorldLoader() {
        return this.worldLoader;
    }

    public ForgeBiomeRegistryManager getBiomeRegistryManager() {
        return this.biomeRegistryManager;
    }

    public void onSave(World world) {
        ForgeWorld forgeWorld = this.worldLoader.getWorld(world);
        if (forgeWorld != null && forgeWorld.getObjectSpawner().saveRequired && !forgeWorld.getWorldSession().getPreGeneratorIsRunning()) {
            forgeWorld.getStructureCache().saveToDisk();
        }
    }

    public void processPregeneratorTick() {
        for (LocalWorld world : this.getAllWorlds()) {
            if (!world.getWorldSession().getPreGeneratorIsInitialised()) continue;
            ((ForgeWorldSession)world.getWorldSession()).getPregenerator().processTick();
        }
        if (System.currentTimeMillis() - this.lastPregeneratorStatusUpdateTime > 1000L) {
            this.lastPregeneratorStatusUpdateTime = System.currentTimeMillis();
            ServerPacketManager.sendPregeneratorStatusPacketToAllPlayers(FMLCommonHandler.instance().getMinecraftServerInstance());
        }
    }

    @Override
    public File getOTGRootFolder() {
        return this.worldLoader.getConfigsFolder();
    }

    @Override
    public File getGlobalObjectsDirectory() {
        return new File(this.getOTGRootFolder(), "GlobalObjects");
    }

    @Override
    public File getWorldsDirectory() {
        return new File(this.getOTGRootFolder(), "worlds");
    }

    @Override
    public LocalWorld getWorld(String name) {
        return this.worldLoader.getWorld(name);
    }

    @Override
    public LocalWorld getUnloadedWorld(String name) {
        return this.worldLoader.getUnloadedWorld(name);
    }

    public ArrayList<ForgeWorld> getUnloadedWorlds() {
        return this.worldLoader.getUnloadedWorlds();
    }

    @Override
    public ArrayList<LocalWorld> getAllWorlds() {
        return this.worldLoader.getAllWorlds();
    }

    public ForgeWorld getOverWorld() {
        return this.worldLoader.getOverWorld();
    }

    public ForgeWorld getWorld(World world) {
        return this.worldLoader.getWorld(world);
    }

    public ForgeWorld getWorldByDimId(int dimensionId) {
        return this.worldLoader.getWorldByDimId(dimensionId);
    }

    public ForgeWorld getUnloadedWorldByDimId(int dimensionId) {
        return this.worldLoader.getUnloadedWorldByDimId(dimensionId);
    }

    @Override
    public String getPresetName(String worldName) {
        if (worldName.equals("overworld") || worldName.equals(OTG.getDimensionsConfig().WorldName)) {
            return OTG.getDimensionsConfig().Overworld.PresetName;
        }
        return worldName;
    }

    @Override
    public LocalMaterialData readMaterial(String input) throws InvalidConfigException {
        return ForgeMaterialData.ofString(input);
    }

    @Override
    public LocalMaterialData toLocalMaterialData(DefaultMaterial defaultMaterial, int blockData) {
        return ForgeMaterialData.ofDefaultMaterial(defaultMaterial, blockData);
    }

    @Override
    public boolean fireReplaceBiomeBlocksEvent(int x, int z, ChunkBuffer chunkBuffer, LocalWorld localWorld) {
        return ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)((ForgeWorld)localWorld).getChunkGenerator(), (int)x, (int)z, (ChunkPrimer)((ForgeChunkBuffer)chunkBuffer).getChunkPrimer(), (World)((ForgeWorld)localWorld).getWorld());
    }

    @Override
    public boolean isModLoaded(String mod) {
        return Loader.isModLoaded((String)mod);
    }

    @Override
    public boolean areEnoughBiomeIdsAvailableForPresets(ArrayList<String> presetNames) {
        if (ForgeBiomeRegistryManager.JEID) {
            return true;
        }
        if (presetNames == null) {
            return true;
        }
        int requiredBiomesCount = 0;
        for (String presetName : presetNames) {
            File settingsDir = new File(OTG.getEngine().getWorldsDirectory() + File.separator + presetName);
            requiredBiomesCount += this.getBiomeIdsRequiredCount(settingsDir);
        }
        return requiredBiomesCount <= this.getBiomeRegistryManager().getAvailableBiomeIdsCount();
    }

    public int getBiomeIdsRequiredCount(File settingsDir) {
        WorldConfig worldConfig = WorldConfig.fromDisk(settingsDir);
        ArrayList<File> biomeDirs = new ArrayList<File>(2);
        biomeDirs.add(new File(settingsDir, OTG.correctOldBiomeConfigFolder(settingsDir)));
        biomeDirs.add(new File(OTG.getEngine().getOTGRootFolder(), "GlobalBiomes"));
        HashSet<BiomeLoadInstruction> biomesToLoad = new HashSet<BiomeLoadInstruction>();
        BiomeConfigFinder biomeConfigFinder = new BiomeConfigFinder(OTG.getPluginConfig().biomeConfigExtension);
        Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs = biomeConfigFinder.findBiomes(worldConfig, worldConfig.worldHeightScale, biomeDirs, biomesToLoad);
        Map<String, BiomeConfig> loadedBiomes = ServerConfigProvider.readAndWriteSettings(worldConfig, biomeConfigStubs, false);
        int customBiomeIdsRequired = 0;
        for (BiomeConfig biomeConfig : loadedBiomes.values()) {
            if (biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.trim().length() != 0) continue;
            ++customBiomeIdsRequired;
        }
        return customBiomeIdsRequired;
    }

    @Override
    public Collection<BiomeLoadInstruction> getDefaultBiomes() {
        return ForgeBiomeRegistryManager.getDefaultBiomes();
    }

    @Override
    public void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub biomeConfigStub, String biomeResourceLocation) {
        ForgeBiomeRegistryManager.mergeVanillaBiomeMobSpawnSettings(biomeConfigStub, biomeResourceLocation);
    }
}

