/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bofunctions;

import com.pg85.otg.configuration.customobjects.CustomObjectConfigFile;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFunction;
import com.pg85.otg.exception.InvalidConfigException;
import java.util.List;

public abstract class ModDataFunction<T extends CustomObjectConfigFile>
extends CustomObjectConfigFunction<T> {
    public int y;
    public String modId;
    public String modData;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.modId = args.get(3);
        this.modData = args.get(4);
    }

    @Override
    public String makeString() {
        return "ModData(" + this.x + ',' + this.y + ',' + this.z + ',' + this.modId + ',' + this.modData + ')';
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<T> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ModDataFunction block = (ModDataFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z && block.modId.equalsIgnoreCase(this.modId) && block.modData.equalsIgnoreCase(this.modData);
    }

    public abstract ModDataFunction<T> getNewInstance();
}

