/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3.bo3function;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.bo3.bo3function.BO3BranchFunction;
import com.pg85.otg.customobjects.bofunctions.BranchNode;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructureCoordinate;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.bo3.Rotation;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class BO3WeightedBranchFunction
extends BO3BranchFunction {
    private double cumulativeChance = 0.0;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.branches = new TreeSet();
        this.cumulativeChance = this.readArgs(args, true);
    }

    @Override
    public CustomStructureCoordinate toCustomObjectCoordinate(LocalWorld world, Random random, Rotation rotation, int x, int y, int z, String startBO3Name) {
        double randomChance = random.nextDouble() * (this.totalChanceSet ? this.totalChance : (this.cumulativeChance >= 100.0 ? this.cumulativeChance : 100.0));
        for (BranchNode branch : this.branches) {
            if (!(branch.getChance() >= randomChance)) continue;
            return new BO3CustomStructureCoordinate(world, branch.getCustomObject(false, world), branch.customObjectName, branch.getRotation(), x + this.x, (short)(y + this.y), z + this.z);
        }
        return null;
    }

    @Override
    protected String getConfigName() {
        return "WeightedBranch";
    }
}

