/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.standard;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.configuration.biome.settings.ReplaceBlocks;
import com.pg85.otg.configuration.settingType.MaterialListSetting;
import com.pg85.otg.configuration.settingType.MaterialSetting;
import com.pg85.otg.configuration.settingType.Setting;
import com.pg85.otg.configuration.settingType.Settings;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WorldStandardValues
extends Settings {
    public static final String WORLD_CONFIG_FILE_NAME = "WorldConfig.ini";
    public static final String FALLBACK_FILE_NAME = "Fallbacks.ini";
    public static final String WORLD_BIOMES_DIRECTORY_NAME = "WorldBiomes";
    public static final String WORLD_OBJECTS_DIRECTORY_NAME = "WorldObjects";
    public static String BackupFileSuffix = "-backup";
    public static String StructureDataFileExtension = ".dat";
    public static String DimensionsConfigFileName = "Config.yaml";
    public static String DimensionsConfigBackupFileName = "Config" + BackupFileSuffix + ".yaml";
    public static String BiomeIdDataFileName = "BiomeIds.txt";
    public static String BiomeIdDataBackupFileName = "BiomeIds" + BackupFileSuffix + ".txt";
    public static String DimensionsDataFileName = "Dimensions.txt";
    public static String DimensionsDataBackupFileName = "Dimensions" + BackupFileSuffix + ".txt";
    public static String StructureDataFolderName = "StructureData";
    public static String StructureDataBackupFileExtension = BackupFileSuffix + StructureDataFileExtension;
    public static String PlottedChunksDataFolderName = StructureDataFolderName + File.separator + "PlottedChunks";
    public static String SpawnedStructuresFileName = StructureDataFolderName + File.separator + "SpawnedStructures" + StructureDataFileExtension;
    public static String SpawnedStructuresBackupFileName = StructureDataFolderName + File.separator + "SpawnedStructures" + StructureDataBackupFileExtension;
    public static String PregeneratedChunksFileName = "PregeneratedChunks.txt";
    public static String PregeneratedChunksBackupFileName = "PregeneratedChunks" + BackupFileSuffix + ".txt";
    public static String WorldSaveDataFileName = "WorldSave.txt";
    public static String WorldSaveDataBackupFileName = "WorldSave" + BackupFileSuffix + ".txt";
    public static final float SNOW_AND_ICE_TEMP = 0.15f;
    public static final float SNOW_AND_ICE_MAX_TEMP = -0.115f;
    public static final float ICE_GROUP_MAX_TEMP = 0.33f;
    public static final Setting<WorldConfig.ConfigMode> SETTINGS_MODE = WorldStandardValues.enumSetting("SettingsMode", WorldConfig.ConfigMode.WriteAll);
    public static final Setting<WorldConfig.ConfigMode> SETTINGS_MODE_BO3 = WorldStandardValues.enumSetting("SettingsMode", WorldConfig.ConfigMode.WriteDisable);
    public static final Setting<WorldConfig.TerrainMode> TERRAIN_MODE = WorldStandardValues.enumSetting("TerrainMode", WorldConfig.TerrainMode.Normal);
    public static final Setting<WorldConfig.ImageMode> IMAGE_MODE = WorldStandardValues.enumSetting("ImageMode", WorldConfig.ImageMode.Mirror);
    public static final Setting<WorldConfig.ImageOrientation> IMAGE_ORIENTATION = WorldStandardValues.enumSetting("ImageOrientation", WorldConfig.ImageOrientation.West);
    public static final Setting<String> BIOME_MODE = WorldStandardValues.stringSetting("BiomeMode", "Normal");
    public static final Setting<String> IMAGE_FILE = WorldStandardValues.stringSetting("ImageFile", "map.png");
    public static final Setting<String> IMAGE_FILL_BIOME = WorldStandardValues.stringSetting("ImageFillBiome", "Ocean");
    public static final Setting<String> AUTHOR = WorldStandardValues.stringSetting("Author", "Unknown");
    public static final Setting<String> DESCRIPTION = WorldStandardValues.stringSetting("Description", "No description given");
    public static final Setting<String> WORLDPACKER_MODNAME = WorldStandardValues.stringSetting("WorldPackerModName", "");
    public static final Setting<String> WORLD_SEED = WorldStandardValues.stringSetting("WorldSeed", "");
    public static final Setting<String> BO3_AT_SPAWN = WorldStandardValues.stringSetting("BO3AtSpawn", "");
    public static final Setting<String> DIMENSIONBELOW = WorldStandardValues.stringSetting("DimensionBelow", "");
    public static final Setting<String> DIMENSIONABOVE = WorldStandardValues.stringSetting("DimensionAbove", "");
    public static final Setting<String> WelcomeMessage = WorldStandardValues.stringSetting("WelcomeMessage", "");
    public static final Setting<String> DepartMessage = WorldStandardValues.stringSetting("DepartMessage", "");
    public static final Setting<String> ITEMS_TO_ADD_ON_JOIN_DIMENSION = WorldStandardValues.stringSetting("ItemsToAddOnJoinDimension", "");
    public static final Setting<String> ITEMS_TO_REMOVE_ON_JOIN_DIMENSION = WorldStandardValues.stringSetting("ItemsToRemoveOnJoinDimension", "");
    public static final Setting<String> ITEMS_TO_ADD_ON_LEAVE_DIMENSION = WorldStandardValues.stringSetting("ItemsToAddOnLeaveDimension", "");
    public static final Setting<String> ITEMS_TO_REMOVE_ON_LEAVE_DIMENSION = WorldStandardValues.stringSetting("ItemsToRemoveOnLeaveDimension", "");
    public static final Setting<String> ITEMS_TO_ADD_ON_RESPAWN = WorldStandardValues.stringSetting("ItemsToAddOnRespawn", "");
    public static final Setting<String> DEFAULT_OCEAN_BIOME = WorldStandardValues.stringSetting("DefaultOceanBiome", "Ocean");
    public static final Setting<String> DEFAULT_FROZEN_OCEAN_BIOME = WorldStandardValues.stringSetting("DefaultFrozenOceanBiome", "FrozenOcean");
    public static final Setting<String> PORTAL_COLOR = WorldStandardValues.stringSetting("PortalColor", "default");
    public static final Setting<String> PORTAL_PARTICLE_TYPE = WorldStandardValues.stringSetting("PortalParticleType", "portal");
    public static final Setting<String> PORTAL_MOB_TYPE = WorldStandardValues.stringSetting("PortalMobType", "zombie_pigman");
    public static final Setting<Integer> WORLD_HEIGHT_SCALE_BITS = WorldStandardValues.intSetting("WorldHeightScaleBits", 7, 5, 8);
    public static final Setting<Integer> WORLD_HEIGHT_CAP_BITS = WorldStandardValues.intSetting("WorldHeightCapBits", 8, 5, 8);
    public static final Setting<Integer> GENERATION_DEPTH = WorldStandardValues.intSetting("GenerationDepth", 10, 1, 20);
    public static final Setting<Integer> BIOME_RARITY_SCALE = WorldStandardValues.intSetting("BiomeRarityScale", 100, 1, Integer.MAX_VALUE);
    public static final Setting<Integer> LAND_RARITY = WorldStandardValues.intSetting("LandRarity", 99, 1, 100);
    public static final Setting<Integer> LAND_SIZE = WorldStandardValues.intSetting("LandSize", 0, 0, 20);
    public static final Setting<Integer> LAND_FUZZY = WorldStandardValues.intSetting("LandFuzzy", 5, 0, 20);
    public static final Setting<Integer> ICE_RARITY = WorldStandardValues.intSetting("IceRarity", 90, 1, 100);
    public static final Setting<Integer> ICE_SIZE = WorldStandardValues.intSetting("IceSize", 3, 0, 20);
    public static final Setting<Integer> RIVER_RARITY = WorldStandardValues.intSetting("RiverRarity", 4, 0, 20);
    public static final Setting<Integer> RIVER_SIZE = WorldStandardValues.intSetting("RiverSize", 0, 0, 20);
    public static final Setting<Integer> WATER_LEVEL_MAX = WorldStandardValues.intSetting("WaterLevelMax", 63, 0, 255);
    public static final Setting<Integer> WATER_LEVEL_MIN = WorldStandardValues.intSetting("WaterLevelMin", 0, 0, 255);
    public static final Setting<Integer> IMAGE_X_OFFSET = WorldStandardValues.intSetting("ImageXOffset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final Setting<Integer> IMAGE_Z_OFFSET = WorldStandardValues.intSetting("ImageZOffset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final Setting<Integer> CAVE_RARITY = WorldStandardValues.intSetting("CaveRarity", 7, 0, 100);
    public static final Setting<Integer> CAVE_FREQUENCY = WorldStandardValues.intSetting("CaveFrequency", 40, 0, 200);
    public static final Setting<Integer> CAVE_MIN_ALTITUDE = WorldStandardValues.intSetting("CaveMinAltitude", 8, 0, 255);
    public static final Setting<Integer> CAVE_MAX_ALTITUDE = WorldStandardValues.intSetting("CaveMaxAltitude", 127, 0, 255);
    public static final Setting<Integer> INDIVIDUAL_CAVE_RARITY = WorldStandardValues.intSetting("IndividualCaveRarity", 25, 0, 100);
    public static final Setting<Integer> CAVE_SYSTEM_FREQUENCY = WorldStandardValues.intSetting("CaveSystemFrequency", 1, 0, 200);
    public static final Setting<Integer> CAVE_SYSTEM_POCKET_CHANCE = WorldStandardValues.intSetting("CaveSystemPocketChance", 0, 0, 100);
    public static final Setting<Integer> CAVE_SYSTEM_POCKET_MIN_SIZE = WorldStandardValues.intSetting("CaveSystemPocketMinSize", 0, 0, 100);
    public static final Setting<Integer> CAVE_SYSTEM_POCKET_MAX_SIZE = WorldStandardValues.intSetting("CaveSystemPocketMaxSize", 3, 0, 100);
    public static final Setting<Integer> RAVINE_RARITY = WorldStandardValues.intSetting("RavineRarity", 2, 0, 100);
    public static final Setting<Integer> RAVINE_MIN_ALTITUDE = WorldStandardValues.intSetting("RavineMinAltitude", 20, 0, 255);
    public static final Setting<Integer> RAVINE_MAX_ALTITUDE = WorldStandardValues.intSetting("RavineMaxAltitude", 67, 0, 255);
    public static final Setting<Integer> RAVINE_MIN_LENGTH = WorldStandardValues.intSetting("RavineMinLength", 84, 1, 500);
    public static final Setting<Integer> RAVINE_MAX_LENGTH = WorldStandardValues.intSetting("RavineMaxLength", 111, 1, 500);
    public static final Setting<Integer> OBJECT_SPAWN_RATIO = WorldStandardValues.intSetting("ObjectSpawnRatio", 1, 1, 1000);
    public static final Setting<Integer> STRONGHOLD_COUNT = WorldStandardValues.intSetting("StrongholdCount", 128, 0, 1000);
    public static final Setting<Integer> STRONGHOLD_SPREAD = WorldStandardValues.intSetting("StrongholdSpread", 3, 1, 1000);
    public static final Setting<Integer> VILLAGE_DISTANCE = WorldStandardValues.intSetting("VillageDistance", 32, 9, 10000);
    public static final Setting<Integer> VILLAGE_SIZE = WorldStandardValues.intSetting("VillageSize", 0, 0, 10);
    public static final Setting<Integer> MINIMUM_DISTANCE_BETWEEN_RARE_BUILDINGS = WorldStandardValues.intSetting("MinimumDistanceBetweenRareBuildings", 9, 1, 10000);
    public static final Setting<Integer> MAXIMUM_DISTANCE_BETWEEN_RARE_BUILDINGS = WorldStandardValues.intSetting("MaximumDistanceBetweenRareBuildings", 32, 1, 10000);
    public static final Setting<Integer> OCEAN_MONUMENT_GRID_SIZE = WorldStandardValues.intSetting("OceanMonumentGridSize", 32, 5, 10000);
    public static final Setting<Integer> OCEAN_MONUMENT_RANDOM_OFFSET = WorldStandardValues.intSetting("OceanMonumentRandomOffset", 26, 0, 10000);
    public static final Setting<Integer> MAXIMUM_CUSTOM_STRUCTURE_RADIUS = WorldStandardValues.intSetting("MaximumCustomStructureRadius", 5, 1, 100);
    public static final Setting<Integer> PREGENERATION_RADIUS = WorldStandardValues.intSetting("PreGenerationRadius", 0, 0, 999999);
    public static final Setting<Integer> WORLD_BORDER_RADIUS = WorldStandardValues.intSetting("WorldBorderRadius", 0, 0, 999999);
    public static final Setting<Integer> MaxCommandChainLength = WorldStandardValues.intSetting("MaxCommandChainLength", 65536, 0, 999999);
    public static final Setting<Integer> MaxEntityCramming = WorldStandardValues.intSetting("MaxEntityCramming", 24, 0, 999999);
    public static final Setting<Integer> RandomTickSpeed = WorldStandardValues.intSetting("RandomTickSpeed", 3, 0, 999999);
    public static final Setting<Integer> SpawnRadius = WorldStandardValues.intSetting("SpawnRadius", 10, 0, 999999);
    public static final Setting<Integer> CloudHeight = WorldStandardValues.intSetting("CloudHeight", 128, 0, 999999);
    public static final Setting<Integer> DIMENSIONBELOWHEIGHT = WorldStandardValues.intSetting("DimensionBelowHeight", 0, -999999, 999999);
    public static final Setting<Integer> DIMENSIONABOVEHEIGHT = WorldStandardValues.intSetting("DimensionAboveHeight", 256, -999999, 999999);
    public static final Setting<Integer> RESPAWN_DIMENSION = WorldStandardValues.intSetting("RespawnDimension", 0, -999999, 999999);
    public static final Setting<Integer> MOVEMENT_FACTOR = WorldStandardValues.intSetting("MovementFactor", 1, 1, 999999);
    public static final Setting<Integer> SPAWN_POINT_X = WorldStandardValues.intSetting("SpawnPointX", 0, -999999, 999999);
    public static final Setting<Integer> SPAWN_POINT_Y = WorldStandardValues.intSetting("SpawnPointY", 0, -999999, 999999);
    public static final Setting<Integer> SPAWN_POINT_Z = WorldStandardValues.intSetting("SpawnPointZ", 0, -999999, 999999);
    public static final Setting<Integer> PORTAL_MOB_SPAWN_CHANCE = WorldStandardValues.intSetting("PortalMobSpawnChance", 2000, 0, 999999);
    public static final Setting<Boolean> RIVERS_ENABLED = WorldStandardValues.booleanSetting("RiversEnabled", true);
    public static final Setting<Boolean> GROUP_FREEZE_ENABLED = WorldStandardValues.booleanSetting("FreezeAllBiomesInColdGroup", false);
    public static final Setting<Boolean> RANDOM_RIVERS = WorldStandardValues.booleanSetting("RandomRivers", false);
    public static final Setting<Boolean> IMPROVED_RIVERS = WorldStandardValues.booleanSetting("ImprovedRivers", false);
    public static final Setting<Boolean> FROZEN_OCEAN = WorldStandardValues.booleanSetting("FrozenOcean", true);
    public static final Setting<Boolean> BETTER_SNOW_FALL = WorldStandardValues.booleanSetting("BetterSnowFall", false);
    public static final Setting<Boolean> FULLY_FREEZE_LAKES = WorldStandardValues.booleanSetting("FullyFreezeLakes", false);
    public static final Setting<Boolean> EVEN_CAVE_DISTRIBUTION = WorldStandardValues.booleanSetting("EvenCaveDistrubution", false);
    public static final Setting<Boolean> DISABLE_BEDROCK = WorldStandardValues.booleanSetting("DisableBedrock", false);
    public static final Setting<Boolean> CEILING_BEDROCK = WorldStandardValues.booleanSetting("CeilingBedrock", false);
    public static final Setting<Boolean> FLAT_BEDROCK = WorldStandardValues.booleanSetting("FlatBedrock", false);
    public static final Setting<Boolean> REMOVE_SURFACE_STONE = WorldStandardValues.booleanSetting("RemoveSurfaceStone", false);
    public static final Setting<Boolean> POPULATION_BOUNDS_CHECK = WorldStandardValues.booleanSetting("PopulationBoundsCheck", true);
    public static final Setting<Boolean> NETHER_FORTRESSES_ENABLED = WorldStandardValues.booleanSetting("NetherFortressesEnabled", false);
    public static final Setting<Boolean> STRONGHOLDS_ENABLED = WorldStandardValues.booleanSetting("StrongholdsEnabled", true);
    public static final Setting<Boolean> VILLAGES_ENABLED = WorldStandardValues.booleanSetting("VillagesEnabled", true);
    public static final Setting<Boolean> MINESHAFTS_ENABLED = WorldStandardValues.booleanSetting("MineshaftsEnabled", true);
    public static final Setting<Boolean> RARE_BUILDINGS_ENABLED = WorldStandardValues.booleanSetting("RareBuildingsEnabled", true);
    public static final Setting<Boolean> OCEAN_MONUMENTS_ENABLED = WorldStandardValues.booleanSetting("OceanMonumentsEnabled", true);
    public static final Setting<Boolean> WOODLAND_MANSIONS_ENABLED = WorldStandardValues.booleanSetting("WoodLandMansionsEnabled", true);
    public static final Setting<Boolean> POPULATE_USING_SAVED_BIOMES = WorldStandardValues.booleanSetting("PopulateUsingSavedBiomes", false);
    public static final Setting<Boolean> DISABLE_OREGEN = WorldStandardValues.booleanSetting("DisableOreGen", false);
    public static final Setting<Boolean> IMPROVED_BIOME_BORDERS = WorldStandardValues.booleanSetting("ImprovedBiomeBorders", false);
    public static final Setting<Boolean> IMPROVED_BIOME_GROUPS = WorldStandardValues.booleanSetting("ImprovedBiomeGroups", false);
    public static final Setting<Boolean> CUSTOM_HEIGHT_CONTROL_SMOOTHING = WorldStandardValues.booleanSetting("CustomHeightControlSmoothing", false);
    public static final Setting<Boolean> IMPROVED_SMOOTHING = WorldStandardValues.booleanSetting("ImprovedSmoothing", false);
    public static final Setting<Boolean> TeleportToSpawnOnly = WorldStandardValues.booleanSetting("TeleportToSpawnOnly", false);
    public static final Setting<Boolean> CommandBlockOutput = WorldStandardValues.booleanSetting("CommandBlockOutput", true);
    public static final Setting<Boolean> DisableElytraMovementCheck = WorldStandardValues.booleanSetting("DisableElytraMovementCheck", false);
    public static final Setting<Boolean> DoDaylightCycle = WorldStandardValues.booleanSetting("DoDaylightCycle", true);
    public static final Setting<Boolean> DoEntityDrops = WorldStandardValues.booleanSetting("DoEntityDrops", true);
    public static final Setting<Boolean> DoFireTick = WorldStandardValues.booleanSetting("DoFireTick", true);
    public static final Setting<Boolean> DoLimitedCrafting = WorldStandardValues.booleanSetting("DoLimitedCrafting", false);
    public static final Setting<Boolean> DoMobLoot = WorldStandardValues.booleanSetting("DoMobLoot", true);
    public static final Setting<Boolean> DoMobSpawning = WorldStandardValues.booleanSetting("DoMobSpawning", true);
    public static final Setting<Boolean> DoTileDrops = WorldStandardValues.booleanSetting("DoTileDrops", true);
    public static final Setting<Boolean> DoWeatherCycle = WorldStandardValues.booleanSetting("DoWeatherCycle", true);
    public static final Setting<Boolean> GameLoopFunction = WorldStandardValues.booleanSetting("GameLoopFunction", true);
    public static final Setting<Boolean> KeepInventory = WorldStandardValues.booleanSetting("KeepInventory", false);
    public static final Setting<Boolean> LogAdminCommands = WorldStandardValues.booleanSetting("LogAdminCommands", true);
    public static final Setting<Boolean> MobGriefing = WorldStandardValues.booleanSetting("MobGriefing", true);
    public static final Setting<Boolean> NaturalRegeneration = WorldStandardValues.booleanSetting("NaturalRegeneration", true);
    public static final Setting<Boolean> ReducedDebugInfo = WorldStandardValues.booleanSetting("ReducedDebugInfo", false);
    public static final Setting<Boolean> SendCommandFeedback = WorldStandardValues.booleanSetting("SendCommandFeedback", true);
    public static final Setting<Boolean> ShowDeathMessages = WorldStandardValues.booleanSetting("ShowDeathMessages", true);
    public static final Setting<Boolean> SpectatorsGenerateChunks = WorldStandardValues.booleanSetting("SpectatorsGenerateChunks", true);
    public static final Setting<Boolean> HasSkyLight = WorldStandardValues.booleanSetting("HasSkyLight", true);
    public static final Setting<Boolean> IsSurfaceWorld = WorldStandardValues.booleanSetting("IsSurfaceWorld", true);
    public static final Setting<Boolean> CanRespawnHere = WorldStandardValues.booleanSetting("CanRespawnHere", true);
    public static final Setting<Boolean> DoesWaterVaporize = WorldStandardValues.booleanSetting("DoesWaterVaporize", false);
    public static final Setting<Boolean> DoesXZShowFog = WorldStandardValues.booleanSetting("DoesXZShowFog", false);
    public static final Setting<Boolean> IsSkyColored = WorldStandardValues.booleanSetting("IsSkyColored", true);
    public static final Setting<Boolean> CanDoLightning = WorldStandardValues.booleanSetting("CanDoLightning", true);
    public static final Setting<Boolean> CanDoRainSnowIce = WorldStandardValues.booleanSetting("CanDoRainSnowIce", true);
    public static final Setting<Boolean> IsNightWorld = WorldStandardValues.booleanSetting("IsNightWorld", false);
    public static final Setting<Boolean> ShouldMapSpin = WorldStandardValues.booleanSetting("ShouldMapSpin", false);
    public static final Setting<Boolean> CanDropChunk = WorldStandardValues.booleanSetting("CanDropChunk", true);
    public static final Setting<Boolean> UseCustomFogColor = WorldStandardValues.booleanSetting("UseCustomFogColor", false);
    public static final Setting<Boolean> IS_OTG_PLUS = WorldStandardValues.booleanSetting("IsOTGPlus", false);
    public static final Setting<Boolean> SPAWN_POINT_SET = WorldStandardValues.booleanSetting("SpawnPointSet", false);
    public static final Setting<Boolean> PLAYERS_CAN_BREAK_BLOCKS = WorldStandardValues.booleanSetting("PlayersCanBreakBlocks", true);
    public static final Setting<Boolean> EXPLOSIONS_CAN_BREAK_BLOCKS = WorldStandardValues.booleanSetting("ExplosionsCanBreakBlocks", true);
    public static final Setting<Boolean> PLAYERS_CAN_PLACE_BLOCKS = WorldStandardValues.booleanSetting("PlayersCanPlaceBlocks", true);
    public static final Setting<LocalMaterialData> WATER_BLOCK = new MaterialSetting("WaterBlock", DefaultMaterial.STATIONARY_WATER);
    public static final Setting<LocalMaterialData> ICE_BLOCK = new MaterialSetting("IceBlock", DefaultMaterial.ICE);
    public static final Setting<LocalMaterialData> COOLED_LAVA_BLOCK = new MaterialSetting("CooledLavaBlock", DefaultMaterial.STATIONARY_LAVA);
    public static final Setting<LocalMaterialData> BEDROCK_BLOCK = new MaterialSetting("BedrockobBlock", DefaultMaterial.BEDROCK);
    public static final Setting<ArrayList<LocalMaterialData>> DIMENSION_PORTAL_MATERIALS = new MaterialListSetting("DimensionPortalMaterials", new DefaultMaterial[]{DefaultMaterial.QUARTZ_BLOCK});
    public static final Setting<List<ReplaceBlocks>> REPLACE_BLOCKS_LIST = WorldStandardValues.replaceBlocksListSetting("ReplaceBlocksList");
    public static final Setting<List<String>> ISLE_BIOMES = WorldStandardValues.stringListSetting("IsleBiomes", "Deep Ocean", "MushroomIsland", "Ice Mountains", "DesertHills", "ForestHills", "Forest", "TaigaHills", "JungleHills", "Cold Taiga Hills", "Birch Forest Hills", "Extreme Hills+", "Mesa Plateau", "Mesa Plateau F", "Mesa Plateau M", "Mesa Plateau F M", "Mesa (Bryce)", "Mega Taiga Hills", "Mega Spruce Taiga Hills");
    public static final Setting<List<String>> BORDER_BIOMES = WorldStandardValues.stringListSetting("BorderBiomes", "JungleEdge", "JungleEdge M", "MushroomIslandShore", "Beach", "Extreme Hills Edge", "Desert", "Taiga");
    public static final Setting<List<String>> CUSTOM_BIOMES = WorldStandardValues.stringListSetting("CustomBiomes", new String[0]);
    public static final Setting<List<String>> DIMENSIONS = WorldStandardValues.stringListSetting("Dimensions", new String[0]);
    public static final Setting<Double> FROZEN_OCEAN_TEMPERATURE = WorldStandardValues.doubleSetting("OceanFreezingTemperature", 0.15, 0.0, 2.0);
    public static final Setting<Double> RAVINE_DEPTH = WorldStandardValues.doubleSetting("RavineDepth", 3.0, 0.1, 15.0);
    public static final Setting<Double> CANYON_DEPTH = WorldStandardValues.doubleSetting("CanyonDepth", 3.0, 0.1, 15.0);
    public static final Setting<Double> FRACTURE_HORIZONTAL = WorldStandardValues.doubleSetting("FractureHorizontal", 0.0, -500.0, 500.0);
    public static final Setting<Double> FRACTURE_VERTICAL = WorldStandardValues.doubleSetting("FractureVertical", 0.0, -500.0, 500.0);
    public static final Setting<Double> STRONGHOLD_DISTANCE = WorldStandardValues.doubleSetting("StrongholdDistance", 32.0, 1.0, 1000.0);
    public static final Setting<Double> FogColorRed = WorldStandardValues.doubleSetting("FogColorRed", 0.2f, Double.MIN_VALUE, Double.MAX_VALUE);
    public static final Setting<Double> FogColorGreen = WorldStandardValues.doubleSetting("FogColorGreen", 0.03f, Double.MIN_VALUE, Double.MAX_VALUE);
    public static final Setting<Double> FogColorBlue = WorldStandardValues.doubleSetting("FogColorBlue", 0.03f, Double.MIN_VALUE, Double.MAX_VALUE);
    public static final Setting<Double> VoidFogYFactor = WorldStandardValues.doubleSetting("VoidFogYFactor", 0.03125, Double.MIN_VALUE, Double.MAX_VALUE);
    public static final Setting<Double> GravityFactor = WorldStandardValues.doubleSetting("GravityFactor", 0.08, 0.0, Double.MAX_VALUE);
    public static final Setting<Integer> WORLD_FOG = WorldStandardValues.colorSetting("WorldFog", "0xC0D8FF");
    public static final Setting<Integer> WORLD_NIGHT_FOG = WorldStandardValues.colorSetting("WorldNightFog", "0x0B0D17");
    public static final Setting<Long> RESOURCES_SEED = WorldStandardValues.longSetting("ResourcesSeed", 0L, Long.MIN_VALUE, Long.MAX_VALUE);
    public static final Setting<Boolean> FROZEN_RIVERS = WorldStandardValues.booleanSetting("FrozenRivers", true);
    public static final Setting<List<String>> NORMAL_BIOMES = WorldStandardValues.stringListSetting("NormalBiomes", "Desert", "Forest", "Extreme Hills", "Swampland", "Plains", "Taiga", "Jungle", "River");
    public static final Setting<List<String>> ICE_BIOMES = WorldStandardValues.stringListSetting("IceBiomes", "Ice Plains");

    public static class BiomeGroupNames {
        public static final String NORMAL = "NormalBiomes";
        public static final String ICE = "IceBiomes";
        public static final String COLD = "ColdBiomes";
        public static final String HOT = "HotBiomes";
        public static final String MESA = "MesaBiomes";
        public static final String JUNGLE = "JungleBiomes";
        public static final String MEGA_TAIGA = "Mega TaigaBiomes";
    }
}

