/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.settingType;

import com.pg85.otg.configuration.settingType.Setting;
import com.pg85.otg.exception.InvalidConfigException;

class EnumSetting<T extends Enum<T>>
extends Setting<T> {
    private final T defaultValue;
    private final T[] enumValues;

    public EnumSetting(String name, T defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
        this.enumValues = (Enum[])((Enum)defaultValue).getDeclaringClass().getEnumConstants();
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public T read(String string) throws InvalidConfigException {
        for (T enumValue : this.enumValues) {
            if (!((Enum)enumValue).name().equalsIgnoreCase(string)) continue;
            return enumValue;
        }
        throw new InvalidConfigException(string + " is not an acceptable value");
    }
}

