/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.biome;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeGroup;
import com.pg85.otg.logging.LogMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class BiomeGroupManager {
    static final int MAX_BIOME_GROUP_COUNT = 127;
    private final Map<String, BiomeGroup> nameToGroup = new LinkedHashMap<String, BiomeGroup>(4);
    private final BiomeGroup[] idToGroup = new BiomeGroup[128];
    HashMap<Integer, TreeMap<Integer, BiomeGroup>> cachedGroupDepthMaps = new HashMap();

    public void registerGroup(BiomeGroup newGroup) {
        if (this.isRoomForMoreGroups()) {
            BiomeGroup existingWithSameName = this.nameToGroup.get(newGroup.getName());
            if (existingWithSameName != null) {
                OTG.log(LogMarker.WARN, "Two biome groups have the same name \"{}\". Removing the second one.", newGroup.getName());
                OTG.printStackTrace(LogMarker.WARN, new Exception());
            } else {
                int newGroupId = this.getNextGroupId();
                newGroup.setGroupId(newGroupId);
                this.nameToGroup.put(newGroup.getName(), newGroup);
                this.idToGroup[newGroupId] = newGroup;
            }
        } else {
            OTG.log(LogMarker.WARN, "Biome group \"{}\" could not be added. Max biome group count reached.", newGroup.getName());
        }
    }

    private int getNextGroupId() {
        return this.getGroupCount() + 1;
    }

    private boolean isRoomForMoreGroups() {
        return this.getNextGroupId() < 127;
    }

    public BiomeGroup getGroupById(int groupId) {
        return this.idToGroup[groupId];
    }

    public BiomeGroup getGroupByName(String name) {
        return this.nameToGroup.get(name);
    }

    public Collection<BiomeGroup> getGroups() {
        return this.nameToGroup.values();
    }

    public int getGroupCount() {
        return this.nameToGroup.size();
    }

    public SortedMap<Integer, BiomeGroup> getGroupDepthMap(int depth) {
        TreeMap<Integer, BiomeGroup> map = this.cachedGroupDepthMaps.get(depth);
        if (map != null) {
            return map;
        }
        map = new TreeMap();
        int cumulativeGroupRarity = 0;
        for (BiomeGroup group : this.getGroups()) {
            if (group.getGenerationDepth() != depth) continue;
            map.put(cumulativeGroupRarity += group.getGroupRarity(), group);
        }
        if (cumulativeGroupRarity < map.size() * 100) {
            map.put(map.size() * 100, null);
        }
        this.cachedGroupDepthMaps.put(depth, map);
        return map;
    }

    public boolean isGroupDepthMapEmpty(int depth) {
        for (BiomeGroup group : this.getGroups()) {
            if (group.getGenerationDepth() != depth) continue;
            return false;
        }
        return true;
    }

    public boolean isBiomeDepthMapEmpty(int depth) {
        for (BiomeGroup group : this.getGroups()) {
            if (group.getDepthMap(depth).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static int getMaxRarityFromPossibles(SortedMap<Integer, ?> sortedMap) {
        return sortedMap.lastKey();
    }

    public void processBiomeData(LocalWorld world) {
        for (BiomeGroup entry : this.nameToGroup.values()) {
            entry.processBiomeData(world);
        }
    }

    public void filterBiomes(ArrayList<String> customBiomeNames, boolean logWarnings) {
        Iterator<BiomeGroup> it = this.nameToGroup.values().iterator();
        while (it.hasNext()) {
            BiomeGroup group = it.next();
            group.filterBiomes(customBiomeNames, logWarnings);
            if (!group.hasNoBiomes()) continue;
            it.remove();
        }
    }
}

