/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.common;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.bo3.BO3;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.customobjects.bofunctions.ModDataFunction;
import com.pg85.otg.customobjects.bofunctions.ParticleFunction;
import com.pg85.otg.customobjects.bofunctions.SpawnerFunction;
import com.pg85.otg.customobjects.structures.CustomStructure;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructure;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class WorldSession {
    protected LocalWorld world;

    public WorldSession(LocalWorld world) {
        this.world = world;
    }

    public abstract ArrayList<ParticleFunction<?>> getParticleFunctions();

    public abstract int getPregenerationRadius();

    public abstract int setPregenerationRadius(int var1);

    public abstract ChunkCoordinate getPreGeneratorCenterPoint();

    public abstract void setPreGeneratorCenterPoint(ChunkCoordinate var1);

    public abstract int getPregeneratedBorderLeft();

    public abstract int getPregeneratedBorderRight();

    public abstract int getPregeneratedBorderTop();

    public abstract int getPregeneratedBorderBottom();

    public abstract boolean getPreGeneratorIsRunning();

    public String getStructureInfoAt(double x, double z) {
        String structureInfo = "";
        ChunkCoordinate playerChunk = ChunkCoordinate.fromBlockCoords((int)x, (int)z);
        CustomStructure worldInfoChunk = this.world.getStructureCache().getChunkData(playerChunk);
        if (worldInfoChunk != null) {
            if (worldInfoChunk instanceof BO4CustomStructure) {
                structureInfo = structureInfo + "-- BO4 Info -- \r\nName: " + ((BO4)worldInfoChunk.start.getObject()).getConfig().getName().replace("Start", "") + "\r\nAuthor: " + ((BO4)worldInfoChunk.start.getObject()).getConfig().author + "\r\nDescription: " + ((BO4)worldInfoChunk.start.getObject()).getConfig().description;
                String branchesInChunk = ((BO4CustomStructure)worldInfoChunk).ObjectsToSpawnInfo.get(playerChunk);
                if (branchesInChunk != null && branchesInChunk.length() > 0) {
                    structureInfo = structureInfo + "\r\n" + branchesInChunk;
                }
            } else {
                structureInfo = structureInfo + "-- BO3 Info -- \r\nName: " + ((BO3)worldInfoChunk.start.getObject()).getSettings().getName().replace("Start", "") + "\r\nAuthor: " + ((BO3)worldInfoChunk.start.getObject()).getSettings().author + "\r\nDescription: " + ((BO3)worldInfoChunk.start.getObject()).getSettings().description;
            }
        }
        return structureInfo;
    }

    public HashMap<String, ArrayList<ModDataFunction<?>>> getModDataForChunk(ChunkCoordinate chunkCoord) {
        HashMap result = new HashMap();
        CustomStructure worldInfoChunk = this.world.getStructureCache().getChunkData(chunkCoord);
        if (worldInfoChunk != null) {
            for (ModDataFunction<?> modData : worldInfoChunk.modDataManager.modData) {
                if (!ChunkCoordinate.fromBlockCoords(modData.x, modData.z).equals(chunkCoord)) continue;
                if (!result.containsKey(modData.modId)) {
                    result.put(modData.modId, new ArrayList());
                }
                result.get(modData.modId).add(modData);
            }
        }
        return result;
    }

    public ArrayList<SpawnerFunction<?>> getSpawnersForChunk(ChunkCoordinate chunkCoord) {
        ArrayList result = new ArrayList();
        CustomStructure worldInfoChunk = this.world.getStructureCache().getChunkData(chunkCoord);
        if (worldInfoChunk != null) {
            for (SpawnerFunction<?> spawnerData : worldInfoChunk.spawnerManager.spawnerData) {
                if (!ChunkCoordinate.fromBlockCoords(spawnerData.x, spawnerData.z).equals(chunkCoord)) continue;
                result.add(spawnerData);
            }
        }
        return result;
    }

    public ArrayList<ParticleFunction<?>> getParticlesForChunk(ChunkCoordinate chunkCoord) {
        ArrayList result = new ArrayList();
        CustomStructure worldInfoChunk = this.world.getStructureCache().getChunkData(chunkCoord);
        if (worldInfoChunk != null) {
            for (ParticleFunction<?> particleData : worldInfoChunk.particlesManager.particleData) {
                if (!ChunkCoordinate.fromBlockCoords(particleData.x, particleData.z).equals(chunkCoord)) continue;
                result.add(particleData);
            }
        }
        return result;
    }

    public void removeParticles(ChunkCoordinate chunkCoord, ParticleFunction<?> particle) {
        CustomStructure customObject = this.world.getStructureCache().getChunkData(chunkCoord);
        if (customObject != null && customObject.particlesManager.particleData.contains(particle)) {
            customObject.particlesManager.particleData.remove(particle);
        }
    }

    public boolean isInsidePregeneratedRegion(ChunkCoordinate chunk) {
        return (this.getPregeneratedBorderLeft() != 0 || this.getPregeneratedBorderRight() != 0 || this.getPregeneratedBorderTop() != 0 || this.getPregeneratedBorderBottom() != 0) && this.getPregenerationRadius() > 0 && chunk.getChunkX() > this.getPreGeneratorCenterPoint().getChunkX() - this.getPregeneratedBorderLeft() && chunk.getChunkX() <= this.getPreGeneratorCenterPoint().getChunkX() + this.getPregeneratedBorderRight() && chunk.getChunkZ() > this.getPreGeneratorCenterPoint().getChunkZ() - this.getPregeneratedBorderTop() && chunk.getChunkZ() <= this.getPreGeneratorCenterPoint().getChunkZ() + this.getPregeneratedBorderBottom();
    }

    public abstract boolean getPreGeneratorIsInitialised();
}

