/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.util;

import com.pg85.otg.OTG;
import com.pg85.otg.bukkit.materials.BukkitMaterialData;
import com.pg85.otg.bukkit.util.BOCreator;
import com.pg85.otg.bukkit.util.NBTHelper;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFunction;
import com.pg85.otg.configuration.io.FileSettingsReaderOTGPlus;
import com.pg85.otg.configuration.io.FileSettingsWriterOTGPlus;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.customobjects.bo4.BO4Config;
import com.pg85.otg.customobjects.bo4.bo4function.BO4BlockFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4BranchFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.materials.MaterialHelper;
import com.sk89q.worldedit.bukkit.selections.Selection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class BO4Creator
extends BOCreator {
    public BO4Creator(String name) {
        this.name = name;
    }

    @Override
    public boolean create(Selection selection, String blockName, boolean branch) {
        Block block;
        World world;
        int tileEntityCount = 1;
        File tileEntitiesFolder = new File(OTG.getEngine().getGlobalObjectsDirectory(), this.name);
        if (this.includeTiles || branch) {
            tileEntitiesFolder.mkdirs();
        }
        if ((world = selection.getWorld()) == null) {
            throw new NullPointerException("World was null for WorldEdit selection, could not process");
        }
        Location start = selection.getMinimumPoint();
        Location end = selection.getMaximumPoint();
        LocalMaterialData centerBlock = null;
        if (!blockName.isEmpty()) {
            try {
                centerBlock = MaterialHelper.readMaterial(blockName);
            }
            catch (InvalidConfigException e1) {
                OTG.log(LogMarker.WARN, "export command could not process center block argument: " + e1.getLocalizedMessage(), new Object[0]);
            }
        }
        int width = selection.getWidth();
        int length = selection.getLength();
        int height = selection.getHeight();
        boolean centerBlockFound = false;
        int centerPointX = 0;
        int centerPointY = 0;
        int centerPointZ = 0;
        ArrayList blocksInChunk = new ArrayList();
        if (centerBlock != null) {
            block4: for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < length; ++z) {
                        block = world.getBlockAt(x + start.getBlockX(), y + start.getBlockY(), z + start.getBlockZ());
                        BukkitMaterialData data = BukkitMaterialData.ofBukkitBlock(block);
                        if (!centerBlock.equals(data)) continue;
                        centerPointX = x + start.getBlockX();
                        centerPointY = y + start.getBlockY();
                        centerPointZ = z + start.getBlockZ();
                        centerBlockFound = true;
                        break block4;
                    }
                }
            }
        }
        if (centerBlock == null || !centerBlockFound) {
            centerPointX = start.getBlockX() + end.getBlockX() >> 1;
            centerPointY = start.getBlockY();
            int z = start.getBlockZ() + end.getBlockZ() >> 1;
            if (width == 16) {
                --z;
            }
            centerPointZ = z;
        }
        HashMap<ChunkCoordinate, ArrayList<BO4BlockFunction>> blocksPerChunkArr = new HashMap<ChunkCoordinate, ArrayList<BO4BlockFunction>>();
        for (int x = start.getBlockX(); x <= end.getBlockX(); ++x) {
            for (int y = start.getBlockY(); y <= end.getBlockY(); ++y) {
                for (int z = start.getBlockZ(); z <= end.getBlockZ(); ++z) {
                    NamedBinaryTag tag;
                    ChunkCoordinate chunkCoordinates = branch ? ChunkCoordinate.fromChunkCoords(x - start.getBlockX() >> 4, z - start.getBlockZ() >> 4) : ChunkCoordinate.fromChunkCoords(0, 0);
                    if (blocksPerChunkArr.containsKey(chunkCoordinates)) {
                        blocksInChunk = (ArrayList)blocksPerChunkArr.get(chunkCoordinates);
                    } else {
                        blocksInChunk = new ArrayList();
                        blocksPerChunkArr.put(chunkCoordinates, blocksInChunk);
                    }
                    block = world.getBlockAt(x, y, z);
                    BukkitMaterialData material = BukkitMaterialData.ofBukkitBlock(block);
                    if (!this.includeAir && ((LocalMaterialData)material).isAir()) continue;
                    BO4BlockFunction blockFunction = branch ? (BO4BlockFunction)CustomObjectConfigFunction.create(null, BO4BlockFunction.class, x - (chunkCoordinates.getChunkX() * 16 + start.getBlockX()) - 8, y - centerPointY, z - (chunkCoordinates.getChunkZ() * 16 + start.getBlockZ()) - 7, material) : (BO4BlockFunction)CustomObjectConfigFunction.create(null, BO4BlockFunction.class, x - centerPointX, y - centerPointY, z - centerPointZ, material);
                    if (this.includeTiles && (tag = NBTHelper.getMetadata(world, x, y, z)) != null) {
                        String tileEntityName = branch ? tileEntityCount + "-" + this.getTileEntityName(tag) + "C" + chunkCoordinates.getBlockX() + "R" + chunkCoordinates.getBlockZ() + ".nbt" : tileEntityCount + "-" + this.getTileEntityName(tag) + ".nbt";
                        File tileEntityFile = new File(tileEntitiesFolder, tileEntityName);
                        ++tileEntityCount;
                        try {
                            tileEntityFile.createNewFile();
                            FileOutputStream fos = new FileOutputStream(tileEntityFile);
                            tag.writeTo(fos);
                            fos.flush();
                            fos.close();
                            blockFunction.metaDataTag = tag;
                            blockFunction.metaDataName = this.name + "/" + tileEntityName;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    blocksInChunk.add(blockFunction);
                }
            }
        }
        ArrayList<BO4BranchFunction> masterBranches = new ArrayList<BO4BranchFunction>();
        if (branch) {
            boolean[][] exists = new boolean[width][length];
            boolean[][] processed = new boolean[width][length];
            for (ChunkCoordinate c : blocksPerChunkArr.keySet()) {
                exists[c.getChunkX()][c.getChunkZ()] = !((ArrayList)blocksPerChunkArr.get(c)).isEmpty();
            }
            for (int x1 = 0; x1 < width; ++x1) {
                for (int z1 = 0; z1 < length; ++z1) {
                    if (!exists[x1][z1] || processed[x1][z1]) continue;
                    masterBranches.add(this.recursiveHelper(exists, processed, blocksPerChunkArr, x1, z1, x1 * 16, z1 * 16, tileEntitiesFolder));
                }
            }
        }
        ArrayList blocks = !branch ? (ArrayList)blocksPerChunkArr.get(ChunkCoordinate.fromChunkCoords(0, 0)) : new ArrayList();
        this.writeToFile(this.name, blocks, masterBranches, WorldConfig.ConfigMode.WriteAll, OTG.getEngine().getGlobalObjectsDirectory());
        return true;
    }

    private BO4BranchFunction recursiveHelper(boolean[][] exists, boolean[][] processed, Map<ChunkCoordinate, ArrayList<BO4BlockFunction>> blocksPerChunkArr, int x, int z, int posX, int posZ, File folder) {
        processed[x][z] = true;
        ArrayList<BO4BranchFunction> branches = new ArrayList<BO4BranchFunction>();
        if (x < exists.length - 1 && exists[x + 1][z] && !processed[x + 1][z]) {
            branches.add(this.recursiveHelper(exists, processed, blocksPerChunkArr, x + 1, z, 16, 0, folder));
        }
        if (z < exists[0].length && exists[x][z + 1] && !processed[x][z + 1]) {
            branches.add(this.recursiveHelper(exists, processed, blocksPerChunkArr, x, z + 1, 0, 16, folder));
        }
        if (z > 0 && exists[x][z - 1] && !processed[x][z - 1]) {
            branches.add(this.recursiveHelper(exists, processed, blocksPerChunkArr, x, z - 1, 0, -16, folder));
        }
        if (x > 0 && exists[x - 1][z] && !processed[x - 1][z]) {
            branches.add(this.recursiveHelper(exists, processed, blocksPerChunkArr, x - 1, z, -16, 0, folder));
        }
        this.writeToFile(this.name + "C" + x + "R" + z, (List<BO4BlockFunction>)blocksPerChunkArr.get(ChunkCoordinate.fromChunkCoords(x, z)), branches, WorldConfig.ConfigMode.WriteWithoutComments, folder);
        return (BO4BranchFunction)CustomObjectConfigFunction.create(null, BO4BranchFunction.class, posX, 0, posZ, true, this.name + "C" + x + "R" + z, "NORTH", 100, 0);
    }

    private void writeToFile(String filename, List<BO4BlockFunction> blocks, List<BO4BranchFunction> branches, WorldConfig.ConfigMode mode, File directory) {
        BO4 bo4;
        try {
            File file = new File(directory, filename + ".BO4");
            BO4Config config = new BO4Config(new FileSettingsReaderOTGPlus(this.name, file), true);
            config.author = this.author;
            bo4 = new BO4(this.name, file, config);
        }
        catch (InvalidConfigException e) {
            OTG.log(LogMarker.ERROR, "Could not export BO4 file, there was an error in the BO4Config: " + e.getMessage(), new Object[0]);
            return;
        }
        bo4.getConfig().settingsMode = mode;
        try {
            bo4.getConfig().writeWithData(new FileSettingsWriterOTGPlus(bo4.getConfig().getFile()), blocks, branches);
            OTG.getCustomObjectManager().registerGlobalObject(bo4);
        }
        catch (IOException ex) {
            OTG.log(LogMarker.ERROR, "Failed to write to file {}", bo4.getConfig().getFile());
            OTG.printStackTrace(LogMarker.ERROR, ex);
        }
    }
}

