/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.PluginConfig;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.BiomeConfigFinder;
import com.pg85.otg.configuration.biome.BiomeLoadInstruction;
import com.pg85.otg.configuration.biome.settings.BiomeResourcesManager;
import com.pg85.otg.configuration.customobjects.CustomObjectResourcesManager;
import com.pg85.otg.configuration.dimensions.DimensionsConfig;
import com.pg85.otg.configuration.dimensions.ModPackConfigManager;
import com.pg85.otg.configuration.io.FileSettingsReader;
import com.pg85.otg.configuration.io.FileSettingsWriter;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectManager;
import com.pg85.otg.events.EventHandler;
import com.pg85.otg.events.EventPriority;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.biome.BiomeModeManager;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.logging.Logger;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public abstract class OTGEngine {
    private HashMap<String, BiomeConfig[]> otgBiomeIdsByWorld = new HashMap();
    private BiomeModeManager biomeManagers;
    private List<EventHandler> cancelableEventHandlers = new ArrayList<EventHandler>(5);
    private BiomeResourcesManager biomeResourcesManager;
    private CustomObjectResourcesManager customObjectResourcesManager;
    private CustomObjectManager customObjectManager;
    private List<EventHandler> monitoringEventHandlers = new ArrayList<EventHandler>(5);
    private PluginConfig pluginConfig;
    private DimensionsConfig dimensionsConfig = null;
    private ModPackConfigManager modPackConfigManager;
    private Logger logger;

    public OTGEngine(Logger logger) {
        this.logger = logger;
    }

    public void onShutdown() {
        this.customObjectManager.shutdown();
        this.cancelableEventHandlers.clear();
        this.monitoringEventHandlers.clear();
        this.cancelableEventHandlers = null;
        this.monitoringEventHandlers = null;
    }

    public void onStart() {
        File worldsDir;
        File globalBiomesDir;
        File pluginConfigFile = new File(this.getOTGRootFolder(), "OTG.ini");
        this.pluginConfig = new PluginConfig(FileSettingsReader.read("OTG.ini", pluginConfigFile));
        FileSettingsWriter.writeToFile(this.pluginConfig.getSettingsAsMap(), pluginConfigFile, this.pluginConfig.settingsMode);
        this.logger.setLevel(this.pluginConfig.getLogLevel().getLevel());
        this.biomeResourcesManager = new BiomeResourcesManager();
        this.customObjectResourcesManager = new CustomObjectResourcesManager();
        this.biomeManagers = new BiomeModeManager();
        this.customObjectManager = new CustomObjectManager();
        File globalObjectsDir = new File(this.getOTGRootFolder(), "GlobalObjects");
        if (!globalObjectsDir.exists()) {
            globalObjectsDir.mkdirs();
        }
        if (!(globalBiomesDir = new File(this.getOTGRootFolder(), "GlobalBiomes")).exists()) {
            globalBiomesDir.mkdirs();
        }
        if (!(worldsDir = new File(this.getOTGRootFolder(), "worlds")).exists()) {
            worldsDir.mkdirs();
        }
        this.modPackConfigManager = new ModPackConfigManager(this.getOTGRootFolder());
        for (EventHandler handler : this.cancelableEventHandlers) {
            handler.onStart();
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onStart();
        }
    }

    public void registerEventHandler(EventHandler handler) {
        this.cancelableEventHandlers.add(handler);
    }

    public void registerEventHandler(EventHandler handler, EventPriority priority) {
        if (priority == EventPriority.CANCELABLE) {
            this.cancelableEventHandlers.add(handler);
        } else {
            this.monitoringEventHandlers.add(handler);
        }
    }

    public boolean fireReplaceBiomeBlocksEvent(int x, int z, ChunkBuffer chunkBuffer, LocalWorld localWorld) {
        return true;
    }

    public boolean fireCanCustomObjectSpawnEvent(CustomObject object, LocalWorld world, int x, int y, int z) {
        boolean success = true;
        for (EventHandler handler : this.cancelableEventHandlers) {
            if (handler.canCustomObjectSpawn(object, world, x, y, z, !success)) continue;
            success = false;
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.canCustomObjectSpawn(object, world, x, y, z, !success);
        }
        return success;
    }

    public void firePopulationEndEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        for (EventHandler handler : this.cancelableEventHandlers) {
            handler.onPopulateEnd(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onPopulateEnd(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
    }

    public void firePopulationStartEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        for (EventHandler handler : this.cancelableEventHandlers) {
            handler.onPopulateStart(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onPopulateStart(world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        }
    }

    public boolean fireResourceProcessEvent(Resource resource, LocalWorld world, Random random, boolean villageInChunk, int chunkX, int chunkZ) {
        boolean success = true;
        for (EventHandler handler : this.cancelableEventHandlers) {
            if (handler.onResourceProcess(resource, world, random, villageInChunk, chunkX, chunkZ, !success)) continue;
            success = false;
        }
        for (EventHandler handler : this.monitoringEventHandlers) {
            handler.onResourceProcess(resource, world, random, villageInChunk, chunkX, chunkZ, !success);
        }
        return success;
    }

    public BiomeModeManager getBiomeModeManager() {
        return this.biomeManagers;
    }

    public BiomeResourcesManager getBiomeResourceManager() {
        return this.biomeResourcesManager;
    }

    public CustomObjectResourcesManager getCustomObjectResourcesManager() {
        return this.customObjectResourcesManager;
    }

    public CustomObjectManager getCustomObjectManager() {
        return this.customObjectManager;
    }

    public ModPackConfigManager getModPackConfigManager() {
        return this.modPackConfigManager;
    }

    public abstract File getOTGRootFolder();

    public abstract File getGlobalObjectsDirectory();

    public abstract File getWorldsDirectory();

    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    public DimensionsConfig getDimensionsConfig() {
        return this.dimensionsConfig;
    }

    public void setDimensionsConfig(DimensionsConfig dimensionsConfig) {
        this.dimensionsConfig = dimensionsConfig;
    }

    public String getPresetName(String worldName) {
        if (worldName.equals("overworld") || worldName.equals(OTG.getDimensionsConfig().WorldName)) {
            return OTG.getDimensionsConfig().Overworld.PresetName;
        }
        return worldName;
    }

    public abstract LocalWorld getWorld(String var1);

    public abstract LocalWorld getUnloadedWorld(String var1);

    public abstract ArrayList<LocalWorld> getAllWorlds();

    public void setOTGBiomeId(String worldName, int i, BiomeConfig biomeConfig, boolean replaceExisting) {
        if (!this.otgBiomeIdsByWorld.containsKey(worldName)) {
            this.otgBiomeIdsByWorld.put(worldName, new BiomeConfig[2048]);
        }
        if (!replaceExisting && this.otgBiomeIdsByWorld.get(worldName)[i] != null) {
            throw new RuntimeException("Tried to register OTG biome " + biomeConfig.getName() + " with id " + i + " but the id is in use by biome " + this.otgBiomeIdsByWorld.get(worldName)[i].getName() + ". OTG 1.12.2 v7 and above use dynamic biome id's for new worlds, this avoids the problem completely.");
        }
        this.otgBiomeIdsByWorld.get((Object)worldName)[i] = biomeConfig;
    }

    public BiomeConfig[] getOTGBiomeIds(String worldName) {
        return this.otgBiomeIdsByWorld.containsKey(worldName) ? this.otgBiomeIdsByWorld.get(worldName) : new BiomeConfig[2048];
    }

    public boolean isOTGBiomeIdAvailable(String worldName, int i) {
        return !this.otgBiomeIdsByWorld.containsKey(worldName) || this.otgBiomeIdsByWorld.get(worldName)[i] == null;
    }

    public void unregisterOTGBiomeId(String worldName, int i) {
        this.otgBiomeIdsByWorld.get((Object)worldName)[i] = null;
    }

    public abstract LocalMaterialData readMaterial(String var1) throws InvalidConfigException;

    public abstract LocalMaterialData toLocalMaterialData(DefaultMaterial var1, int var2);

    public Logger getLogger() {
        return this.logger;
    }

    public abstract boolean isModLoaded(String var1);

    public abstract boolean areEnoughBiomeIdsAvailableForPresets(ArrayList<String> var1);

    public abstract Collection<BiomeLoadInstruction> getDefaultBiomes();

    public abstract void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub var1, String var2);
}

