/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.nbt.tags;

import jaredbgreat.dldungeons.nbt.NBTType;
import jaredbgreat.dldungeons.nbt.tags.ITag;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTByteArray
extends ITag {
    public final byte[] data;

    NBTByteArray(String label, String name, String data) {
        super(label, name);
        ArrayList<Byte> tmp = this.parseData(data);
        this.data = new byte[tmp.size()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = tmp.get(i);
        }
    }

    NBTByteArray(String label, String name, byte[] data) {
        super(label, name);
        this.data = data;
    }

    @Override
    public void write(NBTTagCompound cmp) {
        cmp.func_74773_a(this.name, this.data);
    }

    @Override
    public void write(NBTTagList cmp) {
        cmp.func_74742_a((NBTBase)new NBTTagByteArray(this.data));
    }

    private ArrayList<Byte> parseData(String in) {
        StringTokenizer tokens = new StringTokenizer(in, "{,}");
        ArrayList<Byte> tmp = new ArrayList<Byte>();
        while (tokens.hasMoreTokens()) {
            tmp.add(Byte.parseByte(tokens.nextToken()));
        }
        return tmp;
    }

    @Override
    public NBTType getType() {
        return NBTType.BYTE_ARRAY;
    }
}

