/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommandSetTree
extends SubCommand {
    public static final String SETTREE = "settree";
    public static final String DEFAULTJOCODE = "JP";

    @Override
    public String getName() {
        return SETTREE;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        switch (args.length) {
            case 2: 
            case 3: 
            case 4: {
                return CommandBase.func_175771_a((String[])args, (int)1, (BlockPos)targetPos);
            }
            case 5: {
                return CommandBase.func_175762_a((String[])args, (Collection)Species.REGISTRY.getKeys());
            }
            case 6: {
                return Lists.newArrayList((Object[])new String[]{DEFAULTJOCODE});
            }
            case 7: {
                return Lists.newArrayList((Object[])new String[]{"0"});
            }
        }
        return super.getTabCompletions(server, sender, args, targetPos);
    }

    @Override
    public void execute(World world, ICommandSender sender, String[] args) throws CommandException {
        BlockPos pos = BlockPos.field_177992_a;
        Species species = null;
        String joCode = "";
        int turns = 0;
        if (args.length < 5) {
            throw new WrongUsageException("commands.dynamictrees.setree.usage", new Object[0]);
        }
        block8: for (int arg = 0; arg < args.length; ++arg) {
            switch (arg) {
                case 3: {
                    pos = CommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false);
                    continue block8;
                }
                case 4: {
                    species = TreeRegistry.findSpeciesSloppy(args[4]);
                    if (species != Species.NULLSPECIES) continue block8;
                    throw new WrongUsageException("commands.dynamictrees.setree.specieserror", new Object[]{args[4]});
                }
                case 5: {
                    joCode = args[5];
                    continue block8;
                }
                case 6: {
                    try {
                        turns = Integer.parseInt(args[6]);
                        continue block8;
                    }
                    catch (NumberFormatException e) {
                        throw new WrongUsageException("commands.dynamictrees.rotatejocode.turnserror", new Object[]{args[6]});
                    }
                }
            }
        }
        if (joCode.isEmpty()) {
            joCode = DEFAULTJOCODE;
        }
        turns = 3 - turns % 4 + 3;
        species.getJoCode(joCode).rotate(EnumFacing.func_176731_b((int)turns)).setCareful(true).generate(world, species, pos, world.func_180494_b(pos), EnumFacing.SOUTH, 8, SafeChunkBounds.ANY);
    }
}

