/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.lib.script.Module;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Text;
import cd4017be.lib.util.TooltipUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;

public class TooltipEditor {
    private static final int CURSOR_BLINK_INTERVAL = 500;
    private HashMap<String, String> edited = new HashMap();
    private String editingKey;
    private String editingValue = "";
    String[] lastKeys = new String[8];
    int pos;
    int ofs;
    private int cursor;
    private int cursor2;
    private final File langFile;
    private String lastLanguage;
    private boolean specialCombo;

    @SideOnly(value=Side.CLIENT)
    public static void init() {
        IOperand path;
        if (TooltipUtil.editor != null) {
            return;
        }
        Module m = (Module)RecipeScriptContext.instance.modules.get("core");
        if (m != null && (path = m.read("tooltip_editor_file")) instanceof Text) {
            File file = new File(Minecraft.func_71410_x().field_71412_D, ((Text)path).value);
            if (file.exists()) {
                TooltipUtil.editor = new TooltipEditor(file);
                FMLLog.log((String)"tooltipEditor", (Level)Level.INFO, (String)"ingame tooltip editor is enabled", (Object[])new Object[0]);
            } else {
                FMLLog.log((String)"tooltipEditor", (Level)Level.WARN, (String)"tooltip editor could not be enabled because assigned output file %s doesn't exist!", (Object[])new Object[]{file});
            }
        }
    }

    public TooltipEditor(File langFile) {
        this.langFile = langFile;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.lastLanguage = FMLClientHandler.instance().getCurrentLanguage();
    }

    public boolean hasEdited(String s) {
        return s.equals(this.editingKey) || this.edited.containsKey(s);
    }

    public String getTranslation(String key) {
        this.pos = this.pos + 1 & 7;
        this.lastKeys[this.pos] = key;
        if (key.equals(this.editingKey)) {
            return this.textField();
        }
        String s = this.edited.get(key);
        if (s != null) {
            return s;
        }
        return I18n.func_74838_a((String)key);
    }

    private String textField() {
        int b;
        int a;
        if (System.currentTimeMillis() % 500L * 2L >= 500L) {
            return this.editingValue;
        }
        if (this.cursor == this.cursor2) {
            return this.put(this.cursor, "|", this.cursor);
        }
        if (this.cursor < this.cursor2) {
            a = this.cursor;
            b = this.cursor2;
        } else {
            a = this.cursor2;
            b = this.cursor;
        }
        return this.editingValue.substring(0, a) + "[" + this.editingValue.substring(a, b) + "]" + this.editingValue.substring(b);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void keyTyped(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        int k = Keyboard.getEventKey();
        if (this.editingKey != null) {
            if (Keyboard.getEventKeyState()) {
                this.textFieldInput();
            }
        } else if (k == 31 && Keyboard.isKeyDown((int)62)) {
            if (Keyboard.getEventKeyState()) {
                this.specialCombo = true;
                this.save();
            }
        } else if (k == 62) {
            if (Keyboard.getEventKeyState()) {
                String l = FMLClientHandler.instance().getCurrentLanguage();
                if (!l.equals(this.lastLanguage)) {
                    this.save();
                    this.lastLanguage = l;
                    this.edited.clear();
                }
            } else if (this.specialCombo) {
                this.specialCombo = false;
            } else {
                String key = this.lastKeys[this.pos];
                if (key != null) {
                    this.editingValue = this.getTranslation(key);
                    this.cursor = this.cursor2 = this.editingValue.length();
                    this.editingKey = key;
                    this.ofs = 0;
                    TooltipUtil.altOverride = GuiScreen.func_146271_m();
                    TooltipUtil.shiftOverride = GuiScreen.func_146272_n();
                    TooltipUtil.overrideModifiers = true;
                }
            }
        } else {
            return;
        }
        event.setCanceled(true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void render(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (this.editingKey == null) {
            return;
        }
        GuiScreen gui = e.getGui();
        for (int i = 0; i < 8; ++i) {
            String s;
            String string = s = i == this.ofs ? this.editingKey : this.lastKeys[this.pos - i & 7];
            if (s == null) continue;
            gui.func_73731_b(gui.field_146297_k.field_71466_p, s, 5, gui.field_146295_m - gui.field_146297_k.field_71466_p.field_78288_b * (i + 1) - 5, i == this.ofs ? 0xFFFF80 : (this.edited.containsKey(s) ? 0x8080FF : 0xC0C0C0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void textFieldInput() {
        int k = Keyboard.getEventKey();
        boolean shift = GuiScreen.func_146272_n();
        switch (k) {
            case 205: {
                if (shift) {
                    if (this.cursor2 >= this.editingValue.length()) break;
                    ++this.cursor2;
                    break;
                }
                if (this.cursor >= this.editingValue.length()) break;
                this.cursor2 = ++this.cursor;
                break;
            }
            case 203: {
                if (shift) {
                    if (this.cursor2 <= 0) break;
                    --this.cursor2;
                    break;
                }
                if (this.cursor <= 0) break;
                this.cursor2 = --this.cursor;
                break;
            }
            case 207: {
                this.cursor2 = this.editingValue.length();
                if (shift) break;
                this.cursor = this.cursor2;
                break;
            }
            case 199: {
                this.cursor2 = 0;
                if (shift) break;
                this.cursor = this.cursor2;
                break;
            }
            case 211: {
                if (this.cursor != this.cursor2) {
                    this.editingValue = this.put(this.cursor, "", this.cursor2);
                    this.cursor2 = this.cursor < this.cursor2 ? this.cursor : this.cursor2;
                    this.cursor = this.cursor2;
                    break;
                }
                if (this.cursor >= this.editingValue.length()) break;
                this.editingValue = this.put(this.cursor, "", this.cursor + 1);
                break;
            }
            case 14: {
                if (this.cursor != this.cursor2) {
                    this.editingValue = this.put(this.cursor, "", this.cursor2);
                    this.cursor2 = this.cursor < this.cursor2 ? this.cursor : this.cursor2;
                    this.cursor = this.cursor2;
                    break;
                }
                if (this.cursor <= 0) break;
                this.editingValue = this.put(this.cursor - 1, "", this.cursor);
                this.cursor2 = --this.cursor;
                break;
            }
            case 28: {
                this.editingValue = this.put(this.cursor, "\n", this.cursor2);
                this.cursor = this.cursor2 = (this.cursor < this.cursor2 ? this.cursor : this.cursor2) + 1;
                break;
            }
            case 200: {
                int p = this.editingValue.lastIndexOf(10, this.cursor - 1);
                int n = this.cursor2 = p < 0 ? 0 : p;
                if (shift) break;
                this.cursor = this.cursor2;
                break;
            }
            case 208: {
                int p = this.editingValue.indexOf(10, this.cursor + 1);
                int n = this.cursor2 = p < 0 ? this.editingValue.length() : p;
                if (shift) break;
                this.cursor = this.cursor2;
                break;
            }
            case 1: {
                String key = this.editingKey;
                this.editingKey = null;
                if (!this.editingValue.equals(this.getTranslation(key))) {
                    this.edited.put(key, this.editingValue);
                }
                TooltipUtil.overrideModifiers = false;
                break;
            }
            case 201: {
                if (this.ofs < 7) {
                    ++this.ofs;
                }
                String nkey = this.lastKeys[this.pos - this.ofs & 7];
                String key = this.editingKey;
                this.editingKey = null;
                if (!this.editingValue.equals(this.getTranslation(key))) {
                    this.edited.put(key, this.editingValue);
                }
                if (nkey != null) {
                    this.editingValue = this.getTranslation(nkey);
                    this.editingKey = nkey;
                    this.cursor = this.cursor2 = this.editingValue.length();
                    break;
                }
                TooltipUtil.overrideModifiers = false;
                break;
            }
            case 209: {
                if (this.ofs > 0) {
                    --this.ofs;
                }
                String nkey = this.lastKeys[this.pos - this.ofs & 7];
                String key = this.editingKey;
                this.editingKey = null;
                if (!this.editingValue.equals(this.getTranslation(key))) {
                    this.edited.put(key, this.editingValue);
                }
                if (nkey != null) {
                    this.editingValue = this.getTranslation(nkey);
                    this.editingKey = nkey;
                    this.cursor = this.cursor2 = this.editingValue.length();
                    break;
                }
                TooltipUtil.overrideModifiers = false;
                break;
            }
            default: {
                if (GuiScreen.func_146271_m() && !shift && !GuiScreen.func_175283_s()) {
                    switch (k) {
                        case 46: {
                            if (this.cursor == this.cursor2) break;
                            GuiScreen.func_146275_d((String)this.get(this.cursor, this.cursor2));
                            break;
                        }
                        case 45: {
                            if (this.cursor == this.cursor2) break;
                            GuiScreen.func_146275_d((String)this.get(this.cursor, this.cursor2));
                            this.editingValue = this.put(this.cursor, "", this.cursor2);
                            this.cursor2 = this.cursor < this.cursor2 ? this.cursor : this.cursor2;
                            this.cursor = this.cursor2;
                            break;
                        }
                        case 47: {
                            String s = GuiScreen.func_146277_j();
                            this.editingValue = this.put(this.cursor, s, this.cursor2);
                            this.cursor = this.cursor2 = (this.cursor < this.cursor2 ? this.cursor : this.cursor2) + s.length();
                            break;
                        }
                        case 30: {
                            this.cursor = 0;
                            this.cursor2 = this.editingValue.length();
                            break;
                        }
                        case 31: {
                            this.edited.put(this.editingKey, this.editingValue);
                            break;
                        }
                        case 44: {
                            String s = this.edited.get(this.editingKey);
                            if (s == null) break;
                            this.editingValue = s;
                            if (this.cursor > this.editingValue.length()) {
                                this.cursor = this.editingValue.length();
                            }
                            this.cursor2 = this.cursor;
                        }
                    }
                    break;
                }
                char c = Keyboard.getEventCharacter();
                if (Character.isISOControl(c)) break;
                this.editingValue = this.put(this.cursor, "" + c, this.cursor2);
                this.cursor = this.cursor2 = (this.cursor < this.cursor2 ? this.cursor : this.cursor2) + 1;
            }
        }
    }

    private String put(int start, String repl, int end) {
        if (end < start) {
            int x = start;
            start = end;
            end = x;
        }
        return this.editingValue.substring(0, start) + repl + this.editingValue.substring(end);
    }

    private String get(int start, int end) {
        if (end < start) {
            int x = start;
            start = end;
            end = x;
        }
        return this.editingValue.substring(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void save() {
        int p;
        if (this.edited.isEmpty()) {
            return;
        }
        File f = new File(this.langFile, this.lastLanguage + ".lang");
        if (!f.exists() && (p = this.lastLanguage.indexOf(95) + 1) > 0) {
            f = new File(this.langFile, this.lastLanguage.substring(0, p) + this.lastLanguage.substring(p).toUpperCase() + ".lang");
        }
        Path file = f.toPath();
        HashMap changes = (HashMap)this.edited.clone();
        int n = changes.size();
        ArrayList<Object> entries = new ArrayList<Object>();
        String lineSep = System.setProperty("line.separator", "\r\n");
        boolean hasAnot = false;
        try {
            for (String string : Files.readAllLines(file)) {
                void var9_11;
                if (!string.isEmpty() && string.charAt(0) != '#') {
                    String key;
                    String value;
                    int p2 = this.findUnescaped(string, '=');
                    int q = this.findUnescaped(string, ':');
                    if (p2 < 0 || q >= 0 && q < p2) {
                        p2 = q;
                    }
                    if (p2 >= 0 && (value = (String)changes.remove(key = this.removeEscapes(string.substring(0, p2)))) != null) {
                        String string2 = string.substring(0, p2 + 1) + this.escape(value);
                    }
                } else if (string.startsWith("#added by ingame editor:")) {
                    hasAnot = true;
                }
                entries.add(var9_11);
            }
            if ((n -= changes.size()) > 0) {
                FMLLog.log((String)"tooltipEditor", (Level)Level.INFO, (String)"%d lang entries were changed", (Object[])new Object[]{n});
            }
            if (!changes.isEmpty()) {
                if (!hasAnot) {
                    entries.add("#added by ingame editor:");
                }
                for (Map.Entry entry : changes.entrySet()) {
                    entries.add(this.escape((String)entry.getKey()) + "=" + this.escape((String)entry.getValue()));
                }
                FMLLog.log((String)"tooltipEditor", (Level)Level.INFO, (String)"%d lang entries were added", (Object[])new Object[]{changes.size()});
            }
            Files.write(file, entries, new OpenOption[0]);
        }
        catch (IOException e) {
            FMLLog.log((String)"tooltipEditor", (Level)Level.ERROR, (Throwable)e, (String)"failed saving changes to lang file: %s", (Object[])new Object[]{this.langFile});
            return;
        }
        finally {
            if (lineSep == null) {
                System.clearProperty("line.separator");
            } else {
                System.setProperty("line.separator", lineSep);
            }
        }
    }

    private int findUnescaped(String s, char c) {
        int p = -1;
        while (this.isEscaped(s, p = s.indexOf(c, p + 1))) {
        }
        return p;
    }

    private boolean isEscaped(String s, int p) {
        return p > 0 && s.charAt(p - 1) == '\\' && !this.isEscaped(s, p - 1);
    }

    private String removeEscapes(String s) {
        int p = 0;
        while (p < s.length() && (p = s.indexOf(92, p)) >= 0) {
            s = s.substring(0, p) + s.substring(++p);
        }
        return s;
    }

    private String escape(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '=' || c == ':') {
                s = s.substring(0, i) + '\\' + s.substring(i);
                ++i;
                continue;
            }
            if (c != '\n') continue;
            s = s.substring(0, i) + "\\n" + s.substring(i + 1);
            ++i;
        }
        return s;
    }
}

