/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script;

import cd4017be.lib.script.Module;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.script.obj.Text;
import cd4017be.lib.script.obj.Vector;
import java.util.HashMap;
import java.util.function.Function;
import javax.script.ScriptException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class Context
implements Module {
    public static final Marker SCRIPT = MarkerManager.getMarker((String)"SCRIPT");
    public static final Marker PRINT = MarkerManager.getMarker((String)"PRINT").setParents(new Marker[]{SCRIPT});
    public static final Marker ERROR = MarkerManager.getMarker((String)"ERROR").setParents(new Marker[]{SCRIPT});
    private static final Function<Parameters, IOperand> TIME = p -> new Number((double)System.currentTimeMillis() / 1000.0);
    private static final Function<Parameters, IOperand> REPL = p -> new Text(p.getString(0).replaceFirst(p.getString(1), p.getString(2)));
    private static final Function<Parameters, IOperand> NARR = p -> new Array((int)p.getNumber(0));
    private static final Function<Parameters, IOperand> NVEC = p -> new Vector((int)p.getNumber(0));
    public HashMap<String, Module> modules = new HashMap();
    public HashMap<String, Function<Parameters, IOperand>> defFunc = new HashMap();
    public int recursion = 0;
    public final Logger LOG;

    public Context(Logger log) {
        this.LOG = log;
        this.defFunc.put("print", p -> {
            this.LOG.info(PRINT, p.get(0));
            return null;
        });
        this.defFunc.put("time", TIME);
        this.defFunc.put("repl", REPL);
        this.defFunc.put("narr", NARR);
        this.defFunc.put("nvec", NVEC);
    }

    private String[] split(String name) {
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            return new String[]{name.substring(0, p), name.substring(p + 1)};
        }
        return new String[]{"", name};
    }

    @Override
    public IOperand invoke(String name, Parameters args) throws NoSuchMethodException, ScriptException {
        String[] s = this.split(name);
        if (s[0] == null) {
            Function<Parameters, IOperand> f = this.defFunc.get(s[1]);
            if (f != null) {
                return f.apply(args);
            }
        } else {
            Module m = this.modules.get(s[0]);
            if (m != null) {
                return m.invoke(s[1], args);
            }
        }
        throw new NoSuchMethodException(name);
    }

    @Override
    public void assign(String name, IOperand val) {
        String[] s = this.split(name);
        Module m = this.modules.get(s[0]);
        if (m != null) {
            m.assign(s[1], val);
        }
    }

    @Override
    public IOperand read(String name) {
        String[] s = this.split(name);
        Module m = this.modules.get(s[0]);
        if (m != null) {
            return m.read(s[1]);
        }
        return null;
    }

    public void add(Module m) {
        this.modules.put(m.addToContext(this), m);
    }

    @Override
    public String addToContext(Context cont) {
        return null;
    }

    public void reset() {
        this.recursion = 0;
    }
}

