/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.Gui.comp;

import cd4017be.lib.Gui.comp.GuiCompBase;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.util.TooltipUtil;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;

public class InfoTab
extends GuiCompBase<GuiCompGroup> {
    private final String tooltip;
    private final String[] headers;
    private final String[] keys;
    private int page = 0;

    public InfoTab(GuiCompGroup parent, int w, int h, int x, int y, String tooltip) {
        super(parent, w, h, x, y);
        this.tooltip = tooltip;
        this.headers = TooltipUtil.translate(tooltip).split("\n");
        this.keys = new String[this.headers.length];
        this.initHeader();
    }

    private void initHeader() {
        for (int i = 0; i < this.keys.length; ++i) {
            String s = this.headers[i];
            int p = s.indexOf(64);
            if (p < 0) {
                this.keys[i] = this.tooltip + i;
                continue;
            }
            this.keys[i] = s.substring(p + 1).trim();
            this.headers[i] = s.substring(0, p);
        }
    }

    @Override
    public void drawOverlay(int mx, int my) {
        if (TooltipUtil.editor != null) {
            String[] s = TooltipUtil.translate(this.tooltip).split("\n");
            System.arraycopy(s, 0, this.headers, 0, Math.min(s.length, this.headers.length));
            this.initHeader();
        }
        ArrayList<String> list = new ArrayList<String>();
        String s = "";
        for (int i = 0; i < this.headers.length; ++i) {
            String h = this.headers[i];
            if (!h.isEmpty() && h.charAt(0) == '\u00a7') {
                s = s + h.substring(0, 2);
                h = h.substring(2);
            }
            if (i == this.page) {
                s = s + "\u00a7" + ChatFormatting.UNDERLINE.getChar();
            }
            s = s + h + '\u00a7' + ChatFormatting.RESET.getChar() + " | ";
        }
        list.add(s.substring(0, s.length() - 3));
        for (String l : TooltipUtil.getConfigFormat(this.keys[this.page]).split("\n")) {
            list.add(l);
        }
        this.parent.drawTooltip(list, mx, my);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mouseIn(int x, int y, int b, byte d) {
        if (d == 0) {
            if (b == 0) {
                ++this.page;
            } else {
                if (b != 1) return false;
                --this.page;
            }
        } else {
            if (d != 3) return false;
            this.page += b;
        }
        this.page = Math.floorMod(this.page, this.headers.length);
        return true;
    }
}

