/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.interact;

import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.interact.IInteractiveDevice;
import cd4017be.lib.render.HybridFastTESR;
import cd4017be.lib.render.Util;
import cd4017be.lib.render.model.MultipartModel;
import cd4017be.lib.util.Orientation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@SideOnly(value=Side.CLIENT)
public class InteractiveDeviceRenderer
extends HybridFastTESR<TileEntity>
implements MultipartModel.IModelProvider {
    public final ArrayList<ResourceLocation> dependencies = new ArrayList();
    public final ArrayList<BiConsumer<VertexFormat, Function<ResourceLocation, TextureAtlasSprite>>> bakeCallbacks = new ArrayList();

    @Override
    public void renderTileEntityFast(TileEntity te, double x, double y, double z, float t, int destroy, float alpha, BufferBuilder buffer) {
        Collection<IInteractiveComponent.ITESRenderComp> comps = ((IInteractiveDevice)te).getTESRComponents();
        if (comps.isEmpty()) {
            return;
        }
        World world = te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        int l = world.func_175626_b(pos, 0);
        for (IInteractiveComponent.ITESRenderComp c : comps) {
            c.render(world, pos, x, y, z, l, buffer);
        }
    }

    @Override
    protected void renderSpecialPart(TileEntity te, double x, double y, double z, float t, int destroy, float alpha) {
        Triple<IInteractiveComponent, Vec3d, EnumFacing> r = ((IInteractiveDevice)te).rayTrace(this.field_147501_a.field_147551_g, t);
        if (r == null) {
            return;
        }
        Pair<Vec3d, String> text = ((IInteractiveComponent)r.getLeft()).getDisplayText((Vec3d)r.getMiddle());
        if (text == null) {
            return;
        }
        GlStateManager.func_179094_E();
        Orientation o = Orientation.fromFacing((EnumFacing)r.getRight());
        if (o.ordinal() >= 4) {
            int i = Math.floorMod(Math.round(Minecraft.func_71410_x().field_71439_g.field_70177_z / 90.0f), 4);
            o = Orientation.values()[i + o.ordinal()];
        }
        Vec3d p = (Vec3d)text.getKey();
        Util.moveAndOrientToBlock(x - 0.5 + p.field_72450_a, y - 0.5 + p.field_72448_b, z - 0.5 + p.field_72449_c, o);
        float scale = 0.0078125f;
        GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)(-scale));
        Util.renderToolTip(Minecraft.func_71410_x().field_71466_p, 0, -16, 0xFFFFFF, Integer.MIN_VALUE, ((String)text.getValue()).split("\n"));
        GlStateManager.func_179121_F();
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void bake(VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        for (BiConsumer<VertexFormat, Function<ResourceLocation, TextureAtlasSprite>> c : this.bakeCallbacks) {
            c.accept(format, textureGetter);
        }
    }

    @Override
    public void getQuads(List<BakedQuad> quads, Object val, BlockRenderLayer layer, IBlockState state, EnumFacing side, long rand) {
        if (layer != null && layer != BlockRenderLayer.CUTOUT || !(val instanceof Collection)) {
            return;
        }
        for (IInteractiveComponent.IBlockRenderComp brc : (Collection)val) {
            brc.render(quads);
        }
    }
}

