/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.FluidOperand;
import cd4017be.api.recipes.ItemOperand;
import cd4017be.api.recipes.RecipeAPI;
import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.script.Context;
import cd4017be.lib.script.Module;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.Script;
import cd4017be.lib.script.ScriptFiles;
import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.NBTWrapper;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.script.obj.ObjWrapper;
import cd4017be.lib.script.obj.Text;
import cd4017be.lib.script.obj.Vector;
import cd4017be.lib.util.FileUtil;
import cd4017be.lib.util.OreDictStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

public class RecipeScriptContext
extends Context {
    private static final Function<Parameters, IOperand> IT = p -> {
        ItemStack item = null;
        Object o = p.get(0);
        if (o instanceof String) {
            String name = (String)o;
            if (name.indexOf(58) < 0) {
                item = BlockItemRegistry.stack(name, 1);
            } else if (name.startsWith("ore:")) {
                NonNullList list = OreDictionary.getOres((String)(name = name.substring(4)));
                if (list.isEmpty()) {
                    throw new IllegalArgumentException("empty OreDictionary type: " + name);
                }
                item = ((ItemStack)list.get(0)).func_77946_l();
            } else {
                item = new ItemStack(Item.func_111206_d((String)name));
            }
            if (item == null || item.func_77973_b() == null) {
                throw new IllegalArgumentException("invalid item name: " + name);
            }
        } else if (o instanceof ItemStack) {
            item = ((ItemStack)o).func_77946_l();
        } else {
            if (o instanceof OreDictStack) {
                ItemStack[] arr = ((OreDictStack)o).getItems();
                int l = arr.length;
                Array a = new Array(l);
                IOperand[] ops = a.array;
                for (int i = l - 1; i >= 0; --i) {
                    ops[i] = new ItemOperand(arr[i]).onCopy();
                }
                return a;
            }
            throw new IllegalArgumentException("expected String, ItemStack or OreDictStack @ 0");
        }
        switch (p.param.length) {
            case 4: {
                item.func_77982_d(p.get(3, NBTTagCompound.class));
            }
            case 3: {
                item.func_77964_b((int)p.getNumber(2));
            }
            case 2: {
                item.func_190920_e((int)p.getNumber(1));
            }
        }
        return new ItemOperand(item);
    };
    private static final Function<Parameters, IOperand> FL = p -> {
        FluidStack fluid = null;
        Object o = p.get(0);
        if (o instanceof String) {
            String name = (String)o;
            fluid = FluidRegistry.getFluidStack((String)name, (int)0);
            if (fluid == null) {
                throw new IllegalArgumentException("invalid fluid name: " + name);
            }
        } else if (o instanceof FluidStack) {
            fluid = ((FluidStack)o).copy();
        } else {
            throw new IllegalArgumentException("expected String or FluidStack @ 0");
        }
        switch (p.param.length) {
            case 3: {
                fluid.tag = p.get(2, NBTTagCompound.class);
            }
            case 2: {
                fluid.amount = (int)p.getNumber(1);
            }
        }
        return new FluidOperand(fluid);
    };
    private static final Function<Parameters, IOperand> ORE = p -> {
        OreDictStack ore = null;
        Object o = p.get(0);
        if (o instanceof String) {
            String name = (String)o;
            ore = new OreDictStack(name, 1);
        } else if (o instanceof OreDictStack) {
            ore = ((OreDictStack)o).copy();
        } else {
            throw new IllegalArgumentException("expected String or OreDictStack @ 0");
        }
        if (p.param.length == 2) {
            ore.stacksize = (int)p.getNumber(1);
        }
        return ore;
    };
    private static final Function<Parameters, IOperand> HASIT = p -> {
        for (int i = p.param.length - 1; i >= 0; --i) {
            String name = p.getString(i);
            if (!(name.indexOf(58) < 0 ? BlockItemRegistry.stack(name, 1) == null : (name.startsWith("ore:") ? OreDictionary.getOres((String)name.substring(4)).isEmpty() : Item.func_111206_d((String)name) == null))) continue;
            return Number.FALSE;
        }
        return Number.TRUE;
    };
    private static final Function<Parameters, IOperand> HASFL = p -> {
        for (int i = p.param.length - 1; i >= 0; --i) {
            if (FluidRegistry.isFluidRegistered((String)p.getString(i))) continue;
            return Number.FALSE;
        }
        return Number.TRUE;
    };
    private static final Function<Parameters, IOperand> HASMOD = p -> Loader.isModLoaded((String)p.getString(0)) ? Number.TRUE : Number.FALSE;
    private static final Function<Parameters, IOperand> ADD = p -> {
        RecipeAPI.IRecipeHandler h = RecipeAPI.Handlers.get(p.getString(0));
        if (h == null) {
            throw new IllegalArgumentException(String.format("recipe Handler \"%s\" does'nt exist!", p.param[0]));
        }
        h.addRecipe((Parameters)p);
        return null;
    };
    private static final Function<Parameters, IOperand> LISTORE = p -> {
        Pattern filter = Pattern.compile(p.getString(0));
        ArrayList<Text> list = new ArrayList<Text>();
        for (String name : OreDictionary.getOreNames()) {
            if (!filter.matcher(name).matches()) continue;
            list.add(new Text(name));
        }
        return new Array(list.toArray(new IOperand[list.size()]));
    };
    private static final Function<Parameters, IOperand> LIST = p -> {
        RecipeAPI.IRecipeList l = RecipeAPI.Lists.get(p.getString(0));
        if (l == null) {
            throw new IllegalArgumentException(String.format("recipe List \"%s\" does'nt exist!", p.param[0]));
        }
        return l.list((Parameters)p);
    };
    private static final Function<Parameters, IOperand> NBT = p -> {
        if (!p.has(0)) {
            return new NBTWrapper();
        }
        Object o = p.get(0);
        if (o instanceof ItemStack && ((ItemStack)o).func_77942_o()) {
            return new NBTWrapper(((ItemStack)o).func_77978_p());
        }
        if (o instanceof FluidStack && ((FluidStack)o).tag != null) {
            return new NBTWrapper(((FluidStack)o).tag);
        }
        return Nil.NIL;
    };
    public static final List<ScriptFiles.Version> scriptRegistry = new ArrayList<ScriptFiles.Version>();
    public static RecipeScriptContext instance;

    public RecipeScriptContext(Logger log) {
        super(log);
        this.defFunc.put("it", IT);
        this.defFunc.put("fl", FL);
        this.defFunc.put("ore", ORE);
        this.defFunc.put("hasit", HASIT);
        this.defFunc.put("hasfl", HASFL);
        this.defFunc.put("hasmod", HASMOD);
        this.defFunc.put("add", ADD);
        this.defFunc.put("listore", LISTORE);
        this.defFunc.put("list", LIST);
        this.defFunc.put("nbt", NBT);
    }

    public void setup() {
        Script[] scripts;
        RecipeAPI.addModModules(this);
        File dir = FileUtil.configDir;
        File comp = new File(dir, "compiled.dat");
        HashMap<String, ScriptFiles.Version> versions = new HashMap<String, ScriptFiles.Version>();
        for (ScriptFiles.Version v : scriptRegistry) {
            if (v.fallback == null) continue;
            v.checkVersion();
            versions.put(v.name, v);
        }
        boolean reload = true;
        boolean existingCheck = false;
        try {
            scripts = ScriptFiles.loadPackage(comp, versions, true);
        }
        catch (FileNotFoundException e) {
            scripts = null;
            reload = false;
            existingCheck = true;
            this.LOG.info("No compiled config scripts found! This is probably the first startup.");
        }
        catch (IOException e) {
            scripts = null;
            reload = false;
            this.LOG.error("loading compiled config scripts failed!", (Throwable)e);
        }
        for (ScriptFiles.Version v : versions.values()) {
            try {
                File dst = new File(dir, v.name + ".rcp");
                if (existingCheck && dst.exists() && v.getFileVersion(new FileInputStream(dst)) >= v.version) continue;
                FileUtil.copyData(v.fallback, dst);
            }
            catch (IOException e) {
                this.LOG.error("copying script preset failed!", (Throwable)e);
            }
        }
        if (scripts == null && (scripts = ScriptFiles.createCompiledPackage(comp)) == null && reload) {
            try {
                this.LOG.info("Falling back to old scripts");
                scripts = ScriptFiles.loadPackage(comp, versions, false);
            }
            catch (IOException e) {
                this.LOG.error("loading compiled config scripts failed!", (Throwable)e);
            }
        }
        if (scripts != null) {
            for (Script s : scripts) {
                this.add(s);
            }
        }
    }

    public void runAll(String p) {
        for (ScriptFiles.Version v : scriptRegistry) {
            this.run(v.name + "." + p);
        }
    }

    public void run(String name) {
        this.reset();
        try {
            this.invoke(name, new Parameters(new IOperand[0]));
        }
        catch (NoSuchMethodException e) {
            this.LOG.info(SCRIPT, "skipped {}", (Object)name);
        }
        catch (Exception e) {
            this.LOG.error(SCRIPT, "script execution failed for " + name, (Throwable)e);
        }
    }

    static {
        scriptRegistry.add(new ScriptFiles.Version("core", "/assets/cd4017be_lib/config/core.rcp"));
    }

    public static class ConfigConstants {
        private final Module m;

        public ConfigConstants(Module m) {
            this.m = m;
        }

        public double getNumber(String name, double fallback) {
            if (this.m == null) {
                return fallback;
            }
            IOperand o = this.m.read(name);
            if (o instanceof Number) {
                return ((Number)o).value;
            }
            this.m.assign(name, new Number(fallback));
            return fallback;
        }

        public double[] getVect(String name, double[] pre) {
            if (this.m == null) {
                return pre;
            }
            IOperand o = this.m.read(name);
            if (o instanceof Vector) {
                double[] vec = ((Vector)o).value;
                int n = Math.min(vec.length, pre.length);
                System.arraycopy(vec, 0, pre, 0, n);
                if (n < pre.length) {
                    Vector v = new Vector(pre.length);
                    this.m.assign(name, v);
                    System.arraycopy(pre, 0, v.value, 0, pre.length);
                }
                return pre;
            }
            Vector vec = new Vector(pre.length);
            System.arraycopy(pre, 0, vec.value, 0, pre.length);
            this.m.assign(name, vec);
            return pre;
        }

        public int[] getVect(String name, int[] pre) {
            if (this.m == null) {
                return pre;
            }
            IOperand o = this.m.read(name);
            if (o instanceof Vector) {
                double[] vec = ((Vector)o).value;
                int n = Math.min(vec.length, pre.length);
                for (int i = 0; i < n; ++i) {
                    pre[i] = (int)vec[i];
                }
                if (n < pre.length) {
                    n = pre.length;
                    Vector v = new Vector(n);
                    vec = v.value;
                    this.m.assign(name, v);
                    for (int i = 0; i < n; ++i) {
                        vec[i] = pre[i];
                    }
                }
                return pre;
            }
            Vector vec = new Vector(pre.length);
            double[] a = vec.value;
            for (int i = pre.length - 1; i >= 0; --i) {
                a[i] = pre[i];
            }
            this.m.assign(name, vec);
            return pre;
        }

        public float[] getVect(String name, float[] pre) {
            if (this.m == null) {
                return pre;
            }
            IOperand o = this.m.read(name);
            if (o instanceof Vector) {
                double[] vec = ((Vector)o).value;
                int n = Math.min(vec.length, pre.length);
                for (int i = 0; i < n; ++i) {
                    pre[i] = (float)vec[i];
                }
                if (n < pre.length) {
                    n = pre.length;
                    Vector v = new Vector(n);
                    vec = v.value;
                    this.m.assign(name, v);
                    for (int i = 0; i < n; ++i) {
                        vec[i] = pre[i];
                    }
                }
                return pre;
            }
            Vector vec = new Vector(pre.length);
            double[] a = vec.value;
            for (int i = pre.length - 1; i >= 0; --i) {
                a[i] = pre[i];
            }
            this.m.assign(name, vec);
            return pre;
        }

        public <T> T get(String name, Class<T> type, T fallback) {
            if (this.m == null) {
                return fallback;
            }
            Object o = this.m.read(name).value();
            if (type.isInstance(o)) {
                return type.cast(o);
            }
            IOperand op = fallback instanceof IOperand ? (IOperand)fallback : (fallback instanceof String ? new Text((String)fallback) : (fallback instanceof ItemStack ? new ItemOperand((ItemStack)fallback) : (fallback instanceof FluidStack ? new FluidOperand((FluidStack)fallback) : (fallback == null ? Nil.NIL : new ObjWrapper(fallback)))));
            this.m.assign(name, op);
            return fallback;
        }

        public Object[] getArray(String name, int size) {
            if (this.m == null) {
                return new Object[size];
            }
            IOperand o = this.m.read(name);
            if (o instanceof Array) {
                Object[] vec = (Object[])o.value();
                if (vec.length < size) {
                    Object[] x = new IOperand[size - vec.length];
                    Arrays.fill(x, Nil.NIL);
                    this.m.assign(name, o.addR(new Array((IOperand[])x)));
                    vec = Arrays.copyOf(vec, size);
                }
                return vec;
            }
            Object[] x = new IOperand[size];
            Arrays.fill(x, Nil.NIL);
            this.m.assign(name, new Array((IOperand[])x));
            return new Object[size];
        }
    }

    public static class FluidMatcher {
        private final FluidStack ref;
        private final boolean ignAm;

        public FluidMatcher(FluidStack stack) {
            this.ref = stack;
            this.ignAm = stack.amount <= 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FluidStack)) {
                return false;
            }
            FluidStack fluid = (FluidStack)obj;
            return fluid.getFluid() == this.ref.getFluid() && (this.ignAm || fluid.amount == this.ref.amount);
        }
    }

    public static class ItemMatcher {
        private final ItemStack ref;
        private final boolean ignDmg;
        private final boolean ignAm;

        public ItemMatcher(ItemStack stack) {
            this.ref = stack;
            this.ignDmg = stack.func_77952_i() == Short.MAX_VALUE;
            this.ignAm = stack.func_190916_E() <= 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ItemStack)) {
                return false;
            }
            ItemStack item = (ItemStack)obj;
            return !(item.func_77973_b() != this.ref.func_77973_b() || !this.ignDmg && item.func_77952_i() != this.ref.func_77952_i() || !this.ignAm && item.func_190916_E() != this.ref.func_190916_E());
        }
    }
}

