/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.placeholder.v2;

import de.keksuccino.fancymenu.menu.placeholder.v2.Placeholder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlaceholderRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<String, Placeholder> placeholders = new LinkedHashMap<String, Placeholder>();

    public static void registerPlaceholder(Placeholder placeholder) {
        if (placeholder != null) {
            if (!placeholders.containsKey(placeholder.getIdentifier())) {
                placeholders.put(placeholder.getIdentifier(), placeholder);
            } else {
                LOGGER.error("[FANCYMENU] Unable to register placeholder! Placeholder ID already registered: " + placeholder.getIdentifier());
            }
        } else {
            LOGGER.error("[FANCYMENU] Unable to register placeholder! Placeholder was NULL!");
        }
    }

    @Nullable
    public static Placeholder getPlaceholderForIdentifier(String identifier) {
        return placeholders.get(identifier);
    }

    public static Map<String, Placeholder> getPlaceholders() {
        return placeholders;
    }

    public static List<Placeholder> getPlaceholdersList() {
        ArrayList<Placeholder> l = new ArrayList<Placeholder>();
        l.addAll(placeholders.values());
        return l;
    }
}

