/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.panorama;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.RenderSystem;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.util.glu.Project;

public class ExternalTexturePanoramaRenderer
extends Gui {
    private ExternalTextureResourceLocation overlay_texture;
    private float time;
    private String name = null;
    public String dir;
    private boolean prepared = false;
    private List<ExternalTextureResourceLocation> pano = new ArrayList<ExternalTextureResourceLocation>();
    private float speed = 1.0f;
    private float fov = 85.0f;
    private float angle = 25.0f;
    public float opacity = 1.0f;

    public ExternalTexturePanoramaRenderer(String panoDir) {
        this.dir = panoDir;
        File props = new File(this.dir + "/properties.txt");
        if (props.exists()) {
            PropertiesSet s = PropertiesSerializer.getProperties((String)props.getPath());
            if (s != null) {
                List l = s.getPropertiesOfType("panorama-meta");
                if (l != null && !l.isEmpty()) {
                    String an;
                    String fo;
                    String sp;
                    this.name = ((PropertiesSection)l.get(0)).getEntryValue("name");
                    if (this.name == null) {
                        System.out.println("############## ERROR [FANCYMENU] ##############");
                        System.out.println("Missing 'name' value in properties file for panorama cube: " + this.dir);
                        System.out.println("###############################################");
                    }
                    if ((sp = ((PropertiesSection)l.get(0)).getEntryValue("speed")) != null && MathUtils.isFloat((String)sp)) {
                        this.speed = Float.parseFloat(sp);
                    }
                    if ((fo = ((PropertiesSection)l.get(0)).getEntryValue("fov")) != null && MathUtils.isFloat((String)fo)) {
                        this.fov = Float.parseFloat(fo);
                    }
                    if ((an = ((PropertiesSection)l.get(0)).getEntryValue("angle")) != null && MathUtils.isFloat((String)an)) {
                        this.angle = Float.parseFloat(an);
                    }
                } else {
                    System.out.println("############## ERROR [FANCYMENU] ##############");
                    System.out.println("Missing 'panorama-meta' section in properties file for panorama cube: " + this.dir);
                    System.out.println("###############################################");
                }
            } else {
                System.out.println("############## ERROR [FANCYMENU] ##############");
                System.out.println("An error happened while trying to get properties for panorama cube: " + this.dir);
                System.out.println("###############################################");
            }
        } else {
            System.out.println("############## ERROR [FANCYMENU] ##############");
            System.out.println("Properties file not found for panorama cube: " + this.dir);
            System.out.println("###############################################");
        }
    }

    public void preparePanorama() {
        File imagesDir;
        if (!this.prepared && this.name != null && (imagesDir = new File(this.dir + "/panorama")).exists() && imagesDir.isDirectory()) {
            for (int i = 0; i < 6; ++i) {
                File f = new File(this.dir + "/panorama/panorama_" + i + ".png");
                if (!f.exists() || !f.isFile()) {
                    System.out.println("############## ERROR [FANCYMENU] ##############");
                    System.out.println("Missing panorama image 'panorama_" + i + ".png' for panorama cube: " + this.name);
                    System.out.println("###############################################");
                    return;
                }
                ExternalTextureResourceLocation r = new ExternalTextureResourceLocation(f.getPath());
                this.pano.add(r);
            }
            File overlay = new File(this.dir + "/overlay.png");
            if (overlay.exists()) {
                this.overlay_texture = new ExternalTextureResourceLocation(overlay.getPath());
            }
            this.prepared = true;
        }
    }

    public void render() {
        try {
            this.renderRaw(this.opacity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void renderRaw(float panoramaAlpha) {
        if (this.prepared) {
            this.time += Minecraft.func_71410_x().func_184121_ak() * this.speed;
            float pitch = MathHelper.func_76126_a((float)(this.time * 0.001f)) * 5.0f + this.angle;
            float yaw = -this.time * 0.1f;
            Minecraft mc = Minecraft.func_71410_x();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            Project.gluPerspective((float)this.fov, (float)((float)mc.func_147110_a().field_147621_c / (float)mc.func_147110_a().field_147618_d), (float)0.05f, (float)10.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            for (int j = 0; j < 4; ++j) {
                GlStateManager.func_179094_E();
                float f = ((float)(j % 2) / 2.0f - 0.5f) / 256.0f;
                float f1 = ((float)(j / 2) / 2.0f - 0.5f) / 256.0f;
                GlStateManager.func_179109_b((float)f, (float)f1, (float)0.0f);
                GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
                for (int k = 0; k < 6; ++k) {
                    ExternalTextureResourceLocation r = this.pano.get(k);
                    if (r == null) continue;
                    if (!r.isReady()) {
                        r.loadTexture();
                    }
                    mc.func_110434_K().func_110577_a(r.getResourceLocation());
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    int l = Math.round(255.0f * panoramaAlpha) / (j + 1);
                    if (k == 0) {
                        bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(-1.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(1.0, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                    }
                    if (k == 1) {
                        bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(1.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(1.0, 1.0, -1.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                    }
                    if (k == 2) {
                        bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(1.0, 1.0, -1.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(-1.0, 1.0, -1.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                    }
                    if (k == 3) {
                        bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(-1.0, 1.0, -1.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(-1.0, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                    }
                    if (k == 4) {
                        bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                    }
                    if (k == 5) {
                        bufferbuilder.func_181662_b(-1.0, 1.0, 1.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(-1.0, 1.0, -1.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(1.0, 1.0, -1.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, l).func_181675_d();
                        bufferbuilder.func_181662_b(1.0, 1.0, 1.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, l).func_181675_d();
                    }
                    tessellator.func_78381_a();
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            }
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179121_F();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179089_o();
            GlStateManager.func_179126_j();
            if (this.overlay_texture != null) {
                if (!this.overlay_texture.isReady()) {
                    this.overlay_texture.loadTexture();
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.overlay_texture.getResourceLocation());
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, this.opacity);
                ExternalTexturePanoramaRenderer.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)Minecraft.func_71410_x().field_71462_r.field_146294_l, (int)Minecraft.func_71410_x().field_71462_r.field_146295_m, (float)Minecraft.func_71410_x().field_71462_r.field_146294_l, (float)Minecraft.func_71410_x().field_71462_r.field_146295_m);
            }
        }
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public String getName() {
        return this.name;
    }

    public void setSpeed(float speed) {
        if (speed < 0.0f) {
            speed = 0.0f;
        }
        this.speed = speed;
    }

    public void setFov(float fov) {
        if (fov > 179.0f) {
            fov = 179.0f;
        }
        this.fov = fov;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }
}

