/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.playerentity;

import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.SelfcleaningDynamicTexture;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class SkinExternalTextureResourceLocation
extends ExternalTextureResourceLocation {
    protected boolean loaded = false;
    protected String path;
    protected InputStream in;
    protected int width = 0;
    protected int height = 0;
    protected ResourceLocation location;

    public SkinExternalTextureResourceLocation(String path) {
        super(path);
        this.path = path;
    }

    public void loadTexture() {
        if (!this.loaded) {
            try {
                if (Minecraft.func_71410_x().func_110434_K() == null) {
                    System.out.println("################################ WARNING ################################");
                    System.out.println("Can't load texture '" + this.path + "'! Minecraft TextureManager instance not ready yet!");
                    return;
                }
                File f = new File(this.path);
                this.in = new FileInputStream(f);
                BufferedImage i = ImageIO.read(this.in);
                this.width = i.getWidth();
                this.height = i.getHeight();
                if (this.height < 64) {
                    BufferedImage skinNew = new BufferedImage(64, 64, 2);
                    SkinExternalTextureResourceLocation.copyPixelAreaToNewImage(i, skinNew, 0, 0, 0, 0, 64, 32, false);
                    int xOffsetLeg = 16;
                    int yOffsetLeg = 32;
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 4, 16, 4, 4, xOffsetLeg, yOffsetLeg, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 8, 16, 4, 4, xOffsetLeg, yOffsetLeg, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 0, 20, 4, 12, xOffsetLeg + 8, yOffsetLeg, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 4, 20, 4, 12, xOffsetLeg, yOffsetLeg, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 8, 20, 4, 12, xOffsetLeg - 8, yOffsetLeg, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 12, 20, 4, 12, xOffsetLeg, yOffsetLeg, true);
                    int xOffsetArm = -8;
                    int yOffsetArm = 32;
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 44, 16, 4, 4, xOffsetArm, yOffsetArm, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 48, 16, 4, 4, xOffsetArm, yOffsetArm, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 40, 20, 4, 12, xOffsetArm + 8, yOffsetArm, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 44, 20, 4, 12, xOffsetArm, yOffsetArm, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 48, 20, 4, 12, xOffsetArm - 8, yOffsetArm, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 52, 20, 4, 12, xOffsetArm, yOffsetArm, true);
                    i = skinNew;
                }
                this.location = Minecraft.func_71410_x().func_110434_K().func_110578_a("externaltexture", (DynamicTexture)new SelfcleaningDynamicTexture(i));
                this.in.close();
                this.loaded = true;
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    public boolean isReady() {
        return this.loaded;
    }

    public String getPath() {
        return this.path;
    }

    protected static void copyPixelAreaToNewImage(BufferedImage in, BufferedImage out, int xFrom, int yFrom, int xTo, int yTo, int width, int height, boolean mirrorX) {
        int vertOffset = 0;
        int vertical = yTo;
        while (vertical < yTo + height) {
            int horiOffset = 0;
            if (mirrorX) {
                horiOffset = width - 1;
            }
            int horizontal = xTo;
            while (horizontal < xTo + width) {
                int pixel = in.getRGB(xFrom + horiOffset, yFrom + vertOffset);
                out.setRGB(horizontal, vertical, pixel);
                ++horizontal;
                if (mirrorX) {
                    --horiOffset;
                    continue;
                }
                ++horiOffset;
            }
            ++vertical;
            ++vertOffset;
        }
    }

    protected static void cloneSkinPart(BufferedImage in, int xStart, int yStart, int width, int height, int xOffset, int yOffset, boolean mirrorX) {
        SkinExternalTextureResourceLocation.copyPixelAreaToNewImage(in, in, xStart, yStart, xStart + xOffset, yStart + yOffset, width, height, mirrorX);
    }
}

