/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.AbstractGui;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.Screen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.TextStyle;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.component.AdvancedTextComponentString;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.component.Component;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.widget.AdvancedTextField;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.mixin.client.IMixinGuiTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextEditorLine
extends AdvancedTextField {
    private static final Logger LOGGER = LogManager.getLogger();
    public TextEditorScreen parent;
    protected String lastTickValue = "";
    public boolean isInMouseHighlightingMode = false;
    protected final FontRenderer font2;
    protected final boolean handleSelf2;
    public int textWidth = 0;
    public int lineIndex = 0;
    protected int currentHighlightPosXStart = 0;
    protected int currentHighlightPosXEnd = 0;
    protected int currentCharacterRenderIndex = 0;
    protected static boolean leftRightArrowWasDown = false;

    public TextEditorLine(FontRenderer font, int x, int y, int width, int height, boolean handleSelf, CharacterFilter characterFilter, TextEditorScreen parent) {
        super(font, x, y, width, height, handleSelf, characterFilter);
        this.parent = parent;
        this.font2 = font;
        this.handleSelf2 = handleSelf;
        this.setBordered(false);
    }

    @Override
    public void render(int mouseX, int mouseY, float partial) {
        if (this.isInEditorArea()) {
            super.render(mouseX, mouseY, partial);
        }
        this.lastTickValue = this.getValue();
    }

    /*
     * WARNING - void declaration
     */
    protected ITextComponent getFormattedText(String text) {
        void var5_7;
        ArrayList<AdvancedTextComponentString> chars = new ArrayList<AdvancedTextComponentString>();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            char c = cArray[var5_7];
            TextStyle style = TextStyle.EMPTY;
            for (TextEditorFormattingRule r : this.parent.formattingRules) {
                TextStyle rs = r.getStyle(c, this.currentCharacterRenderIndex, this.func_146198_h(), this, this.parent.currentRenderCharacterIndexTotal, this.parent);
                if (rs == null || rs == TextStyle.EMPTY) continue;
                style = rs.applyTo(style);
            }
            chars.add(Component.literal(String.valueOf(c)).setStyle(style));
            ++this.currentCharacterRenderIndex;
            ++this.parent.currentRenderCharacterIndexTotal;
            ++var5_7;
        }
        AdvancedTextComponentString comp = Component.literal("");
        for (ITextComponent iTextComponent : chars) {
            comp.func_150257_a(iTextComponent);
        }
        return comp;
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partial) {
        this.currentCharacterRenderIndex = 0;
        this.func_146193_g(this.parent.textColor.getRGB());
        this.setTextColorUneditable(this.parent.textColor.getRGB());
        if (this.isVisible()) {
            if (this.func_146206_l()) {
                TextEditorLine.fill(0, this.getY(), this.parent.field_146294_l, this.getY() + this.field_146219_i, this.parent.focusedLineColor.getRGB());
            }
            int textColorInt = this.isEditable() ? this.getAsAccessor().getTextColorFancyMenu() : this.getAsAccessor().getTextColorUneditableFancyMenu();
            int cursorPos = this.func_146198_h() - this.getAsAccessor().getDisplayPosFancyMenu();
            int highlightPos = this.getAsAccessor().getHighlightPosFancyMenu() - this.getAsAccessor().getDisplayPosFancyMenu();
            String text = this.getValue();
            boolean isCursorNotAtStartOrEnd = cursorPos >= 0 && cursorPos <= text.length();
            boolean renderCursor = this.func_146206_l() && this.getAsAccessor().getFrameFancyMenu() / 6 % 2 == 0 && isCursorNotAtStartOrEnd;
            int textX = this.getAsAccessor().getBorderedFancyMenu() ? this.getX() + 4 : this.getX() + 1;
            int textY = this.getAsAccessor().getBorderedFancyMenu() ? this.getY() + (this.field_146219_i - 8) / 2 : this.getY() + Math.max(0, this.getHeight() / 2) - this.font2.field_78288_b / 2;
            int textXRender = textX;
            if (highlightPos > text.length()) {
                highlightPos = text.length();
            }
            if (!text.isEmpty()) {
                String textBeforeCursor = isCursorNotAtStartOrEnd ? text.substring(0, cursorPos) : text;
                textXRender = AbstractGui.drawFormattedString(this.font2, this.getFormattedText(textBeforeCursor), textX, textY, textColorInt);
            }
            boolean isCursorAtEndOfLine = this.func_146198_h() < this.getValue().length() || this.getValue().length() >= this.getAsAccessor().getMaxLengthFancyMenu();
            int cursorPosRender = textXRender;
            if (!isCursorNotAtStartOrEnd) {
                cursorPosRender = cursorPos > 0 ? textX + this.field_146218_h : textX;
            } else if (isCursorAtEndOfLine) {
                cursorPosRender = textXRender - 1;
                --textXRender;
            }
            if (!text.isEmpty() && isCursorNotAtStartOrEnd && cursorPos < text.length()) {
                AbstractGui.drawFormattedString(this.font2, this.getFormattedText(text.substring(cursorPos)), textXRender, textY, textColorInt);
            }
            if (renderCursor) {
                if (isCursorAtEndOfLine) {
                    TextEditorLine.fill(cursorPosRender, textY - 1, cursorPosRender + 1, textY + 1 + 9, -3092272);
                } else {
                    AbstractGui.drawFormattedString(this.font2, (ITextComponent)Component.literal("_"), cursorPosRender, textY, textColorInt);
                }
            }
            if (highlightPos != cursorPos) {
                this.currentHighlightPosXStart = cursorPosRender;
                this.currentHighlightPosXEnd = textX + this.font2.func_78256_a(text.substring(0, highlightPos)) - 1;
                this.getAsAccessor().invokeRenderHighlightFancyMenu(this.currentHighlightPosXStart, textY - 1, this.currentHighlightPosXEnd, textY + 1 + 9);
            } else {
                this.currentHighlightPosXStart = 0;
                this.currentHighlightPosXEnd = 0;
            }
        }
    }

    public boolean isInEditorArea() {
        return this.getY() + this.getHeight() >= this.parent.getEditorAreaY() && this.getY() <= this.parent.getEditorAreaY() + this.parent.getEditorAreaHeight();
    }

    public boolean isHighlightedHovered() {
        if (this.isInEditorArea() && this.currentHighlightPosXStart != this.currentHighlightPosXEnd && this.isHovered()) {
            int mouseX = MouseInput.getMouseX();
            return mouseX >= Math.min(this.currentHighlightPosXStart, this.currentHighlightPosXEnd) && mouseX <= Math.max(this.currentHighlightPosXStart, this.currentHighlightPosXEnd);
        }
        return false;
    }

    public int getActualHeight() {
        int h = this.field_146219_i;
        if (this.getAsAccessor().getBorderedFancyMenu()) {
            h += 2;
        }
        return h;
    }

    public IMixinGuiTextField getAsAccessor() {
        return (IMixinGuiTextField)((Object)this);
    }

    @Override
    public void func_146190_e(int pos) {
        this.textWidth = this.font2.func_78256_a(this.getValue());
        super.func_146190_e(pos);
        if (pos != this.parent.lastCursorPosSetByUser && this.func_146206_l()) {
            this.parent.lastCursorPosSetByUser = this.func_146198_h();
        }
        this.parent.correctXScroll(this);
    }

    @Override
    public void tick() {
        if (!MouseInput.isLeftMouseDown() && this.isInMouseHighlightingMode) {
            this.isInMouseHighlightingMode = false;
        }
        super.tick();
        leftRightArrowWasDown = false;
    }

    @Override
    public boolean keyPressed(int keycode, int i1, int i2) {
        if (Screen.isCopy(keycode) || Screen.isPaste(keycode) || Screen.isSelectAll(keycode) || Screen.isCut(keycode)) {
            return false;
        }
        if (keycode == 14) {
            return false;
        }
        if ((keycode == 203 || keycode == 205) && this.parent.isInMouseHighlightingMode()) {
            return false;
        }
        if (keycode == 203) {
            if (!leftRightArrowWasDown) {
                if (this.parent.isLineFocused() && this.parent.getFocusedLine() == this && this.func_146198_h() <= 0 && this.parent.getLineIndex(this) > 0) {
                    leftRightArrowWasDown = true;
                    this.parent.goUpLine();
                    this.parent.getFocusedLine().moveCursorTo(this.parent.getFocusedLine().getValue().length());
                    this.parent.correctYScroll(0);
                    return true;
                }
            } else {
                return true;
            }
        }
        if (keycode == 205) {
            if (!leftRightArrowWasDown) {
                if (this.parent.isLineFocused() && this.parent.getFocusedLine() == this && this.func_146198_h() >= this.getValue().length() && this.parent.getLineIndex(this) < this.parent.getLineCount() - 1) {
                    leftRightArrowWasDown = true;
                    this.parent.goDownLine(false);
                    this.parent.getFocusedLine().moveCursorTo(0);
                    this.parent.correctYScroll(0);
                    return true;
                }
            } else {
                return true;
            }
        }
        return super.keyPressed(keycode, i1, i2);
    }

    @Override
    public void deleteChars(int i) {
        if (!this.parent.justSwitchedLineByWordDeletion) {
            if (this.func_146198_h() == 0 && this.parent.getFocusedLineIndex() > 0) {
                int lastLineIndex = this.parent.getFocusedLineIndex();
                this.parent.justSwitchedLineByWordDeletion = true;
                this.parent.goUpLine();
                this.parent.getFocusedLine().moveCursorToEnd();
                this.parent.getFocusedLine().insertText(this.getValue());
                this.parent.getFocusedLine().func_146190_e(this.parent.getFocusedLine().func_146198_h() - this.getValue().length());
                this.parent.getFocusedLine().setHighlightPos(this.parent.getFocusedLine().func_146198_h());
                if (lastLineIndex > 0) {
                    this.parent.removeLineAtIndex(this.parent.getFocusedLineIndex() + 1);
                    this.parent.correctYScroll(-1);
                }
            } else {
                super.deleteChars(i);
            }
        }
        this.textWidth = this.font2.func_78256_a(this.getValue());
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.parent.isMouseInsideEditorArea() || this.parent.rightClickContextMenu.isOpen()) {
            return false;
        }
        if (mouseButton == 0 && this.isHovered() && !this.isInMouseHighlightingMode && this.isVisible()) {
            if (!this.parent.isAtLeastOneLineInHighlightMode()) {
                this.parent.startHighlightLine = this;
            }
            this.isInMouseHighlightingMode = true;
            this.parent.setFocusedLine(Math.max(0, this.parent.getLineIndex(this)));
            super.mouseClicked(mouseX, mouseY, mouseButton);
            this.shiftPressed = false;
            this.setHighlightPos(this.func_146198_h());
        } else if (mouseButton == 0 && !this.isHovered()) {
            this.setHighlightPos(this.func_146198_h());
        }
        if (!this.isInMouseHighlightingMode && mouseButton == 0) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    @Override
    public void setValue(String p_94145_) {
        super.setValue(p_94145_);
        this.textWidth = this.font2.func_78256_a(this.getValue());
    }

    @Override
    public void insertText(String text) {
        super.insertText(text);
        this.textWidth = this.font2.func_78256_a(this.getValue());
    }

    @Override
    public void setMaxLength(int p_94200_) {
        super.setMaxLength(p_94200_);
        this.textWidth = this.font2.func_78256_a(this.getValue());
    }
}

