/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.ContextMenu;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class FMContextMenu
extends ContextMenu {
    protected boolean resetParentButtonOnClose = false;
    protected int cachedScreenWidth = 0;
    protected int cachedScreenHeight = 0;
    protected List<Integer> separators = new ArrayList<Integer>();

    public FMContextMenu() {
        super(20, 20, 0);
    }

    public void addContent(AdvancedButton button) {
        super.addContent(button);
        Color c = new Color(0, 0, 0, 0);
        button.setBackgroundColor(UIBase.getButtonIdleColor(), UIBase.getButtonHoverColor(), c, c, 0);
        button.ignoreBlockedInput = true;
        button.ignoreLeftMouseDownClickBlock = true;
    }

    public void addSeparator() {
        int i = this.content.size();
        if (!this.separators.contains(i)) {
            this.separators.add(i);
        }
    }

    public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
        for (AdvancedButton b : this.content) {
            b.setLabelShadow(false);
        }
        this.cachedScreenWidth = screenWidth;
        this.cachedScreenHeight = screenHeight;
        if (this.parent != null && this.parent instanceof FMContextMenu) {
            screenWidth = ((FMContextMenu)this.parent).cachedScreenWidth;
            screenHeight = ((FMContextMenu)this.parent).cachedScreenHeight;
        }
        int i = 20;
        for (AdvancedButton b : this.content) {
            int sw = Minecraft.func_71410_x().field_71466_p.func_78256_a(b.field_146126_j) + 12;
            if (b.field_146120_f > sw) {
                sw = b.field_146120_f;
            }
            if (sw <= i) continue;
            i = sw;
        }
        this.width = i;
        super.openMenuAt(x, y, screenWidth, screenHeight);
    }

    public void render(int mouseX, int mouseY, int screenWidth, int screenHeight) {
        if (this.parent != null && this.parent instanceof FMContextMenu) {
            screenWidth = ((FMContextMenu)this.parent).cachedScreenWidth;
            screenHeight = ((FMContextMenu)this.parent).cachedScreenHeight;
        }
        super.render(mouseX, mouseY, screenWidth, screenHeight);
        if (this.opened) {
            if (this.alwaysOnTop) {
                RenderUtils.setZLevelPre((int)400);
                this.renderBorder();
                this.renderSeparators();
                RenderUtils.setZLevelPost();
            } else {
                this.renderBorder();
                this.renderSeparators();
            }
        } else if (this.resetParentButtonOnClose) {
            this.parentButton = null;
        }
    }

    protected void renderSeparators() {
        if (!this.content.isEmpty()) {
            for (Integer i : this.separators) {
                if (this.content.size() < i + 1) continue;
                AdvancedButton b = (AdvancedButton)this.content.get(i);
                Color c = new Color(UIBase.getButtonBorderIdleColor().getRed(), UIBase.getButtonBorderIdleColor().getGreen(), UIBase.getButtonBorderIdleColor().getBlue(), 100);
                UIBase.func_73734_a((int)b.field_146128_h, (int)b.field_146129_i, (int)(b.field_146128_h + this.width), (int)(b.field_146129_i + 1), (int)c.getRGB());
            }
        }
    }

    protected void renderBorder() {
        if (!this.content.isEmpty()) {
            AdvancedButton b = (AdvancedButton)this.content.get(0);
            UIBase.func_73734_a((int)b.field_146128_h, (int)b.field_146129_i, (int)(b.field_146128_h + this.width), (int)(b.field_146129_i + 1), (int)UIBase.getButtonBorderIdleColor().getRGB());
            UIBase.func_73734_a((int)b.field_146128_h, (int)(b.field_146129_i + 1), (int)(b.field_146128_h + 1), (int)(b.field_146129_i + this.lastHeight), (int)UIBase.getButtonBorderIdleColor().getRGB());
            UIBase.func_73734_a((int)(b.field_146128_h + 1), (int)(b.field_146129_i + this.lastHeight - 1), (int)(b.field_146128_h + this.width), (int)(b.field_146129_i + this.lastHeight), (int)UIBase.getButtonBorderIdleColor().getRGB());
            UIBase.func_73734_a((int)(b.field_146128_h + this.width - 1), (int)(b.field_146129_i + 1), (int)(b.field_146128_h + this.width), (int)(b.field_146129_i + this.lastHeight - 1), (int)UIBase.getButtonBorderIdleColor().getRGB());
        }
    }

    public List<AdvancedButton> getContent() {
        return this.content;
    }

    public void resetParentButtonOnClose(boolean reset) {
        this.resetParentButtonOnClose = reset;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isHovered() {
        for (ContextMenu c : this.children) {
            if (!c.isHovered()) continue;
            return true;
        }
        return super.isHovered();
    }
}

