/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.armorunder.recipes;

import com.google.gson.JsonObject;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.armorunder.ModItems;
import org.jwaresoftware.mcmods.armorunder.recipes.ArmorRecipes;
import org.jwaresoftware.mcmods.armorunder.recipes.LinedArmorRecipeSkeleton;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.recipes.JR;

public final class BarrierReinforcedArmorRecipe
extends LinedArmorRecipeSkeleton {
    private final boolean _heat_shielding;

    BarrierReinforcedArmorRecipe(IRecipe template, boolean heat_protection) {
        super(template);
        this._heat_shielding = heat_protection;
    }

    public static final boolean isBarrierLining(Item item, boolean heat_shielding) {
        return heat_shielding ? item == ModItems.heatbarrier_boots_liner || item == ModItems.heatbarrier_chestplate_liner || item == ModItems.heatbarrier_helmet_liner || item == ModItems.heatbarrier_leggings_liner : item == ModItems.antifreeze_boots_liner || item == ModItems.antifreeze_chestplate_liner || item == ModItems.antifreeze_helmet_liner || item == ModItems.antifreeze_leggings_liner;
    }

    @Override
    protected boolean isLining(Item item) {
        return BarrierReinforcedArmorRecipe.isBarrierLining(item, this._heat_shielding);
    }

    @Override
    protected boolean canAddLining(ItemStack armorpiece) {
        return !Armory.hasXLining((ItemStack)armorpiece);
    }

    @Override
    protected Armory.XLining.Def getXLining(ItemStack lining) {
        return new Armory.XLining.Def(this._heat_shielding ? Armory.XLining.OBSIDIAN_SHIELD : Armory.XLining.ANTIFREEZE_SHIELD);
    }

    @Override
    protected boolean isEnabled() {
        return ArmorRecipes.SPECIAL_SETS && super.isEnabled();
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            boolean heat_protection = true;
            ShapelessOreRecipe impl = ShapelessOreRecipe.factory((JsonContext)context, (JsonObject)json);
            ItemStack out = impl.func_77571_b();
            if (!ItemStacks.isEmpty((ItemStack)out)) {
                Armory.XLining.Def defn = Armory.getXLining((ItemStack)out);
                Validate.isTrue((defn.name == Armory.XLining.OBSIDIAN_SHIELD || defn.name == Armory.XLining.ANTIFREEZE_SHIELD ? 1 : 0) != 0, (String)"Adding obsidian or antifreeze barrier liner", (Object[])new Object[0]);
                heat_protection = defn.name == Armory.XLining.OBSIDIAN_SHIELD;
            }
            impl = new JR.LegacyShapelessOreRecipe(null, impl);
            return new BarrierReinforcedArmorRecipe((IRecipe)impl, heat_protection);
        }
    }
}

