/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.armorunder.recipes;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.armorunder.ModItems;
import org.jwaresoftware.mcmods.armorunder.recipes.ArmorRecipes;
import org.jwaresoftware.mcmods.armorunder.recipes.LinedArmorRecipeSkeleton;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.recipes.JR;

public final class AutoregLinedArmorRecipe
extends LinedArmorRecipeSkeleton {
    static final String DICT_KEY_LINERS = "itemAutoregLining";
    private final int _modifier;

    static final void initSharedDictIds() {
        OreDictionary.registerOre((String)DICT_KEY_LINERS, (Item)ModItems.auto_chestplate_liner);
        OreDictionary.registerOre((String)DICT_KEY_LINERS, (Item)ModItems.auto_leggings_liner);
    }

    static final List<IRecipe> addSampleRecipes(List<IRecipe> recipes) {
        if (ArmorRecipes.ENABLED) {
            AutoregLinedArmorRecipe.addRecipes("itemChestplate", (Item)ModItems.auto_chestplate_liner, recipes, "chestplate");
            AutoregLinedArmorRecipe.addRecipes("itemLeggings", (Item)ModItems.auto_leggings_liner, recipes, "leggings");
        }
        return recipes;
    }

    AutoregLinedArmorRecipe(int modifier, IRecipe template) {
        super(template);
        this._modifier = modifier;
    }

    public static final boolean isAutoregLining(Item item) {
        return item == ModItems.auto_chestplate_liner || item == ModItems.auto_leggings_liner;
    }

    @Override
    protected boolean isLining(Item item) {
        return AutoregLinedArmorRecipe.isAutoregLining(item);
    }

    @Override
    protected boolean canAddLining(ItemStack armorpiece) {
        return !Armory.hasLining((ItemStack)armorpiece);
    }

    static final int normalizeOverride(int override) {
        return override == 0 ? 0 : (override < 0 ? -1 : 1);
    }

    static final int getTargetModifier(ItemStack lining, int defaultModifier) {
        int modifier = defaultModifier;
        if (lining.func_77942_o() && lining.func_77978_p().func_74764_b(NBT_MOD)) {
            int override = lining.func_77978_p().func_74762_e(NBT_MOD);
            modifier = AutoregLinedArmorRecipe.normalizeOverride(override);
        }
        return modifier;
    }

    static final void setTargetModifier(ItemStack lining, int override) {
        int modifier = AutoregLinedArmorRecipe.normalizeOverride(override);
        ItemStacks.getTagCompoundNonNull((ItemStack)lining).func_74768_a(NBT_MOD, modifier);
    }

    @Override
    protected Armory.XLining.Def getXLining(ItemStack lining) {
        int target = AutoregLinedArmorRecipe.getTargetModifier(lining, this._modifier);
        return new Armory.XLining.Def(Armory.XLining.TEMPERATURE_REGULATOR, target);
    }

    @Nullable
    public static final String getLiningModifierTooltip(ItemStack lining) {
        String value = null;
        int modifier = AutoregLinedArmorRecipe.getTargetModifier(lining, 0);
        if (modifier != 0) {
            value = Strings.translate((String)("tooltip.auw.xlining.ozzy." + (modifier < 0 ? "cooler" : "warmer")));
        }
        return value;
    }

    private static final void addRecipes(String shared_key, Item ozzy_liner, List<IRecipe> recipes, String rid) {
        Armory.XLining.Def defn = new Armory.XLining.Def(Armory.XLining.TEMPERATURE_REGULATOR, 0);
        ItemStack liner = new ItemStack(ozzy_liner);
        for (ItemStack unlined : OreDictionary.getOres((String)shared_key, (boolean)false)) {
            ItemStack lined = ItemStacks.copyItemStackSingle((ItemStack)unlined);
            Armory.setXLining((ItemStack)lined, (Armory.XLining.Def)defn);
            recipes.add((IRecipe)new ShapelessOreRecipe(null, lined, new Object[]{unlined, liner}));
        }
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            int modifier = JsonUtils.func_151208_a((JsonObject)json, (String)"modifier", (int)0);
            ShapelessOreRecipe impl = ShapelessOreRecipe.factory((JsonContext)context, (JsonObject)json);
            impl = new JR.LegacyShapelessOreRecipe(null, impl);
            return new AutoregLinedArmorRecipe(modifier, (IRecipe)impl);
        }
    }
}

