/*
 * Decompiled with CFR 0.152.
 */
package boatdeletebegone.mixin;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Chunk.class})
public abstract class ChunkMixin {
    @Final
    @Shadow
    private static Logger field_150817_t;
    @Final
    @Shadow
    public int field_76635_g;
    @Final
    @Shadow
    public int field_76647_h;

    @Inject(method={"addEntity"}, at={@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V")}, remap=false)
    public void additionallyCheckForVehicleChunkPos(Entity entity, CallbackInfo ci) {
        if (!this.hasValidVehicleNBT(entity.getEntityData())) {
            int entityChunkX = MathHelper.func_76128_c((double)(entity.field_70165_t / 16.0));
            int entityChunkZ = MathHelper.func_76128_c((double)(entity.field_70161_v / 16.0));
            field_150817_t.warn("Wrong location! ({}, {}) should be ({}, {}), {}", (Object)entityChunkX, (Object)entityChunkZ, (Object)this.field_76635_g, (Object)this.field_76647_h, (Object)entity);
            entity.func_70106_y();
        }
    }

    @Unique
    private boolean hasValidVehicleNBT(NBTTagCompound entityData) {
        if (entityData.func_74764_b("RiddenVehicle")) {
            NBTTagCompound vehiclePosNBT = entityData.func_74775_l("RiddenVehicle");
            int vehicleChunkX = vehiclePosNBT.func_74762_e("vehicleChunkX");
            int vehicleChunkZ = vehiclePosNBT.func_74762_e("vehicleChunkZ");
            return vehicleChunkX == this.field_76635_g && vehicleChunkZ == this.field_76647_h;
        }
        return false;
    }

    @Redirect(method={"addEntity"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"), remap=false)
    public void noVanillaWarn(Logger instance, String s, Object o1, Object o2, Object o3, Object o4, Object o5) {
    }

    @Redirect(method={"addEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;setDead()V"))
    public void noVanillaSetDead(Entity instance) {
    }
}

