/*
 * Decompiled with CFR 0.152.
 */
package boatdeletebegone.mixin;

import boatdeletebegone.mixin.EntityAccessor;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilChunkLoader.class})
public abstract class AnvilChunkLoaderMixin {
    @Inject(method={"readChunkEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;getTagList(Ljava/lang/String;I)Lnet/minecraft/nbt/NBTTagList;")})
    private static void insertVehicleNBTtoPassengers(NBTTagCompound vehicleNBT, World world, Chunk chunk, CallbackInfoReturnable<Entity> cir, @Local Entity entity) {
        int chunkZ;
        int chunkX;
        NBTTagCompound vehiclePosNBT;
        if (entity.getEntityData().func_74764_b("RiddenVehicle")) {
            vehiclePosNBT = entity.getEntityData().func_74775_l("RiddenVehicle");
            chunkX = vehiclePosNBT.func_74762_e("vehicleChunkX");
            chunkZ = vehiclePosNBT.func_74762_e("vehicleChunkZ");
        } else {
            vehiclePosNBT = vehicleNBT.func_150295_c("Pos", 6);
            double posX = vehiclePosNBT.func_150309_d(0);
            double posZ = vehiclePosNBT.func_150309_d(2);
            chunkX = MathHelper.func_76128_c((double)(posX / 16.0));
            chunkZ = MathHelper.func_76128_c((double)(posZ / 16.0));
        }
        NBTTagCompound riddenVehicleNBT = new NBTTagCompound();
        riddenVehicleNBT.func_74768_a("vehicleChunkX", chunkX);
        riddenVehicleNBT.func_74768_a("vehicleChunkZ", chunkZ);
        NBTTagList passengerListNBT = vehicleNBT.func_150295_c("Passengers", 10);
        for (int i = 0; i < passengerListNBT.func_74745_c(); ++i) {
            NBTTagCompound riderNBT = passengerListNBT.func_150305_b(i);
            if (riderNBT.func_74764_b("ForgeData")) {
                riderNBT.func_74775_l("ForgeData").func_74782_a("RiddenVehicle", (NBTBase)riddenVehicleNBT);
                continue;
            }
            NBTTagCompound riderNewForgeData = new NBTTagCompound();
            riderNewForgeData.func_74782_a("RiddenVehicle", (NBTBase)riddenVehicleNBT);
            riderNBT.func_74782_a("ForgeData", (NBTBase)riderNewForgeData);
        }
    }

    @ModifyReturnValue(method={"readChunkEntity"}, at={@At(value="RETURN")})
    private static Entity removeVehicleNBT(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity.getEntityData().func_74764_b("RiddenVehicle")) {
            entity.getEntityData().func_82580_o("RiddenVehicle");
        }
        if (entity.getEntityData().func_82582_d()) {
            ((EntityAccessor)entity).setCustomEntityData(null);
        }
        return entity;
    }
}

