/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.motion;

import com.endertech.minecraft.forge.messages.ForgeNetMsg;
import com.endertech.minecraft.forge.messages.ForgeNetMsgHandler;
import com.endertech.minecraft.mods.adhooks.Main;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BoostUpMsg
extends ForgeNetMsg {
    public float strength;

    public BoostUpMsg() {
    }

    public BoostUpMsg(float strength) {
        this.strength = strength;
    }

    public void sendTo(EntityPlayerMP player) {
        Main.instance.getConnection().sendToPlayer((IMessage)this, player);
    }

    public static class Handler
    extends ForgeNetMsgHandler<BoostUpMsg> {
        public IMessage onMessage(BoostUpMsg message, MessageContext ctx) {
            EntityPlayer player = this.getPlayer(ctx);
            if (player == null) {
                return null;
            }
            this.addScheduledTask(ctx, () -> {
                double motionY = player.field_70181_x;
                double strength = message.strength;
                double newMotionY = motionY + strength;
                double maxMotionY = 1.2 * strength;
                player.field_70181_x = newMotionY > maxMotionY ? Math.max(motionY, maxMotionY) : newMotionY;
            });
            return null;
        }
    }
}

