/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.items;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.ForgeKeys;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.messages.ForgeNetMsg;
import com.endertech.minecraft.forge.messages.ForgeNetMsgHandler;
import com.endertech.minecraft.forge.messages.Tooltip;
import com.endertech.minecraft.forge.units.IUnitWithMeshDefinition;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import com.endertech.minecraft.mods.adhooks.shot.HookShot;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Launcher
extends DamageableItem
implements IUnitWithMeshDefinition {
    public static final String TAG_HOOKSHOT_ID = "hookShotId";
    public static final FloatBounds REELING_SPEED_BOUNDS = new FloatBounds(Float.valueOf(0.1f), Float.valueOf(4.0f));
    public static final FloatBounds BOOST_STRENGTH_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(3.0f));
    public static final int DAMAGE_ON_SHOT = 1;
    @SideOnly(value=Side.CLIENT)
    protected static KeyBinding keyBindUserDrop;
    private Map<KeyBinding, WatchedKey> watchedKeys = new ConcurrentHashMap<KeyBinding, WatchedKey>();
    private Set<ItemStack> queuedShots = new HashSet<ItemStack>();
    public final HookType hookType;
    protected float reelingSpeed;
    protected float boostStrength;

    public Launcher(ForgeMod mod, String name, UnitConfig config, HookType hookType, int durability, float reelingSpeed, float boostStrength) {
        super(mod, config, name, CreativeTabs.field_78040_i, durability, UnitId.from((String)"string"));
        this.hookType = hookType;
        this.reelingSpeed = ForgeConfig.getFloat((ForgeConfig)config, (String)this.getUnitCategory(), (String)"reelingSpeed", (float)reelingSpeed, (FloatBounds)REELING_SPEED_BOUNDS, (String)"Defines how fast the launcher reels in the rope.");
        this.boostStrength = ForgeConfig.getFloat((ForgeConfig)config, (String)this.getUnitCategory(), (String)"boostStrength", (float)boostStrength, (FloatBounds)BOOST_STRENGTH_BOUNDS, (String)"Defines how high you will be thrown upward when boost is activated");
        this.setUnitVariants(Variants.class);
    }

    public float getReelingSpeed() {
        return this.reelingSpeed;
    }

    public boolean func_82788_x() {
        return false;
    }

    public float getBoostStrength() {
        return this.boostStrength;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> lines, ITooltipFlag flagIn) {
        GameSettings gs = ForgeKeys.getGameSettings();
        Tooltip tip = Tooltip.from(((Object)((Object)this)).getClass(), lines);
        if (ForgeKeys.isDown((KeyBinding)gs.field_151444_V)) {
            tip.add(TextFormatting.RED, "hook_strength", (Object)Float.valueOf(this.hookType.hook.getStrength()));
            tip.add(TextFormatting.GREEN, "rope_elasticity", (Object)Float.valueOf(this.hookType.rope.getElasticity()));
            tip.add(TextFormatting.YELLOW, "rope_max_length", (Object)this.hookType.rope.getMaxLength());
            tip.add(TextFormatting.AQUA, "reeling_speed", (Object)Float.valueOf(this.getReelingSpeed()));
            tip.add(TextFormatting.BLUE, "boostup_strength", (Object)Float.valueOf(this.getBoostStrength()));
        } else if (ForgeKeys.isDown((KeyBinding)gs.field_74311_E)) {
            tip.add("launch", new Object[]{TextFormatting.RED, ForgeKeys.getName((KeyBinding)gs.field_74312_F)});
            tip.add("reel_unhook", new Object[]{TextFormatting.GREEN, ForgeKeys.getName((KeyBinding)gs.field_74316_C), ForgeKeys.getName((KeyBinding)keyBindUserDrop)});
            tip.add("pull", new Object[]{TextFormatting.YELLOW, ForgeKeys.getName((KeyBinding)gs.field_74313_G)});
            tip.add("loosen", new Object[]{TextFormatting.AQUA, ForgeKeys.getName((KeyBinding)gs.field_74312_F)});
            tip.add("boost_up", new Object[]{TextFormatting.GOLD, ForgeKeys.getName((KeyBinding)gs.field_74316_C), ForgeKeys.getName((KeyBinding)keyBindUserDrop)});
            tip.add("release", new Object[]{TextFormatting.LIGHT_PURPLE, ForgeKeys.getName((KeyBinding)gs.field_74312_F), ForgeKeys.getName((KeyBinding)gs.field_74311_E)});
        } else {
            tip.add("more_info", new Object[]{ForgeKeys.getName((KeyBinding)gs.field_151444_V)});
            tip.add("controls", new Object[]{ForgeKeys.getName((KeyBinding)gs.field_74311_E)});
        }
    }

    public static boolean isAttached(ItemStack launcher) {
        return Launcher.stackHasLauncher(launcher) && launcher.func_77942_o() && launcher.func_77978_p().func_74764_b(TAG_HOOKSHOT_ID);
    }

    public static boolean isAttachedToHookShot(ItemStack launcher, HookShot hookShot) {
        return Launcher.isAttached(launcher) && hookShot != null && Launcher.getAttachedHookShotId(launcher) == hookShot.func_145782_y();
    }

    public static int getAttachedHookShotId(ItemStack launcher) {
        if (launcher != null && launcher.func_77942_o()) {
            return launcher.func_77978_p().func_74762_e(TAG_HOOKSHOT_ID);
        }
        return 0;
    }

    public static boolean stackHasLauncher(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof Launcher;
    }

    @Nullable
    public static HookShot findAttachedHookShot(ItemStack launcher, World world) {
        Entity entity;
        if (Launcher.isAttached(launcher) && world != null && (entity = world.func_73045_a(Launcher.getAttachedHookShotId(launcher))) instanceof HookShot) {
            return (HookShot)entity;
        }
        return null;
    }

    @Nullable
    public static ItemStack findAttachedLauncher(InventoryPlayer inventory, HookShot hookShot) {
        if (inventory != null && inventory.field_70462_a != null && hookShot != null) {
            for (ItemStack stack : inventory.field_70462_a) {
                if (!Launcher.isAttachedToHookShot(stack, hookShot)) continue;
                return stack;
            }
        }
        return null;
    }

    public static void attachToHookShot(ItemStack launcher, HookShot hookShot) {
        if (Launcher.stackHasLauncher(launcher) && hookShot != null) {
            Launcher.ensureHasNBT((ItemStack)launcher);
            NBTTagCompound tag = launcher.func_77978_p();
            tag.func_74768_a(TAG_HOOKSHOT_ID, hookShot.func_145782_y());
        }
    }

    public static void unattach(ItemStack launcher) {
        if (Launcher.stackHasLauncher(launcher) && Launcher.hasNBT((ItemStack)launcher)) {
            launcher.func_77978_p().func_82580_o(TAG_HOOKSHOT_ID);
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        Launcher.ensureHasNBT((ItemStack)stack);
    }

    public boolean onDroppedByPlayer(ItemStack launcher, EntityPlayer player) {
        HookShot hookShot;
        if (ForgeEntity.isServerSide((Entity)player) && (hookShot = Launcher.findAttachedHookShot(launcher, player.field_70170_p)) != null) {
            return false;
        }
        if (player.func_184587_cr()) {
            return false;
        }
        return super.onDroppedByPlayer(launcher, player);
    }

    public boolean onLeftClickEntity(ItemStack launcher, EntityPlayer player, Entity entity) {
        return this.hookType != HookType.PUDGE;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void queueShot(ItemStack launcher) {
        this.queuedShots.add(launcher);
    }

    protected void makeShot(ItemStack launcher, World world, EntityLivingBase shooter) {
        if (this.isServerSide(world) && this.hookType != HookType.PROTOTYPE && Launcher.notBroken((ItemStack)launcher)) {
            HookShot hookShot = new HookShot(world, shooter, this.hookType);
            world.func_72838_d((Entity)hookShot);
            Launcher.attachToHookShot(launcher, hookShot);
            Launcher.damageItem((int)1, (ItemStack)launcher, (EntityLivingBase)shooter, (boolean)false);
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
        if (keyBindUserDrop == null) {
            keyBindUserDrop = ForgeKeys.createBindingFor((String)"unhook", (int)45, (ForgeKeys.KeyCategories)ForgeKeys.KeyCategories.GAMEPLAY);
        }
        GameSettings gs = ForgeKeys.getGameSettings();
        this.watchedKeys.put(gs.field_74312_F, WatchedKey.of(HookShot.WatchedBool.LOOSENING));
        this.watchedKeys.put(gs.field_74313_G, WatchedKey.of(HookShot.WatchedBool.PULLING));
        this.watchedKeys.put(gs.field_74316_C, WatchedKey.of(HookShot.WatchedBool.DROPPING));
        this.watchedKeys.put(keyBindUserDrop, WatchedKey.of(HookShot.WatchedBool.DROPPING));
        this.watchedKeys.put(gs.field_74351_w, WatchedKey.of(HookShot.WatchedBool.MOVING_FORWARD));
        this.watchedKeys.put(gs.field_74368_y, WatchedKey.of(HookShot.WatchedBool.MOVING_BACKWARD));
        this.watchedKeys.put(gs.field_74370_x, WatchedKey.of(HookShot.WatchedBool.MOVING_LEFT));
        this.watchedKeys.put(gs.field_74366_z, WatchedKey.of(HookShot.WatchedBool.MOVING_RIGHT));
        this.watchedKeys.put(gs.field_74314_A, WatchedKey.of(HookShot.WatchedBool.JUMPING));
    }

    public UnitVariant getVariantFor(ItemStack stack) {
        return Launcher.isBroken((ItemStack)stack) || Launcher.isAttached(stack) ? this.getVariant((Object)Variants.EMPTY) : this.getVariant((Object)Variants.NORMAL);
    }

    @SideOnly(value=Side.CLIENT)
    public void processPressedKeys() {
        if (!ForgeKeys.affectPlayer()) {
            return;
        }
        for (Map.Entry<KeyBinding, WatchedKey> entry : this.watchedKeys.entrySet()) {
            KeyBinding keyBinding = entry.getKey();
            WatchedKey watchedKey = entry.getValue();
            boolean isKeyDown = ForgeKeys.isDown((KeyBinding)keyBinding);
            if (watchedKey.value == isKeyDown) continue;
            watchedKey.value = isKeyDown;
            KeyPressedMsg message = new KeyPressedMsg(watchedKey);
            this.getMod().getConnection().sendToServer((IMessage)message);
        }
    }

    public void func_77663_a(ItemStack launcher, World world, Entity shooter, int inventorySlot, boolean isCurrentItem) {
        if (this.isClientSide(world) && isCurrentItem) {
            this.processPressedKeys();
        }
        if (this.isServerSide(world) && shooter instanceof EntityLivingBase && this.queuedShots.contains(launcher)) {
            this.makeShot(launcher, world, (EntityLivingBase)shooter);
            this.queuedShots.remove(launcher);
        }
        super.func_77663_a(launcher, world, shooter, inventorySlot, isCurrentItem);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return true;
    }

    static class WatchedKey {
        public final HookShot.WatchedBool parameter;
        public boolean value = false;

        public WatchedKey(HookShot.WatchedBool parameter, boolean value) {
            this.parameter = parameter;
            this.value = value;
        }

        public static WatchedKey of(HookShot.WatchedBool parameter) {
            return new WatchedKey(parameter, false);
        }
    }

    private static enum Variants implements IForgeEnum
    {
        NORMAL,
        EMPTY;


        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }
    }

    public static class KeyPressedMsg
    extends ForgeNetMsg {
        public HookShot.WatchedBool parameter;
        public boolean value;

        public KeyPressedMsg() {
        }

        public KeyPressedMsg(WatchedKey key) {
            this.parameter = key.parameter;
            this.value = key.value;
        }

        public static class Handler
        extends ForgeNetMsgHandler<KeyPressedMsg> {
            public IMessage onMessage(KeyPressedMsg message, MessageContext ctx) {
                World world = this.getWorld(ctx);
                EntityPlayer player = this.getPlayer(ctx);
                if (world != null && player != null) {
                    this.addScheduledTask(ctx, () -> {
                        ItemStack stack = player.field_71071_by.func_70448_g();
                        if (Launcher.stackHasLauncher(stack)) {
                            if (Launcher.isAttached(stack)) {
                                HookShot hookShot = Launcher.findAttachedHookShot(stack, world);
                                if (hookShot != null) {
                                    hookShot.func_184212_Q().func_187227_b(message.parameter.key, (Object)message.value);
                                } else {
                                    Launcher.unattach(stack);
                                }
                            } else if (message.parameter == HookShot.WatchedBool.LOOSENING && message.value) {
                                Launcher launcher = (Launcher)stack.func_77973_b();
                                launcher.queueShot(stack);
                            }
                        }
                    });
                }
                return null;
            }
        }
    }
}

