/*
 * Decompiled with CFR 0.152.
 */
package furnacexpstorage.util;

import furnacexpstorage.ConfigHandler;
import furnacexpstorage.FurnaceXPStorage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SmeltItemHelper {
    private static final Map<Item, Map<Integer, Float>> experienceListByInput = new HashMap<Item, Map<Integer, Float>>();

    public static void addFurnaceRecipe(ItemStack input, float experience) {
        if (!experienceListByInput.containsKey(input.func_77973_b())) {
            experienceListByInput.put(input.func_77973_b(), new HashMap());
        }
        if (ConfigHandler.recreateVanillaLimit) {
            experience = Math.min(experience, 1.0f);
        }
        if (experienceListByInput.get(input.func_77973_b()).containsKey(input.func_77960_j())) {
            FurnaceXPStorage.LOGGER.warn("FurnaceXPStorage: Registering smelting recipe that was already registered with {} xp: input item {} metadata {} new xp {}", (Object)experienceListByInput.get(input.func_77973_b()).get(input.func_77960_j()), (Object)input.func_77973_b().getRegistryName().toString(), (Object)input.func_77960_j(), (Object)Float.valueOf(experience));
        }
        experienceListByInput.get(input.func_77973_b()).put(input.func_77960_j(), Float.valueOf(experience));
    }

    public static float getSmeltingExperience(ItemStack input, ItemStack output) {
        float ret = output.func_77973_b().getSmeltingExperience(output);
        if (ret != -1.0f) {
            return ret;
        }
        Map tmp = experienceListByInput.getOrDefault(input.func_77973_b(), Collections.emptyMap());
        return tmp.getOrDefault(input.func_77960_j(), tmp.getOrDefault(Short.MAX_VALUE, Float.valueOf(0.0f))).floatValue();
    }

    public static void clear() {
        experienceListByInput.clear();
    }

    public static void removeRecipeFor(ItemStack input) {
        experienceListByInput.get(input.func_77973_b()).remove(input.func_77960_j());
        if (experienceListByInput.get(input.func_77973_b()).isEmpty()) {
            experienceListByInput.remove(input.func_77973_b());
        }
    }

    public static void storeXpFromSmelting(ItemStack inputStack, ItemStack cookedStack, NBTTagCompound tileData) {
        float xp = SmeltItemHelper.getSmeltingExperience(inputStack, cookedStack);
        tileData.func_74776_a("StoredXP", tileData.func_74760_g("StoredXP") + (xp *= (float)cookedStack.func_190916_E()));
    }
}

