/*
 * Decompiled with CFR 0.152.
 */
package furnacexpstorage.handler;

import furnacexpstorage.FurnaceXPStorage;
import net.minecraft.block.BlockFurnace;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class BlockBreakHandler {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        int orbXP;
        int outXP;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        if (!(event.getState().func_177230_c() instanceof BlockFurnace)) {
            return;
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityFurnace)) {
            return;
        }
        TileEntityFurnace furnace = (TileEntityFurnace)world.func_175625_s(pos);
        if (furnace == null) {
            return;
        }
        NBTTagCompound nbt = furnace.getTileData();
        if (!nbt.func_74764_b("StoredXP")) {
            return;
        }
        nbt.func_74776_a("StoredXP", 0.0f);
        if (outXP < 0) {
            return;
        }
        for (outXP = BlockBreakHandler.getRandXP(nbt.func_74760_g("StoredXP")); outXP > 0; outXP -= orbXP) {
            orbXP = EntityXPOrb.func_70527_a((int)outXP);
            world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), orbXP));
        }
    }

    public static int getRandXP(float storedXP) {
        int outXP = MathHelper.func_76141_d((float)storedXP);
        if (FurnaceXPStorage.RAND.nextFloat() < storedXP - (float)outXP) {
            ++outXP;
        }
        return outXP;
    }
}

