/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.util;

import cursedflames.bountifulbaubles.block.GenericBlock;
import cursedflames.bountifulbaubles.block.GenericTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper {
    final String modID;
    List<GenericBlock> blocks = new ArrayList<GenericBlock>();
    List<ItemBlock> itemBlocks = new ArrayList<ItemBlock>();
    List<Item> items = new ArrayList<Item>();
    List<Item> defaultItemModels = new ArrayList<Item>();
    List<GenericBlock> defaultItemBlockModels = new ArrayList<GenericBlock>();
    Map<String, Class<? extends TileEntity>> tileEntities = new HashMap<String, Class<? extends TileEntity>>();
    GenericBlock recentBlock = null;
    Item recentItem = null;
    boolean autoaddItemModels = false;
    boolean autoaddItemBlocks = false;
    public boolean useOldTileEntityNaming = true;

    public boolean doesAutoaddItemModels() {
        return this.autoaddItemModels;
    }

    public void setAutoaddItemModels(boolean autoaddItemModels) {
        this.autoaddItemModels = autoaddItemModels;
    }

    public boolean doesAutoaddItemBlocks() {
        return this.autoaddItemBlocks;
    }

    public void setAutoaddItemBlocks(boolean autoaddItemBlocks) {
        this.autoaddItemBlocks = autoaddItemBlocks;
    }

    public RegistryHelper(String modID) {
        this.modID = modID;
    }

    public RegistryHelper addBlock(GenericBlock block) {
        this.blocks.add(block);
        this.recentBlock = block;
        if (this.autoaddItemBlocks) {
            this.addItemBlock(block);
        }
        return this;
    }

    public RegistryHelper addItemBlock() {
        return this.addItemBlock(this.recentBlock);
    }

    public RegistryHelper addItemBlock(GenericBlock block) {
        this.itemBlocks.add((ItemBlock)new ItemBlock((Block)block).setRegistryName(block.getRegistryName()));
        return this;
    }

    public RegistryHelper addItemBlock(ItemBlock block) {
        this.itemBlocks.add(block);
        return this;
    }

    public RegistryHelper addItem(Item item) {
        this.items.add(item);
        this.recentItem = item;
        if (this.autoaddItemModels) {
            this.addItemModel(item);
        }
        return this;
    }

    public RegistryHelper addItemModel() {
        return this.addItemModel(this.recentItem);
    }

    public RegistryHelper addItemModel(Item item) {
        this.defaultItemModels.add(item);
        return this;
    }

    public RegistryHelper addItemBlockModel() {
        return this.addItemBlockModel(this.recentBlock);
    }

    public RegistryHelper addItemBlockModel(GenericBlock block) {
        this.defaultItemBlockModels.add(block);
        return this;
    }

    public RegistryHelper addTileEntity(String name, Class<? extends GenericTileEntity> te) {
        this.tileEntities.put(name, te);
        return this;
    }

    public void registerBlocks(RegistryEvent.Register<Block> event) {
        for (GenericBlock genericBlock : this.blocks) {
            event.getRegistry().register((IForgeRegistryEntry)genericBlock);
        }
        for (Map.Entry entry : this.tileEntities.entrySet()) {
            GameRegistry.registerTileEntity((Class)((Class)entry.getValue()), (String)(this.modID + (this.useOldTileEntityNaming ? "_" : ":") + "tileentity_" + (String)entry.getKey()));
        }
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : this.itemBlocks) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : this.items) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (GenericBlock block : this.defaultItemBlockModels) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
        }
        for (Item item : this.defaultItemModels) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }
}

