/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.paintinggui.packet;

import com.mcf.davidee.paintinggui.mod.PaintingSelection;
import com.mcf.davidee.paintinggui.packet.CPacketPainting;
import com.mcf.davidee.paintinggui.packet.NetworkHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SPacketPainting
implements IMessage {
    public int id;
    public String[] art;

    public SPacketPainting() {
    }

    public SPacketPainting(int toSend, String[] data) {
        this.id = toSend;
        this.art = data;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.art.length);
        for (int i = 0; i < this.art.length; ++i) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.art[i]);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        String[] s = new String[buf.readInt()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        this.art = s;
    }

    public static class SPaintingMessageHandler
    implements IMessageHandler<SPacketPainting, IMessage> {
        public IMessage onMessage(SPacketPainting message, MessageContext ctx) {
            ((WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p).func_152344_a(() -> this.handleServerSide(ctx.getServerHandler().field_147369_b, message));
            return null;
        }

        private void handleServerSide(EntityPlayerMP player, SPacketPainting packet) {
            if (packet.art.length == 1) {
                EntityPainting.EnumArt enumArt = this.getEnumArt(packet.art[0]);
                Entity e = player.field_70170_p.func_73045_a(packet.id);
                if (e instanceof EntityPainting) {
                    this.setPaintingArt((EntityPainting)e, enumArt);
                    NetworkHandler.NETWORK.sendToDimension((IMessage)new CPacketPainting(packet.id, new String[]{enumArt.field_75702_A}), e.field_71093_bK);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7Error - Could not locate painting"));
                }
            } else {
                Entity e = player.field_70170_p.func_73045_a(packet.id);
                if (e instanceof EntityPainting) {
                    EntityPainting painting = (EntityPainting)e;
                    EntityPainting.EnumArt origArt = painting.field_70522_e;
                    ArrayList<EntityPainting.EnumArt> validArts = new ArrayList<EntityPainting.EnumArt>();
                    for (EntityPainting.EnumArt art : EntityPainting.EnumArt.values()) {
                        this.setPaintingArt(painting, art);
                        if (!painting.func_70518_d()) continue;
                        validArts.add(art);
                    }
                    EntityPainting.EnumArt[] validArtsArray = validArts.toArray(new EntityPainting.EnumArt[0]);
                    Arrays.sort(validArtsArray, PaintingSelection.ART_COMPARATOR);
                    String[] names = new String[validArtsArray.length];
                    for (int i = 0; i < validArtsArray.length; ++i) {
                        names[i] = validArtsArray[i].field_75702_A;
                    }
                    NetworkHandler.NETWORK.sendTo((IMessage)new CPacketPainting(packet.id, names), player);
                    this.setPaintingArt(painting, origArt);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cError - Could not locate painting"));
                }
            }
        }

        protected EntityPainting.EnumArt getEnumArt(String artName) {
            for (EntityPainting.EnumArt art : EntityPainting.EnumArt.values()) {
                if (!art.field_75702_A.equals(artName)) continue;
                return art;
            }
            return EntityPainting.EnumArt.KEBAB;
        }

        protected void setPaintingArt(EntityPainting p, EntityPainting.EnumArt art) {
            NBTTagCompound tag = new NBTTagCompound();
            p.func_70014_b(tag);
            tag.func_74778_a("Motive", art.field_75702_A);
            p.func_70037_a(tag);
        }
    }
}

